C***********************************************************************
      SUBROUTINE TRUSS(A,U,F,IA,NG,NE,TASK)
C=======================================================================
C     Program to set up things related to truss model
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (ME=20) 
      DIMENSION A(*),U(*),F(*),IA(1),LM(ME),LEN(ME),XYZ(3*ME),EK(ME*ME)
      CHARACTER*78 TASK
C
      ID=IODEV('IDARR')
      IEN=IODEV('IENAR')
C
      NEQ  =IGETPA('NSPAR','NEQ  ',0)
      NDIM =IGETPA('NSPAR','NDIM ',0)
      NBAND=IGETPA('NSPAR','NBAND',0)
      IMETH=IGETPA('NSPAR','IMETH',0)
      NEL  =IGETPA('NEPAR','NEL  ',NG)
      NENOD=IGETPA('NEPAR','NENOD',NG)
      NDOF =IGETPA('NEPAR','NDOF ',NG)
      IEQEL=IGETPA('NEPAR','IEQEL',NG)
      NEDOF=NENOD*NDOF
C
      IF(INDEX(TASK,'FORM-MATRIX').NE.0)  THEN
         DO 200 N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            IF((IEQEL.NE.1).OR.(N.EQ.1)) THEN
               CALL COORD(XYZ,NDIM,LEN,NENOD)
               CALL TRUSSK(EK,XYZ,NENOD,NDOF,NDIM,MAT,LSE,NG,NE)
            END IF
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL ASSEM(A,IA,EK,LM,NEDOF,NE)
 200     CONTINUE
      ELSE IF(INDEX(TASK,'COMPUTE').NE.0)  THEN
         IPLOT=IODEV('PLOT') 
         WRITE(IPLOT,5000) NG
         WRITE(IPLOT,5100) 
         DO 300 N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            CALL COORD(XYZ,NDIM,LEN,NENOD)
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL TRUSSR(U,XYZ,NENOD,LM,NDIM,MAT,LSE,NG,NE)
 300     CONTINUE
      END IF
C
 5000 FORMAT(' Element group ',I3,' ---- TRUSS elements')
 5100 FORMAT(' Elem # ip #      Force         Stress ')
      END
C***********************************************************************
      SUBROUTINE TRUSSK(EK,XYZ,NENOD,NDOF,NDIM,MAT,LSE,NG,N)
C=======================================================================
C     Program to set up the stiffness matrix for truss element
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (MW=3,MD=6,NB=1)
      DIMENSION EK(1),XYZ(1)
      DIMENSION WGTH(MW),SK(MW),B(MD),FX(MD),DCO(MD)
      CHARACTER*78 LABEL
C
      IOUT =IODEV('OUTPU')
      IPLOT=IODEV('PLOT')
      NEDOF=NENOD*NDOF
C
      NIP=IGETPA('NEPAR','NIX  ',NG)
      CALL GAUSSP(SK,WGTH,NIP)
      CALL FZERO(EK,NEDOF*NEDOF)
      EE=FGETPA('CPARA','EX   ',MAT)
      AA=FGETPA('SPARA','AA   ',LSE)
C
      DO 400 IP=1,NIP
         X=SK(IP)
         CALL SIFL(X,FX,1,1,IOUT)
         CALL JACTRU(DET,FX,DCO,XYZ,NENOD,NDIM,N,IOUT)
         CALL FZERO(B,NEDOF)
         CALL BMTRUS(B,FX,DCO,NENOD,NDOF)
         WT=WGTH(IP)*DET*EE*AA
         CALL BTDB(EK,B,WT,NEDOF,NB,NB,NB)
 400  CONTINUE

      RETURN
      END
C***********************************************************************
      SUBROUTINE BMTRUS(B,FX,DCO,NOD,NDOF)
C=======================================================================
C     Program to form the B-matrix for truss element
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION B(1),FX(1),DCO(1)
C
      DO 120 I=1,NOD
         K=(I-1)*NDOF
         DO 100 J=1,NDOF
            B(K+J)=DCO(J)*FX(I)
 100     CONTINUE
 120  CONTINUE
C     
      RETURN
      END
C***********************************************************************
      SUBROUTINE JACTRU(DET,FX,DCO,XYZ,NENOD,NDIM,N,IOUT)
C=======================================================================
C     Program to compute the Jacobian determinant and direction cosines
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION FX(1),DCO(1),XYZ(NENOD,1)
C
      DET=0.D0
      DO 200 I=1,NDIM
         DUM=DDOT(NENOD,FX,1,XYZ(1,I),1)
         DCO(I)=DUM
         DET=DET+DUM*DUM
 200  CONTINUE
      DET=SQRT(DET)
      IF(DET.LE.0.D0) THEN
         WRITE(IOUT,5000) N,DET
         STOP
      END IF
      DETINV=1.D0/DET
      CALL DSCAL(NENOD,DETINV,FX,1)
      CALL DSCAL(NDIM,DETINV,DCO,1)
C
 5000 FORMAT(' *** ERROR *** NEGATIVE OR ZERO JACOBIAN IN ELEMENT '
     &       ,I6,E12.3) 
      END
C***********************************************************************
      SUBROUTINE TRUSSR(U,XYZ,NENOD,LM,NDIM,MAT,LSE,NG,N)
C=======================================================================
C     Program to internal force
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (MW=3,MD=6,NB=1)
      DIMENSION U(*),XYZ(*),LM(*)
      DIMENSION WGTH(MW),SK(MW),B(MD),FX(MD),DCO(MD),UL(MD)
      CHARACTER*78 LABEL
C
      IOUT= IODEV('OUTPU')
      IPLOT=IODEV('PLOT')
      NEDOF=NENOD*NDIM
C
      NIP=IGETPA('NEPAR','NIX  ',NG)
      CALL GAUSSP(SK,WGTH,NIP)
      EE=FGETPA('CPARA','EX   ',MAT)
      AA=FGETPA('SPARA','AA   ',LSE)
C
      CALL FZERO(UL,NEDOF)
      CALL GETELV(UL,U,LM,NEDOF)
C
      DO 400 IP=1,NIP
         X = SK(IP)
         CALL SIFL(X,FX,1,1,IOUT)
         CALL JACTRU(DET,FX,DCO,XYZ,NENOD,NDIM,N,IOUT)
         CALL FZERO(B,NEDOF)
         CALL BMTRUS(B,FX,DCO,NENOD,NDIM)
         EPS = 0.D0
         CALL MULTF(EPS,B,UL,1,1,NEDOF)
         SIG = EE*EPS
         FN  = AA*SIG
         WRITE(IPLOT,5100) N,IP,FN,SIG
 400  CONTINUE

 5100 FORMAT(1X,I6,I4,2(1PE14.5))
      END
C***********************************************************************
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C-***-END-OF-FILE-******************************************************
