C***********************************************************************

* (C) SPARSLAB MODULE NAME=TSTPERM
*
* PURPOSE:
*  TEST OF CORRECTNESS OF AN INPUT PERMUTATION VECTOR.
*
* HISTORY:
*   ORIGINAL VERSION FOR SPARSELAB - TU - 4/1/1998.
*
* PARAMETERS:
*  II  N  VECTOR SIZE.
*  II  PERM(N)  PERMUTATION VECTOR.
*  IA  WN01(N)  AUXILIARY VECTOR.
*
      SUBROUTINE TSTPERM(N,PERM,WN01)
C
C GLOBALS
      INTEGER N
      INTEGER PERM(*),WN01(*)
C
C LOCALS
      INTEGER I,J,IER
C
C START OF TSTPERM
C
      IER=0
      CALL IZERO(WN01,N)
C
      DO I=1,N
        J=PERM(I)
        WN01(J)=WN01(J)+1
      END DO
      DO I=1,N
        J=WN01(I)
        IF(J.EQ.0) THEN
           WRITE(*,*) ' PERM corrupted -- missing value ',I
          IER=1
        ELSEIF(J.GT.1) THEN
           WRITE(*,*) ' PERM corrupted -- doubled value ',I
          IER=1
        END IF
      END DO
      IF(IER.EQ.1) STOP
C
      RETURN
C
C END OF TSTPERM
C
      END
C***********************************************************************

* SUBROUTINE UXVSIP                ALL SYSTEMS                88/12/01
C PORTABILITY : ALL SYSTEMS
C 88/12/01 TU : ORIGINAL VERSION
*
* PURPOSE :
* THE VECTOR OF THE INVERSE PERMUTATION OF THE PERMUTATION
* VECTOR PERM IS COMPUTED.
*
* PARAMETERS :
*  II  N LENGTH OF VECTORS.
*  II  PERM(N) INPUT PERMUTATION VECTOR.
*  IO  INVP(N) INVERSE PERMUTATION VECTOR.
*
      SUBROUTINE UXVSIP(N,PERM,INVP)
      INTEGER N,PERM(N),INVP(N)
      INTEGER I,J
CC
      DO 100 I=1,N
      J=PERM(I)
      INVP(J)=I
100   CONTINUE
      RETURN
      END
C***********************************************************************
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C****-END-OF-FILE-******************************************************
