C***********************************************************************
      SUBROUTINE SOLID(A,U,F,IA,NG,NE,TASK)
C=======================================================================
C     Program to set up things related to solid model
C=======================================================================
      IMPLICIT NONE
      DOUBLE PRECISION A(*),U(*),F(*)
      INTEGER          IA(1)
      CHARACTER*78     TASK
C --- local variables --------------------------------------------------
      INTEGER          ME,ID,IEN,IODEV,IGETPA,NEQ,NDIM,NEL,NENOD,NDOF,
     &                 IEQEL,NEDOF,N,NE,J,NG,MAT,LSE,IPLOT,IETYP
      PARAMETER       (ME=40) 
      INTEGER          LM(ME),LEN(ME)
      DOUBLE PRECISION EK(ME*ME),XYZ(3*ME)
      CHARACTER*13     LABEL
C
      ID  = IODEV('IDARR')
      IEN = IODEV('IENAR')
C
      NEQ   = IGETPA('NSPAR','NEQ  ',0)
      NDIM  = IGETPA('NSPAR','NDIM ',0)
      NEL   = IGETPA('NEPAR','NEL  ',NG)
      NENOD = IGETPA('NEPAR','NENOD',NG)
      NDOF  = IGETPA('NEPAR','NDOF ',NG)
      IEQEL = IGETPA('NEPAR','IEQEL',NG)
      NEDOF = NENOD*NDOF
C
      IF(INDEX(TASK,'FORM-MATRIX').NE.0)  THEN
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            IF((IEQEL.NE.1).OR.(N.EQ.1)) THEN
               CALL COORD(XYZ,NDIM,LEN,NENOD)
               CALL SOLIDK(EK,XYZ,NENOD,NDOF,NDIM,MAT,LSE,NG,NE)
            END IF
C
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL ASSEM(A,IA,EK,LM,NEDOF,NE)
         END DO
      ELSE IF(INDEX(TASK,'LOAD').NE.0) THEN
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            CALL COORD(XYZ,NDIM,LEN,NENOD)
            CALL SOLIDS(EK,XYZ,NENOD,NDOF,NDIM,MAT,LSE,NG,NE)
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL ADDRHS(F,EK,LM,NEDOF)
         END DO
      ELSE IF(INDEX(TASK,'COMPUTE').NE.0)  THEN
C
         IF(NDIM.EQ.2) THEN
            IETYP = IGETPA('NEPAR','IETYP',NG)
            IF(IETYP.EQ.0) THEN
               LABEL = 'Plane strain '
            ELSE IF(IETYP.EQ.1) THEN
               LABEL = 'Plane stress '
            ELSE IF(IETYP.EQ.2) THEN
               LABEL = 'Axisymmetric '
            END IF
         ELSE
            LABEL = '3-dimensional'
         END IF
C
         IPLOT=IODEV('PLOT') 
         WRITE(IPLOT,5000) NG,LABEL
C
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            CALL COORD(XYZ,NDIM,LEN,NENOD)
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL SOLIDR(U,XYZ,NENOD,NDOF,LM,NDIM,MAT,LSE,NG,NE)
         END DO
      END IF 
C
 5000 FORMAT(' Element group ',I3,' ---- SOLID elements ',A13,/,
     &       ' Element ip  XYZ coordinates ',/,
     &       '             Strains ',/,
     &       '             Stresses ')
      END
C***********************************************************************
      SUBROUTINE SOLIDK(EK,XYZ,NENOD,NDOF,NDIM,MAT,LSE,NG,N)
C=======================================================================
C     Program to set up the stiffness matrix for solid model
C=======================================================================
      IMPLICIT NONE
      DOUBLE PRECISION EK(*),XYZ(*)
      INTEGER          NENOD,NDOF,NDIM,MAT,LSE,NG,N
C --- locals -----------------------------------------------------------
      INTEGER          MW,MD,MN,MB,IOUT,IODEV,NEDOF,IP,NIP,ITR,NSK,ISK,
     &                 ITYP,NB,IDEG,IGETPA
      PARAMETER       (MW=9,MD=6,MN=40)
      DOUBLE PRECISION WGTH(MW),SK(MD*MW),B(MD*MN),C(MD*MD),FN(MN),
     &                 DNX(MN),DNY(MN),DNZ(MN),DNLX(MN),DNLY(MN),
     &                 DNLZ(MN),DET,WT
      CHARACTER*78     LABEL
C
      NB = 3
      IF(NDIM.EQ.3) NB = 6
      ITYP  = IGETPA('NEPAR','IETYP',NG)
      IOUT  = IODEV('OUTPU')
      NEDOF = NENOD*NDOF
C
      CALL INTPNT(SK,WGTH,NIP,NENOD,IDEG,ITR,NDIM,NSK,NG)
      CALL FZERO(EK,NEDOF*NEDOF)
C
      DO IP=1,NIP
         ISK=(IP-1)*NSK+1
         CALL INTFUN(XYZ,SK(ISK),FN,DNX,DNY,DNZ
     &        ,DNLX,DNLY,DNLZ,DET,NDIM,ITR,NENOD,N,IOUT)
         CALL FZERO(B,NB*NEDOF)
         CALL BMSOL(B,NB,DNX,DNY,DNZ,NENOD,ITYP,NDIM)
         CALL CMSOL(C,NB,MAT,ITYP)
         WT=WGTH(IP)*DET
         CALL DSCAL(NB*NB,WT,C,1)
         CALL BTDB(EK,B,C,NEDOF,NB,NB,NB)
      END DO
C
      END
C***********************************************************************
      SUBROUTINE BMSOL(B,NB,DNX,DNY,DNZ,NOD,ITYP,NDIM)
C=======================================================================
C     Program to form the B-matrix for 2D/3D-solid
C=======================================================================
      IMPLICIT NONE
      INTEGER          NB,NOD,ITYP,NDIM
      DOUBLE PRECISION B(NB,*),DNX(*),DNY(*),DNZ(*)
C --- locals -----------------------------------------------------------
      INTEGER          I1,I2,I3,I
C
      I1= 1 - NDIM
      IF(NB.NE.6) THEN
         DO 160 I=1,NOD
            I1=I1+NDIM
            I2=I1+1
            B(1,I1)=DNX(I)
            B(2,I2)=DNY(I)
            B(3,I1)=DNY(I)
            B(3,I2)=DNX(I)
 160     CONTINUE
      ELSE
         DO 200 I=1,NOD
            I1=I1+NDIM
            I2=I1+1
            I3=I1+2
            B(1,I1)=DNX(I)
            B(2,I2)=DNY(I)
            B(3,I3)=DNZ(I)
            B(4,I1)=DNY(I)
            B(4,I2)=DNX(I)
            B(5,I2)=DNZ(I)
            B(5,I3)=DNY(I)
            B(6,I1)=DNZ(I)
            B(6,I3)=DNX(I)
 200     CONTINUE
      END IF
C
      END
C***********************************************************************
      SUBROUTINE CMSOL(C,NC,MAT,ITYP)
C=======================================================================
C     Program to set up constitutive parameters for a solid
C-----------------------------------------------------------------------
C     ITYP = 0 = plane strain
C     ITYP = 1 = plane stress
C     ITYP = 2 = axisymmetric  (not available)
C=======================================================================
      IMPLICIT NONE
      INTEGER          NC,MAT,ITYP
      DOUBLE PRECISION C(NC,*)
C --- locals -----------------------------------------------------------
      DOUBLE PRECISION EX,PRX,D11,D12,GG,FGETPA
C
      CALL FZERO(C,NC*NC)
C
      EX  = FGETPA('CPARA','EX   ',MAT)
      PRX = FGETPA('CPARA','PRX  ',MAT)
      D11 = EX*(1.D0 - PRX)/((1.D0 + PRX)*(1.D0 - 2.D0*PRX))
      D12 = PRX*D11/(1.D0 - PRX)
      GG  = 0.5D0*EX/(1.D0 + PRX)
C
      IF(NC.NE.6) THEN
         IF(ITYP.EQ.1) THEN
            D11 = EX/(1.D0 - PRX*PRX)
            D12 = PRX*D11
         END IF
         C(1,1) = D11
         C(2,1) = D12
         C(1,2) = D12
         C(2,2) = D11
         C(3,3) = GG
      ELSE
         C(1,1) = D11
         C(2,1) = D12
         C(3,1) = D12
         C(1,2) = D12
         C(2,2) = D11
         C(3,2) = D12
         C(1,3) = D12
         C(2,3) = D12
         C(3,3) = D11
         C(4,4) = GG
         C(5,5) = GG
         C(6,6) = GG
      END IF
C
      END
C***********************************************************************
      SUBROUTINE SOLIDR(U,XYZ,NENOD,NDOF,LM,NDIM,MAT,LSE,NG,N)
C=======================================================================
C     Program to compute and output strains and stresses
C=======================================================================
      IMPLICIT NONE
      INTEGER          NENOD,NDOF,LM(*),NDIM,MAT,LSE,NG,N
      DOUBLE PRECISION U(*),XYZ(NENOD,*)
C --- local variables --------------------------------------------------
      INTEGER          MW,MD,MN,IP,NIP,IDEG,ITR,NSK,ISK,I,
     &                 IOUT,IPLOT,IODEV,IGETPA,NEDOF,NB,ITYP
      PARAMETER       (MW=9,MD=6,MN=40)
      DOUBLE PRECISION WGTH(MW),SK(MD*MW),B(MD*MN),C(MD*MD),FN(MN),
     &                 DN(MN,3),DNLX(MN),DNLY(MN),DNLZ(MN),COORD(3),
     &                 DET,DDOT,UL(MN),SIG(MD),EPS(MD)
      CHARACTER*78     LABEL
C
      IOUT  = IODEV('OUTPU')
      IPLOT = IODEV('PLOT ')
      NEDOF = NENOD*NDOF
      ITYP  = IGETPA('NEPAR','IETYP',NG)
C
      CALL INTPNT(SK,WGTH,NIP,NENOD,IDEG,ITR,NDIM,NSK,NG)
C
      NB = 3
      IF(NDIM.EQ.3) NB = 6
C
      CALL FZERO(UL,NEDOF)
      CALL GETELV(UL,U,LM,NEDOF)
C
      DO 400 IP=1,NIP
         ISK=(IP-1)*NSK+1
         CALL INTFUN(XYZ,SK(ISK),FN,DN,DN(1,2),DN(1,3)
     &        ,DNLX,DNLY,DNLZ,DET,NDIM,ITR,NENOD,N,IOUT)
         CALL FZERO(B,NB*NEDOF)
         CALL BMSOL(B,NB,DN,DN(1,2),DN(1,3),NENOD,ITYP,NDIM)
         CALL CMSOL(C,NB,MAT,ITYP)
         CALL FZERO(EPS,MD)
         CALL MULTF(EPS,B,UL,NB,NB,NEDOF)
         CALL FZERO(SIG,MD)
         CALL MULTF(SIG,C,EPS,NB,NB,NB)
         DO 200 I=1,NDIM
            COORD(I)=DDOT(NENOD,XYZ(1,I),1,FN,1)
 200     CONTINUE
         WRITE(IPLOT,5100) N,IP,(COORD(I),I=1,NDIM)
         WRITE(IPLOT,5200) (EPS(I),I=1,NB)
         WRITE(IPLOT,5200) (SIG(I),I=1,NB)
 400  CONTINUE
C
 5100 FORMAT(1X,I6,I3,6(1P,E11.3))
 5200 FORMAT(10X,6(1P,E11.3))
      END
C***********************************************************************
      SUBROUTINE SOLIDS(EF,XYZ,NENOD,NDOF,NDIM,MAT,LSE,NG,N)
C=======================================================================
C     Program to set up the element load vector for solid model
C=======================================================================
      IMPLICIT NONE
      INTEGER          NENOD,NDOF,NDIM,MAT,LSE,NG,N
      DOUBLE PRECISION EF(*),XYZ(NENOD,*)
C --- locals -----------------------------------------------------------
      INTEGER          MW,MEDOF,MD,NB,NS,MN
      PARAMETER       (MW=16,MEDOF=20,MN=20,MD=3,NB=3,NS=2)
      INTEGER          IOUT,IODEV,IGETPA,I,IP,ISK,IRED,IX,IY,II,J,LOAD,
     &                 IDEG,ITR,NIX,NIY,NIP,NEDOF,NSK
      DOUBLE PRECISION WGTH(MW),SK(MD*MW),Q(MEDOF),FN(MN),DN(MN,3),
     &                 DNLX(MN),DNLY(MN),DNLZ(MN),
     &                 SFLX(MN),SFLY(MN),DET,WT,FGETPA,QQ(MD),DDOT
      CHARACTER*78     LABEL
C
      IOUT=IODEV('OUTPU')
      LOAD=IODEV('ELOAD')
C
      CALL INTPNT(SK,WGTH,NIP,NENOD,IDEG,ITR,NDIM,NSK,NG)
C
      NEDOF = NENOD*NDOF
C
      CALL FZERO(EF,NEDOF)
C
      READ(LOAD, REC = N, ERR = 100) (Q(I), I = 1, NEDOF)
      DO IP = 1, NIP
         ISK=(IP-1)*NSK+1
         CALL INTFUN(XYZ,SK(ISK),FN,DN,DN(1,2),DN(1,3)
     &        ,DNLX,DNLY,DNLZ,DET,NDIM,ITR,NENOD,N,IOUT)
         WT = WGTH(IP)*DET
         DO I = 1, NDIM
            QQ(I) = DDOT(NENOD,FN,1,Q(I),NDOF)
         END DO
         DO I = 1, NENOD
            DO J = 1, NDOF
               EF((I-1)*NDOF + J) = EF((I-1)*NDOF + J) + QQ(J)*WT*FN(I)
            END DO
         END DO
      END DO
C
 100  CONTINUE
      END
C***********************************************************************
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C-***-END-OF-FILE-******************************************************

