C***********************************************************************
      SUBROUTINE RMPL(A,U,F,IA,NG,NE,TASK)
C=======================================================================
C     Program to set up things related to RM plate models (old elements)
C=======================================================================
      IMPLICIT NONE
      DOUBLE PRECISION A(*),U(*),F(*)
      INTEGER          IA(1)
      CHARACTER*78     TASK
C --- local variables --------------------------------------------------
      INTEGER          ME,ID,IEN,IODEV,IGETPA,NEQ,NDIM,NEL,NENOD,NDOF,
     &                 IEQEL,NEDOF,N,NE,J,NG,MAT,LSE,IPLOT,IETYP
      PARAMETER       (ME=40) 
      INTEGER          LM(ME),LEN(ME)
      DOUBLE PRECISION EK(ME*ME),XYZ(3*ME)
      CHARACTER*13     LABEL
C
      ID  = IODEV('IDARR')
      IEN = IODEV('IENAR')
C
      NEQ   = IGETPA('NSPAR','NEQ  ',0)
      NDIM  = IGETPA('NSPAR','NDIM ',0)
      NEL   = IGETPA('NEPAR','NEL  ',NG)
      NENOD = IGETPA('NEPAR','NENOD',NG)
      NDOF  = IGETPA('NEPAR','NDOF ',NG)
      IEQEL = IGETPA('NEPAR','IEQEL',NG)
      NEDOF = NENOD*NDOF
C
      IF(INDEX(TASK,'FORM-MATRIX').NE.0)  THEN
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            IF((IEQEL.NE.1).OR.(N.EQ.1)) THEN
               CALL COORD(XYZ,NDIM,LEN,NENOD)
               CALL RMPLK(EK,XYZ,NENOD,NDOF,NDIM,MAT,LSE,NG,NE)
            END IF
C
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL ASSEM(A,IA,EK,LM,NEDOF,NE)
         END DO
      ELSE IF(INDEX(TASK,'LOAD').NE.0) THEN
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            CALL COORD(XYZ,NDIM,LEN,NENOD)
            CALL RMLOA(EK,XYZ,NENOD,NDOF,NDIM,MAT,LSE,NG,NE)
C
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL ADDRHS(F,EK,LM,NEDOF)
         END DO
      ELSE IF(INDEX(TASK,'COMPUTE').NE.0)  THEN
C
         IPLOT=IODEV('PLOT') 
         WRITE(IPLOT,5000) NG
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            CALL COORD(XYZ,NDIM,LEN,NENOD)
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL RMPLR(U,XYZ,NENOD,LM,NDOF,MAT,LSE,NG,NE)
         END DO
      END IF
C
 5000 FORMAT(' Element group ',I3,' ---- RM plate elements',/,
     &       ' Elem   node  Bending moments',/,
     &       '              Shear forces')
      END
C***********************************************************************
      SUBROUTINE RMPLK(EK,XY,NENOD,NDOF,NDIM,MAT,LSE,NG,N)
C=======================================================================
C     Program to set up the stiffness matrix for RM plate model
C=======================================================================
      IMPLICIT NONE
      INTEGER          NENOD,NDOF,NDIM,MAT,LSE,NG,N
      DOUBLE PRECISION EK(*),XY(NENOD,*)
C --- locals -----------------------------------------------------------
      INTEGER          MW,MEDOF,NB,NS,MN
      PARAMETER       (MW=16,MEDOF=27,MN=9,NB=3,NS=2)
      INTEGER          IOUT,IELD,IODEV,IGETPA,I,IP,ISK,IRED,IX,IY,II,
     &                 IDEG,ITR,NIX,NIY,NIP,NEDOF,NSK,NISX,NISY,NISP
      DOUBLE PRECISION WGTH(MW),SK(2*MW),BB(NB*MEDOF),BS(NS*MEDOF),
     &                 CB(NB*NB),CS(NS*NS),SF(MN),SFX(MN),SFY(MN),DDOT,
     &                 SFLX(MN),SFLY(MN),H,T(MN),TH,STAB,DET,WT,FGETPA
      CHARACTER*78     LABEL
C
      IOUT = IODEV('OUTPU')
      IELD = IODEV('ELDAT')
C
      NIX   = IGETPA('NEPAR','NIX  ',NG)
      NIY   = IGETPA('NEPAR','NIY  ',NG)
      IRED  = IGETPA('NEPAR','IETYP',NG)  
      NIP   = NIX*NIY
C
      IF((NENOD.EQ.3).OR.(NENOD.EQ.6)) THEN
         ITR = 1
      ELSE
         ITR   = 0
      END IF
C
      IF(IRED.EQ.1) THEN
         NISX = NIX - 1
         NISY = NIY - 1
      ELSE
         NISX = NIX
         NISY = NIY
      END IF
      NISP = NISX*NISY
C
      NEDOF = NENOD*NDOF
      STAB  = FGETPA('FPARA','STABC',0)
C
      CALL FZERO(EK,NEDOF*NEDOF)
C
      CALL INTP2D(SK,WGTH,NIX,NIY,NIP,NENOD,IDEG,ITR,NSK,NG)
C
      CALL THICK(NENOD,T,IELD,N,LSE)
C
      DO IP = 1, NIP
         ISK=(IP-1)*NSK+1
         CALL INTF2D(XY,SK(ISK),SF,SFX,SFY
     &        ,SFLX,SFLY,DET,ITR,NENOD,N,IOUT)
         CALL FZERO(BB,NB*NEDOF)
         CALL BBRM(BB,NB,SFX,SFY,NENOD,NDOF)
C
         TH = DDOT(NENOD,SF,1,T,1)
         CALL CMKLRR(CB,NB,TH,MAT)
C
         WT = WGTH(IP)*DET
         CALL DSCAL(NB*NB,WT,CB,1)
         CALL BTDB(EK,BB,CB,NEDOF,NB,NB,NB)
      END DO
C
      CALL INTP2D(SK,WGTH,NISX,NISY,NISP,NENOD,IDEG,ITR,NSK,NG)
C
      DO IP = 1, NISP
         ISK=(IP-1)*NSK+1
         CALL INTF2D(XY,SK(ISK),SF,SFX,SFY
     &        ,SFLX,SFLY,DET,ITR,NENOD,N,IOUT)
         CALL FZERO(BS,NS*NEDOF)
         CALL BSRM(BS,NS,SFX,SFY,SF,NENOD,NDOF,NDIM)

         TH = DDOT(NENOD,SF,1,T,1)
         CALL CMRMRR(CS,NS,TH,MAT)
C
         WT = WGTH(IP)*DET
         CALL DSCAL(NS*NS,WT,CS,1)
         CALL BTDB(EK,BS,CS,NEDOF,NS,NS,NS)
      END DO
C
      END
C***********************************************************************
      SUBROUTINE BSRM(B,NB,SFX,SFY,SF,NPE,NLDF,NC)
C=======================================================================
C     Program to form the shear-displacement matrix 
C     for Reissner-Mindlin plate bending elements
C     Reduction operator used in the definition of rotations
C=======================================================================
      IMPLICIT NONE
      INTEGER          NB,NPE,NLDF,NC
      DOUBLE PRECISION B(NB,*),SFX(*),SFY(*),SF(*)
      INTEGER          I,IW,IX,IY
C
      IW = -NC
      DO I = 1, NPE
         IW = IW + NLDF
         IX = IW + 1
         IY = IX + 1
         B(1,IW)= SFX(I)
         B(1,IY)= SF(I)
         B(2,IW)= SFY(I)
         B(2,IX)=-SF(I)
      END DO
C
      END 
C***********************************************************************
      SUBROUTINE RMPLR(U,XY,NENOD,LM,NDOF,MAT,LSE,NG,N)
C=======================================================================
C     Purpose
C     to evaluate internal forces for standard isoparametric 
C     Reissner-Mindlin plate elements
C=======================================================================
      IMPLICIT NONE
      INTEGER          LM(*),NENOD,NDOF,MAT,LSE,NG,N
      DOUBLE PRECISION U(*),XY(NENOD,*)
C --- locals -----------------------------------------------------------
      INTEGER          MW,MEDOF,NB,NS,MN
      PARAMETER       (MW=16,MEDOF=27,MN=9,NB=3,NS=2)
      INTEGER          IOUT,IELD,IPLOT,IODEV,IGETPA,I,IP,ISK,IRED,IX,IY,
     &                 II,IDEG,ITR,NIX,NIY,NIP,NEDOF,NSK,NISX,NISY,NISP
      DOUBLE PRECISION WGTH(MW),SK(2*MW),BB(NB*MEDOF),BS(NS*MEDOF),
     &                 CB(NB*NB),CS(NS*NS),SF(MN),SFX(MN),SFY(MN),DDOT,
     &                 SFLX(MN),SFLY(MN),H,T(MN),TH,STAB,DET,WT,FGETPA,
     &                 BEND(NB),CURV(NB),SHEA(NS),SFOR(NS),UL(MEDOF)
      CHARACTER*78     LABEL
C
      IOUT  = IODEV('OUTPU')
      IELD  = IODEV('ELDAT')
      IPLOT = IODEV('PLOT')
C
      NIX   = IGETPA('NEPAR','NIX  ',NG)
      NIY   = IGETPA('NEPAR','NIY  ',NG)
      IRED  = IGETPA('NEPAR','IETYP',NG)  
      NIP   = NIX*NIY
C
      IF((NENOD.EQ.3).OR.(NENOD.EQ.6)) THEN
         ITR = 1
      ELSE
         ITR = 0
      END IF
C
      IF(IRED.EQ.1) THEN
         NISX = NIX - 1
         NISY = NIY - 1
      ELSE
         NISX = NIX
         NISY = NIY
      END IF
      NISP = NISX*NISY
C
      NEDOF = NENOD*NDOF
      STAB  = FGETPA('FPARA','STABC',0)
C
      CALL FZERO(UL,NEDOF)
      CALL GETELV(UL,U,LM,NEDOF)
C
      CALL INTP2D(SK,WGTH,NIX,NIY,NIP,NENOD,IDEG,ITR,NSK,NG)
C
      CALL THICK(NENOD,T,IELD,N,LSE)
C
      DO IP = 1, NIP
         ISK=(IP-1)*NSK+1
         CALL INTF2D(XY,SK(ISK),SF,SFX,SFY
     &        ,SFLX,SFLY,DET,ITR,NENOD,N,IOUT)
         CALL FZERO(BB,NB*NEDOF)
         CALL BBRM(BB,NB,SFX,SFY,NENOD,NDOF)
         TH = DDOT(NENOD,SF,1,T,1)
         CALL CMKLRR(CB,NB,TH,MAT)
         CALL FZERO(CURV,NB)
         CALL MULTF(CURV,BB,UL,NB,NB,NEDOF)
         CALL FZERO(BEND,NB)
         CALL MULTF(BEND,CB,CURV,NB,NB,NB)
         WRITE(IPLOT,5100) N,IP,(BEND(I),I=1,NB)
      END DO
C
      CALL INTP2D(SK,WGTH,NISX,NISY,NISP,NENOD,IDEG,ITR,NSK,NG)
C
      DO IP = 1, NISP
         ISK=(IP-1)*NSK+1
         CALL INTF2D(XY,SK(ISK),SF,SFX,SFY
     &        ,SFLX,SFLY,DET,ITR,NENOD,N,IOUT)
         CALL FZERO(BS,NS*NEDOF)
         CALL BSRM(BS,NS,SFX,SFY,SF,NENOD,NDOF,2)
         TH = DDOT(NENOD,SF,1,T,1)
         CALL CMRMRR(CS,NS,TH,MAT)
         CALL FZERO(SHEA,NS)
         CALL MULTF(SHEA,BS,UL,NS,NS,NEDOF)
         CALL FZERO(SFOR,NS)
         CALL MULTF(SFOR,CS,SHEA,NS,NS,NS)
         WRITE(IPLOT,5100) N,IP,(SFOR(I),I=1,NS)
      END DO
C
 5100 FORMAT(1X,I6,I4,3(1P,E13.5))
      END
C***********************************************************************
      SUBROUTINE RMLOA(EF,XY,NENOD,NDOF,NDIM,MAT,LSE,NG,N)
C=======================================================================
C     Program to set up the element load vector from distributed
C     vertical forces for the isoparametric plate elements
C=======================================================================
      IMPLICIT NONE
      INTEGER          NENOD,NDOF,NDIM,MAT,LSE,NG,N
      DOUBLE PRECISION EF(*),XY(NENOD,*)
C --- locals -----------------------------------------------------------
      INTEGER          MW,MEDOF,NB,NS,MN
      PARAMETER       (MW=16,MEDOF=27,MN=9,NB=3,NS=2)
      INTEGER          IOUT,IODEV,IGETPA,I,IP,ISK,IRED,IX,IY,II,LOAD,
     &                 IDEG,ITR,NIX,NIY,NIP,NEDOF,NSK,NISX,NISY,NISP
      DOUBLE PRECISION WGTH(MW),SK(2*MW),Q(MEDOF),
     &                 SF(MN),SFX(MN),SFY(MN),
     &                 SFLX(MN),SFLY(MN),DET,WT,FGETPA,QQ,DDOT
      CHARACTER*78     LABEL
C
      IOUT=IODEV('OUTPU')
      LOAD=IODEV('ELOAD')
C
      ITR   = 0
      IF((NENOD.EQ.3).OR.(NENOD.EQ.6)) THEN
         ITR = 1
         NIP = 4
      ELSE
         ITR   = 0
         NIX   = 4
         NIY   = 4
         NIP   = NIX*NIY
      END IF
C
      NEDOF = NENOD*NDOF
C
      CALL FZERO(EF,NEDOF)
C
      CALL INTP2D(SK,WGTH,NIX,NIY,NIP,NENOD,IDEG,ITR,NSK,NG)
C
      READ(LOAD, REC = N, ERR = 100) (Q(I), I = 1, NENOD)
      DO IP = 1, NIP
         ISK=(IP-1)*NSK+1
         CALL INTF2D(XY,SK(ISK),SF,SFX,SFY
     &        ,SFLX,SFLY,DET,ITR,NENOD,N,IOUT)
         WT = WGTH(IP)*DET
         QQ = DDOT(NENOD,SF,1,Q,1)
         DO I = 1, NENOD
            EF(NDOF*(I-1)+1) = EF(NDOF*(I-1)+1) + QQ*WT*SF(I)
         END DO
      END DO
C
 100  CONTINUE
      END
C***********************************************************************
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C-***-END-OF-FILE-******************************************************
