C***********************************************************************
      SUBROUTINE RDATA(IA,TASK,TITLE)
C=======================================================================
C     Program to read input data
C=======================================================================
      IMPLICIT NONE
      INTEGER      IA(*)
      CHARACTER*78 TASK,TITLE(*)
C --- local variables --------------------------------------------------
      INTEGER      IIN,IOUT,IECHO,IEND,IODEV
      CHARACTER*78 LABEL
C
      CALL INIPAR
      IIN   = IODEV('INPUT')
      IOUT  = IODEV('OUTPU')
      IECHO = 0
C
      CALL TIMING('START')
 100  CONTINUE
      CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
      IF(IEND.NE.1) THEN
         IF(INDEX(LABEL,'EXEC').NE.0) THEN
            CALL REXEC(LABEL,IIN,IOUT,IECHO,TASK,IEND)
         ELSE IF(INDEX(LABEL,'BCON').NE.0) THEN
            CALL RBCON(LABEL,IIN,IOUT,IECHO,IEND)
         ELSE IF(INDEX(LABEL,'CFOR').NE.0) THEN
            CALL RCFOR(LABEL,IIN,IOUT,IECHO,IEND)
         ELSE IF(INDEX(LABEL,'COOR').NE.0) THEN
            CALL GNODES(LABEL,IIN,IOUT,IECHO,IEND)
         ELSE IF(INDEX(LABEL,'ECHO').NE.0) THEN
            IECHO=1
         ELSE IF(INDEX(LABEL,'RANDOM').NE.0) THEN
            CALL RANPER(LABEL,IIN,IOUT,IECHO,IEND)
         ELSE IF(INDEX(LABEL,'ELEM').NE.0) THEN
            CALL RELEM(LABEL,IIN,IOUT,IECHO,IEND,IA)
         ELSE IF(INDEX(LABEL,'ELOAD').NE.0) THEN
            CALL RELOAD(LABEL,IIN,IOUT,IECHO,IEND,IA)
         ELSE IF(INDEX(LABEL,'FPARA').NE.0) THEN
            CALL RFPAR('FPARA',LABEL,IIN,IOUT,IECHO,IEND)
         ELSE IF(INDEX(LABEL,'IPARA').NE.0) THEN
            CALL RPARA(LABEL,IIN,IOUT,IECHO,IEND)
         ELSE IF(INDEX(LABEL,'MATE').NE.0) THEN
            CALL RFPAR('CPARA',LABEL,IIN,IOUT,IECHO,IEND)
         ELSE IF(INDEX(LABEL,'NODE').NE.0) THEN
            CALL RNODE(LABEL,IIN,IOUT,IECHO,IEND)
         ELSE IF(INDEX(LABEL,'SECT').NE.0) THEN
            IF(INDEX(LABEL,'VAR').NE.0) THEN
               CALL RVARSP(LABEL,IIN,IOUT,IECHO,IEND)
            ELSE
               CALL RFPAR('SPARA',LABEL,IIN,IOUT,IECHO,IEND)
            END IF
         ELSE IF(INDEX(LABEL,'TITLE').NE.0) THEN
            CALL RTITLE(TITLE,IIN,IOUT,IECHO,IEND)
         ELSE
            CLOSE(UNIT=IIN)
            WRITE(IOUT,5000) LABEL
	      WRITE(*,5000) LABEL
            STOP
         END IF
      ELSE 
         CLOSE(UNIT=IIN)
         CALL TIMING('TIINP')
         WRITE(IOUT,5200)
	   WRITE(*,5200)	
C
         CALL PDATA(IA)
         CALL WRDAT(TITLE)
C
         RETURN
      END IF
C
      GOTO 100
C
 5000 FORMAT(' *** ERROR *** UNKNOWN DATA IDENTIFIER ',/,A)
 5100 FORMAT(' *** ERROR *** PREMATURE END OF INPUT FILE ')
 5200 FORMAT(' INPUT DATA READ SUCCESSFULLY ')
      END
C***********************************************************************
      SUBROUTINE INIPAR
C=======================================================================
C     PURPOSE
C     to initialize parameter arrays
C=======================================================================
	EXTERNAL PUTIPA
C
C --- initialize NSPAR array
C
	CALL PUTIPA('NSPAR','NCFOR',0,0)
	CALL PUTIPA('NSPAR','NTIT ',0,0)
	CALL PUTIPA('NSPAR','ISYM ',1,0)
	CALL PUTIPA('NSPAR','IMETH',0,0)
	CALL PUTIPA('NSPAR','ISTMO',0,0)
	CALL PUTIPA('NSPAR','NPR  ',0,0)
	CALL PUTIPA('NSPAR','REORD',1,0)
C
C --- initialize MPARA array
C	
      CALL PUTIPA('MPARA','MITER',200,0)
C
	END
C***********************************************************************
      SUBROUTINE PDATA(IA)
C=======================================================================
C     PURPOSE
C     to process input data
C=======================================================================
      IMPLICIT NONE
      INTEGER      IA(*)
C --- local variables --------------------------------------------------
      INTEGER      IOUT,IMETH,ISTMO,I
      INTEGER      NEQ,NNOD,MAXNC,IODEV,IGETPA,ISYM,NGK,N1,N2,MIA,IREORD
	INTEGER      NDEG,NPERM,IWRK
      EXTERNAL     IODEV,IGETPA
C
      CALL TIMING('START')
C
      IOUT = IODEV('OUTPU')
      MIA  = IGETPA('MPARA','MIA',0)
      NNOD = IGETPA('NSPAR','NNOD ',0)
      IREORD = IGETPA('NSPAR','REORD',0)
      WRITE(*,'('' Start processing input data'')')
C
C --- mark the unused nodes in ID array
C
      WRITE(*,'('' Find unused nodes '')')
      CALL UNODE(IA(NNOD+1))
C
C --- form the nodal adjacency list 
C
      IF(IREORD.GE.1) THEN
         CALL NODE_GRAPH(NNOD,IA(NNOD+1),IA(2*NNOD+2),0)
C
C --- try to minimize the band or the profile
C
C
         NGK   = IGETPA('NSPAR','NGK',0)
         NDEG  = 2*NNOD+2+NGK
         NPERM = NDEG + NNOD
         IWRK  = NPERM + NNOD
C
         CALL REORD(NNOD,IA(NNOD+1),IA(2*NNOD+2)
     &        ,IA(NPERM),IA(NDEG),IWRK,IA(IWRK))
C
      ELSE
         NPERM = NNOD + 1
         DO I = 1, NNOD
            IA(NPERM-1+I) = I
         END DO
      END IF
C
      WRITE(*,'('' Start equation numbering'')')
      CALL EQNUM(IA(NPERM))
C
      IMETH = IGETPA('NSPAR','IMETH',0)
C
      IF(IMETH.GE.100) THEN
         NEQ   = IGETPA('NSPAR','NEQ  ',0)
         MAXNC = 0
         DO 200 I = 1, NNOD
            MAXNC = MAX(IA(I),MAXNC)
            IA(I) = 0
 200     CONTINUE
         ISTMO = IGETPA('NSPAR','ISTMO',0)
         IF(ISTMO.EQ.4) THEN
            CALL APNT(IA,IA(NEQ+2),MAXNC)
            ISYM = IGETPA('NSPAR','ISYM',0)
            IF(ISYM.EQ.0) THEN
               NGK = IGETPA('NSPAR','NGK',0)
               N1  = NEQ + 2
               N2  = N1  + NGK
               CALL IDPTR(IA,IA(N1),IA(N2),NEQ,IOUT)
            END IF
         ELSE IF(ISTMO.EQ.7) THEN
            CALL APNTD(IA)
         END IF
      ELSE
         CALL BANDW
      END IF
C
      CALL CHKDIM
      CALL TIMING('TIDPR')
C
      END
C***********************************************************************
      SUBROUTINE REORD(N,IA,JA,PERM,DEGREE,NPWRK,IWRKA)
C=======================================================================
C     Program to find permutation
C=======================================================================
      IMPLICIT NONE
      INTEGER N,NPWRK,IA(*),JA(*),PERM(*),DEGREE(*),IWRKA(*)
C     locals -----------------------------------------------------------
      INTEGER MIA,NWRK,IOUT,IODEV,IGETPA,NBAND,NPROF,NO,NN,IERR,NSP
     &     ,IREORD,I,J
      LOGICAL OPTPRO
      EXTERNAL IODEV,IGETPA
C
      NWRK  = 6*N+3
      IOUT  = IODEV('OUTPU')
      MIA   = IGETPA('MPARA','MIA',0)
C
      IREORD = 1
      IF((NPWRK+N+NWRK).LT.MIA) THEN
         IF(IREORD.EQ.1) THEN
            OPTPRO = .FALSE.
            CALL INIGPS(N,IA,DEGREE,IWRKA)
            DO I = 1, N
C               WRITE(IOUT,'('' I DEG '',13I5)') I,DEGREE(I),
C     &              (JA(J),J=IA(I),IA(I+1)-1)
            END DO
            CALL IZERO(IWRKA(N+1),NWRK)
            CALL GPSKCA(N,DEGREE,IA,JA,OPTPRO
     &           ,NWRK,IWRKA,IWRKA(N+1),NBAND,NPROF,IERR,NSP)
            IF(IERR.EQ.0) THEN
               CALL TSTPERM(N,IWRKA,IWRKA(N+1))
               CALL UXVSIP(N,IWRKA,PERM)
            END IF
         ELSE
C         CALL CMS(N,JA,IA,DEGREES
C     &        ,PERM,IWRKA)
C         CALL REVRSE(N,PERM)
C         IERR = 0
            IF(IERR.EQ.0) THEN
               CALL TSTPERM(N,PERM,IWRKA(N+1))
               CALL UXVSIP(N,PERM,IWRKA(N+1))
            END IF
         END IF
         IF(IERR.EQ.0) THEN
            CALL PROFIL(N,IWRKA,IA,JA,NO,NN)
         ELSE
            WRITE(IOUT,'('' Error in nodal permutation '',I5)') IERR
            DO I = 1, N
               PERM(I) = I
            END DO
         END IF
      ELSE
         WRITE(IOUT,'('' No space to perform nodal permutation'')')
         DO I = 1, N
            PERM(I) = I
         END DO
      END IF
C
      END
C***********************************************************************
      SUBROUTINE PROFIL(N,INVP,IA,JA,OLDPRO,NEWPRO)
C=======================================================================
C     PURPOSE: 
C     -------- 
C     Compute the profiles using both original and new node numbers 
C     INPUT: 
C     ------ 
C     N      - Total number of nodes in graph 
C     INVP   - List of new node numbers for graph 
C            - New node number for node I is given by INVP(I) 
C     IA     - Adjacency list for all nodes in graph 
C            - List of length 2E where E is the number of edges in  
C              the graph and 2E = XADJ(N+1)-1 
C     JA     - Index vector for ADJ 
C            - Nodes adjacent to node I are found in ADJ(J), where 
C              J = XADJ(I), XADJ(I)+1, ..., XADJ(I+1)-1 
C            - Degree of node I given by XADJ(I+1)-XADJ(I) 
C     OLDPRO - Undefined 
C     NEWPRO - Undefined 
C 
C     OUTPUT: 
C     ------- 
C 
C     N      - Unchanged 
C     NNN    - Unchanged 
C     ADJ    - Unchanged 
C     XADJ   - Unchanged 
C     OLDPRO - Profile with original node numbering 
C     NEWPRO - Profile with new node numbering 
C 
C     NOTE:      Profiles include diagonal terms 
C     ----- 
C=======================================================================
      INTEGER I,J,N,IOUT
      INTEGER JSTOP,JSTRT 
      INTEGER NEWMIN,NEWPRO,OLDMIN,OLDPRO 
      INTEGER JA(*),INVP(*) 
      INTEGER IA(*) 
      DOUBLE PRECISION RMSWFO,RMSWFN,IHNEW,IHOLD
C
      OLDPRO=0 
      NEWPRO=0 
      RMSWFO = 0.0D0
      RMSWFN = 0.0D0
C
      IOUT = IODEV('OUTPU')
      DO I=1,N 
         JSTRT=IA(I) 
         JSTOP=IA(I+1)-1 
         OLDMIN=I 
         NEWMIN=INVP(I) 
C 
C       Find lowest numbered neighbour of node I 
C       (using both old and new node numbers) 
C 
         DO J=JSTRT,JSTOP 
            OLDMIN = MIN(OLDMIN,JA(J)) 
            NEWMIN = MIN(NEWMIN,INVP(JA(J))) 
         END DO
C 
C        Update profiles 
C 
         IHOLD  = DIM(I,OLDMIN) + 1
         IHNEW  = DIM(INVP(I),NEWMIN) + 1
         OLDPRO = OLDPRO + IHOLD
         NEWPRO = NEWPRO + IHNEW
         RMSWFO = RMSWFO + REAL(IHOLD*IHOLD)
         RMSWFN = RMSWFN + REAL(IHNEW*IHNEW)
      END DO
C
      RMSWFO = DSQRT(RMSWFO/REAL(N))
      RMSWFN = DSQRT(RMSWFN/REAL(N))
      WRITE(IOUT,*) 'RMSWFO RMSWFN',RMSWFO,RMSWFN
C
      END 
C***********************************************************************
      SUBROUTINE PERM_ID(NDOF,NP,ID,PERM)
      IMPLICIT NONE
      INTEGER NDOF,NP
      INTEGER ID(NDOF,*),PERM(*)
      INTEGER I,J,OLD
C
      DO I = 1, NP
         DO J = 1, NDOF
            OLD = ID(J,I)
            IF(OLD.GT.0) THEN
               ID(J,I) = PERM(OLD)
            END IF
         END DO
      END DO
C
      END
C***********************************************************************
      SUBROUTINE CMS(N,IRN,IP,LENC,IPERM,IW)
      INTEGER N,IRN(*),IP(N+1),LENC(N),IPERM(N),IW(N)

      INTEGER I,J,K,II,P,Q0,Q1,Q2

C Compute Cuthill McKee ordering for a sparse SYMMETRIC matrix

C Initialization
      DO 10 I = 1,N
        IPERM(I) = 0
        IW(I) = 0
   10 CONTINUE
      Q0 = 1
      Q1 = 1
      Q2 = 1
C Compute level sets
      DO 12 K = 1,N
C Check if row K has already been assigned
        IF (IW(K).NE.0) GO TO 12
C Let K be initial node
        IPERM(Q2) = K
        IW(K) = Q2
        Q2 = Q2 + 1
   15   CONTINUE
        Q0 = Q1
        Q1 = Q2
        DO 20 P = Q0,Q1-1
          J = IPERM(P)
          DO 30 II = IP(J),IP(J)+LENC(J)-1
            I = IRN(II)
            IF (IW(I).NE.0) GO TO 30
            IPERM(Q2) = I
            IW(I) = Q2
            Q2 = Q2 + 1
   30     CONTINUE
   20   CONTINUE
        IF (Q1.NE.Q2) GO TO 15
   12 CONTINUE
C IPERM contains permutation vector
      RETURN
      END
C***********************************************************************
      SUBROUTINE REVERSE(N,PERM)
      INTEGER N,PERM(N)

C Reverse array PERM

      INTEGER TMP,J,N2

      N2 = N/2
      DO 10 J = 1,N2
        TMP = PERM(N-J+1)
        PERM(N-J+1) = PERM(J)
        PERM(J) = TMP
   10 CONTINUE
      RETURN
      END
                                                                        
C--- SPARSPAK-A (ANSI FORTRAN) RELEASE III --- NAME = REVRSE            
C  (C)  UNIVERSITY OF WATERLOO   JANUARY 1984                           
C***************************************************************        
C***************************************************************        
C*************     REVRSE ..... REVERSE VECTOR     *************        
C***************************************************************        
C***************************************************************        
C                                                                       
C     PURPOSE - THIS ROUTINE REVERSES THE ENTRIES IN AN                 
C        INPUT (SHORT) INTEGER VECTOR.                                  
C                                                                       
C     INPUT PARAMETER -                                                 
C        N     - THE SIZE OF THE INTEGER VECTOR.                        
C                                                                       
C     UPDATED PARAMETER -                                               
C        IVECTR - THE INTEGER VECTOR WHICH ON OUTPUT WILL BE            
C                 REVERSED.  (IVECTR IS AN ARRAY OF SHORT               
C                 INTEGERS.)                                            
C                                                                       
C***************************************************************        
C                                                                       
      SUBROUTINE  REVRSE ( N, IVECTR )                                  
C                                                                       
C***************************************************************        
C                                                                       
         INTEGER    IVECTR(1)                                           
         INTEGER    I     , ISAVE , J     , MID   , N                   
C                                                                       
C***************************************************************        
C                                                                       
         IF  ( N .LE. 0 )  RETURN                                       
         MID = N/2                                                      
         IF  ( MID .LE. 0 )  RETURN                                     
         J = N                                                          
         DO  100  I = 1, MID                                            
             ISAVE = IVECTR(I)                                          
             IVECTR(I) = IVECTR(J)                                      
             IVECTR(J) = ISAVE                                          
             J = J - 1                                                  
  100    CONTINUE                                                       
         RETURN                                                         
C                                                                       
      END                                                               
                                                                        
C***********************************************************************
      SUBROUTINE INIGPS(N,IA,DEGREE,INVP)
      IMPLICIT NONE
      INTEGER N,DEGREE(*),IA(*),INVP(*)
      INTEGER I,IOUT,IODEV
      IOUT = IODEV('OUTPU')
      DO I = 1, N
         DEGREE(I) = IA(I+1) - IA(I)
         INVP(I) = I
      END DO
C
      END
C***********************************************************************
      SUBROUTINE CHKDIM
C=======================================================================
C     Program to check the dimensions of main arrays
C=======================================================================
      IMPLICIT NONE
      INTEGER IOUT,IMETH,NEQ,NBAND,NGK,MA,MIA,MU,NA,IODEV,IGETPA
C
      IOUT  = IODEV('OUTPU')
      IMETH = IGETPA('NSPAR','IMETH',0)
      NEQ   = IGETPA('NSPAR','NEQ  ',0)
      NBAND = IGETPA('NSPAR','NBAND',0)
      NGK   = IGETPA('NSPAR','NGK  ',0)
      MA    = IGETPA('MPARA','MA   ',0)
      MIA   = IGETPA('MPARA','MIA  ',0)
      MU    = IGETPA('MPARA','MU   ',0)
C
      IF(IMETH.EQ.0) THEN
         NA = NGK
      ELSE IF(IMETH.EQ.100) THEN
         NA = 6*NEQ+2*NGK
      ELSE IF(IMETH.EQ.200) THEN
         NA = 9*NEQ + 2*NGK
      END IF
C
      IF((NA.GT.MA).OR.(NA.LE.0)) THEN
         WRITE(IOUT,5000) NA,MA
         WRITE(IOUT,5100) NEQ,NBAND,NGK
         STOP
      END IF
      IF(NEQ.GT.MU) THEN
         WRITE(IOUT,5200) NEQ,MU
         STOP
      END IF
C
 5000 FORMAT(' *** ERROR *** MAXIMUM DIMENSIONS EXCEEDED FOR ARRAY A',/,
     &       '               SPACE NEEDEED FOR  ',I10,' FP ELEMENTS ',/,
     &       '               DIMENSION OF ARRAY ',I10)
 5100 FORMAT(' NEQ NBAND NGK ',3I10) 
 5200 FORMAT(' *** ERROR *** MAXIMUM DIMENSIONS EXCEEDED FOR ARRAY U',/,
     &       '               SPACE NEEDEED FOR  ',I10,' FP ELEMENTS ',/,
     &       '               DIMENSION OF ARRAY ',I10)
      END
C***********************************************************************
      SUBROUTINE REXEC(LABEL,IIN,IOUT,IECHO,TASK,IEND)
C=======================================================================
C     Program to read the execution data
C=======================================================================
      IMPLICIT NONE
      INTEGER      IIN,IOUT,IECHO,IEND
      CHARACTER*78 TASK,LABEL
C --- local variables --------------------------------------------------
      INTEGER      ISYM,IMETH,IPREC,ISTMO
C
      ISYM  = 1
      IPREC = 1
      IMETH = 0
      ISTMO = 0
C
 100  CONTINUE
      CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
      IF(INDEX(LABEL,'END').EQ.0) THEN
         IF(INDEX(LABEL,'ANAL').NE.0) READ(LABEL,'(A)') TASK
C 
         IF(INDEX(LABEL,'CG').NE.0) THEN
            ISTMO = 4
            IMETH = 100
            IF(INDEX(LABEL,'BCG').NE.0) THEN
               IMETH = 200
            END IF
         END IF
C
         IF(INDEX(LABEL,'IC').NE.0) THEN
            IPREC = 1
            ISYM  = 1
         ELSE IF(INDEX(LABEL,'ILU').NE.0) THEN
            IPREC = 100
            ISYM  = 0
         ELSE IF(INDEX(LABEL,'NO-PREC').NE.0) THEN
            IPREC = 0
         END IF
C
         IF(INDEX(LABEL,'NO-ORD').NE.0) CALL PUTIPA('NSPAR','REORD',0,0)
         IF(INDEX(LABEL,'NO-OPT').NE.0) CALL PUTIPA('NSPAR','REORD',0,0)
         IF(INDEX(LABEL,'UNSYM').NE.0) ISYM  = 0
         IF(INDEX(LABEL,'PROF').NE.0)  ISTMO = 1
C
         IF(INDEX(LABEL,'CSR').NE.0) THEN
            ISTMO = 4
         ELSE IF(INDEX(LABEL,'DIA').NE.0) THEN
            ISTMO = 7
         END IF
      ELSE
C
         CALL PUTIPA('NSPAR','IMETH',IMETH,0)
         CALL PUTIPA('NSPAR','IPREC',IPREC,0)
         CALL PUTIPA('NSPAR','ISYM ',ISYM, 0)
         CALL PUTIPA('NSPAR','ISTMO',ISTMO,0)
         RETURN
      END IF
      GOTO 100
C
      END
C***********************************************************************
      SUBROUTINE RANPER(LABEL,IIN,IOUT,IECHO,IEND)
C=======================================================================
C     PURPOSE
C     to perturb nodal spacing by random fluctuations
C=======================================================================
      IMPLICIT NONE
      CHARACTER*78     LABEL
      INTEGER          IIN,IOUT,IECHO,IEND
C --- local variables --------------------------------------------------
      INTEGER          MT,ICOOR,IODEV,N,I,J,K,L,NNOD,NDIM,NODE,NODE1
      PARAMETER       (MT=3)
      INTEGER          NOD(MT),INC(MT),IGETPA
      DOUBLE PRECISION TEMP(MT),DELTA,PERT(MT),DNRM2,RANF,RR,DUM
C
      ICOOR = IODEV('COORD')
      NDIM  = IGETPA('NSPAR','NDIM',0)
C
      DUM = RANF(1)
C
 100  CONTINUE
      CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
      IF(INDEX(LABEL,'END').EQ.0) THEN
         READ(LABEL,*) NODE1
         CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
         CALL IZERO(NOD,MT)
         CALL IZERO(INC,MT)
         READ(LABEL,*) (NOD(I),INC(I),I=1,NDIM)
         CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
         READ(LABEL,*) DELTA
         DO K = 1, NOD(3) + 1
            DO J = 1, NOD(2) + 1
               DO I = 1, NOD(1) + 1
                  CALL RANVEC(PERT,NDIM)
                  RR = DELTA/DNRM2(NDIM,PERT,1)
                  CALL DSCAL(NDIM,RR,PERT,1)
                  NODE = NODE1+(I-1)*INC(1)+(J-1)*INC(2)+(K-1)*INC(3)
                  READ(ICOOR,REC=NODE) (TEMP(L),L=1,NDIM)
                  DO L = 1, NDIM
                     TEMP(L) = TEMP(L) + PERT(L)
                  END DO
                  WRITE(ICOOR,REC=NODE) (TEMP(L),L=1,NDIM)
               END DO
            END DO
         END DO
      ELSE
         RETURN
      END IF
      GOTO 100
C
      END
C***********************************************************************
      SUBROUTINE RNODE(LABEL,IIN,IOUT,IECHO,IEND)
C=======================================================================
C     Program to read nodal point coordinates
C=======================================================================
      IMPLICIT NONE
      CHARACTER*78     LABEL
      INTEGER          IIN,IOUT,IECHO,IEND
C --- local variables --------------------------------------------------
      INTEGER          MT,ICOOR,IODEV,N,I,NNOD,NDIM,NODE
      PARAMETER       (MT=3)
      DOUBLE PRECISION TEMP(MT)
C
      ICOOR=IODEV('COORD')
C
      CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
      READ(LABEL,*) NNOD,NDIM
      CALL PUTIPA('NSPAR','NDIM ',NDIM,0)
      CALL PUTIPA('NSPAR','NNOD ',NNOD,0)
C
      DO 200 N=1,NNOD
         CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
         READ(LABEL,*) NODE,(TEMP(I),I=1,NDIM)
         WRITE(ICOOR,REC=NODE) (TEMP(I),I=1,NDIM)
 200  CONTINUE
C
      END
C***********************************************************************
      SUBROUTINE RCFOR(LABEL,IIN,IOUT,IECHO,IERR)
C=======================================================================
C     Program to read concentrated force data
C=======================================================================
      IMPLICIT NONE
      CHARACTER*78     LABEL
      INTEGER          IIN,IOUT,IECHO,IERR
C --- local variables --------------------------------------------------
      INTEGER          ILOAD,N,NODE,IDOF,IODEV,IEND
      DOUBLE PRECISION FF
C
      ILOAD = IODEV('CLOAD')
      N     = 0
C
 100  CONTINUE
      CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
      IF(IEND.GT.0) RETURN
      IF(INDEX(LABEL,'END').EQ.0) THEN
         READ(LABEL,*) NODE,IDOF,FF
         N=N+1
         WRITE(ILOAD,REC=N) NODE,IDOF,FF
         GOTO 100
      ELSE
         CALL PUTIPA('NSPAR','NCFOR',N,0) 
         RETURN
      END IF
C
      END
C***********************************************************************
      SUBROUTINE RELEM(LABEL,IIN,IOUT,IECHO,IEND,IA)
C=======================================================================
C     Program to read and generate element data
C=======================================================================
      IMPLICIT NONE
      CHARACTER*78     LABEL
      INTEGER          IIN,IOUT,IECHO,IEND,IA(*)
C --- local variables --------------------------------------------------
      INTEGER          MT,IEN,NEL,NDOF,MDOF,NNOD,NG,NELG,IODEV
      PARAMETER       (MT=20)
      INTEGER          ITEMP(MT),NELE,NETYP,NENOD,NIX,NIY,NIZ,IEQEL
      INTEGER          MATER,LSECT,NOD,N,I,NNE,IETYP,ELTYPE
C
      IEN = IODEV('IENAR')
C
      CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
      READ(LABEL,*) NELG
      CALL PUTIPA('NSPAR','NELG ',NELG,0)
      NEL  = 0
      MDOF = 0
      NNOD = 0
      DO 300 NG=1,NELG
         IETYP = 0
         CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
         NETYP = ELTYPE(LABEL)
         IF(NETYP.EQ.2) THEN
            IF(INDEX(LABEL,'STRES').NE.0) IETYP = 1
            IF(INDEX(LABEL,'AXIS').NE.0)   IETYP = 2
         ELSE IF(NETYP.EQ.10) THEN
            IF(INDEX(LABEL,'SRI').NE.0) IETYP = 1
         END IF
         CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
         READ(LABEL,*) NELE,NENOD,NDOF,NIX,NIY,NIZ
         IF(INDEX(LABEL,'EQUAL-ELEM').EQ.0) THEN
            IEQEL = 0
         ELSE
            IEQEL = 1
         END IF
C
         CALL PUTIPA('NEPAR','NELE ',NELE,NG)
         CALL PUTIPA('NEPAR','NETYP',NETYP,NG)
         CALL PUTIPA('NEPAR','NENOD',NENOD,NG)
         CALL PUTIPA('NEPAR','NDOF ',NDOF,NG)
         CALL PUTIPA('NEPAR','IEQEL',IEQEL,NG)
         CALL PUTIPA('NEPAR','NIX  ',NIX,NG)
         CALL PUTIPA('NEPAR','NIY  ',NIY,NG)
         CALL PUTIPA('NEPAR','IETYP',IETYP,NG)
         CALL PUTIPA('NEPAR','NIZ  ',NIZ,NG)
C
         IF(INDEX(LABEL,'GENER').NE.0) THEN
            CALL GENEL(LABEL,IIN,IOUT,NENOD,IECHO,IEND,IA,NNOD)
         ELSE
            DO 200 N=1,NELE
               CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
               READ(LABEL,*) NNE,MATER,LSECT,(ITEMP(I),I=1,NENOD)
               WRITE(IEN,REC=NNE) MATER,LSECT,(ITEMP(I),I=1,NENOD)
C
               DO 180 I=1,NENOD
                  NOD     = ITEMP(I)
                  NNOD    = MAX(NNOD,NOD)
                  IA(NOD) = IA(NOD)+1
 180           CONTINUE
C
 200        CONTINUE
         END IF
C
         IF(NETYP.EQ.6) THEN
            CALL DIRANG(NG,NEL,NELE,NENOD)
         END IF
C
         NEL  = NEL + NELE
         MDOF = MAX(NDOF,MDOF)
 300  CONTINUE
C
      CALL PUTIPA('NSPAR','NDOF ',MDOF,0)
      CALL PUTIPA('NSPAR','NELE ',NEL,0)
C
      END
C***********************************************************************
      SUBROUTINE RELOAD(LABEL,IIN,IOUT,IECHO,IEND,IA)
C=======================================================================
C     Program to read  element load data
C=======================================================================
      IMPLICIT NONE
      CHARACTER*78     LABEL
      INTEGER          IIN,IOUT,IECHO,IEND,IA(*)
C --- local variables --------------------------------------------------
      INTEGER          MT,IEN,LOAD,NELG,IODEV
      PARAMETER       (MT=20)
      INTEGER          NELE,NETYP,NENOD,NIX,NIY,NIZ,IEQEL,L,NDIM
      INTEGER          MATER,LSECT,NOD,N,I,IN,J,K,NELB,IELG,IGETPA
      INTEGER          NEL(3),NINC(3),NLDIM
      DOUBLE PRECISION Q(MT)
C
      IEN  = IODEV('IENAR')
      LOAD = IODEV('ELOAD')
C
 100  CONTINUE
      CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
      IF(INDEX(LABEL,'END').GT.0) RETURN
C
      READ(LABEL,*) IELG
C
      NELG  = IGETPA('NSPAR','NELG ',0)
      NDIM  = IGETPA('NSPAR','NDIM ',0)
      NENOD = IGETPA('NEPAR','NENOD',IELG)
      NETYP = IGETPA('NEPAR','NETYP',IELG)
C
      IF((IELG.GT.0).AND.(IELG.LE.NELG)) THEN
         CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
         IF(INDEX(LABEL,'UNIF').NE.0) THEN
C
C --------- constant uniform load, generation possible  ----------
C
            CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
            READ(LABEL,*) NELB,(NEL(I),NINC(I),I=1,NDIM)
            IF((NETYP.EQ.1).OR.(NETYP.GE.10)) THEN
               NLDIM = 1
               CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
               READ(LABEL,*) Q(1)
            ELSE 
               NLDIM = NDIM
               CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
               READ(LABEL,*) (Q(I),I=1,NLDIM)
            END IF
C
            IF(NEL(1).LE.0) NEL(1) = 1
            IF(NEL(2).LE.0) NEL(2) = 1
            IF(NEL(3).LE.0) NEL(3) = 1
C
            DO K = 1, NEL(3)
               DO J = 1, NEL(2)
                  DO I = 1, NEL(1)
                     N = NELB
     &                    +(I-1)*NINC(1)+(J-1)*NINC(2)+(K-1)*NINC(3)
                     WRITE(LOAD,REC=N) ((Q(L),L=1,NLDIM),IN=1,NENOD)
                  END DO
               END DO
            END DO
         ELSE
C
C --------- load given at element's nodal points --------
C
            CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
            READ(LABEL,*) N
            IF((NETYP.EQ.1).OR.(NETYP.GE.10)) THEN
               NLDIM = 1
               CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
               READ(LABEL,*) (Q(I),I=1,NENOD)
            ELSE 
               NLDIM = NDIM
               CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
               READ(LABEL,*) ((Q((J-1)*NLDIM+I),I=1,NLDIM),J=1,NENOD)
            END IF
            WRITE(LOAD,REC=N) ((Q((J-1)*NLDIM+I),I=1,NLDIM),J=1,NENOD)
         END IF
      ELSE
         WRITE(IOUT,'('' NON-EXISTENT ELEMENT GROUP '',I8)') IELG
      END IF
      GOTO 100
C
      END
C***********************************************************************
      SUBROUTINE DIRANG(NG,NEL,NELE,NENOD)
C=======================================================================
C     Routine to set up director angles for arch element
C=======================================================================
      IMPLICIT NONE
      INTEGER          NG,NEL,NELE,NENOD
C --- locals -----------------------------------------------------------
      INTEGER          I,IEN,IGETPA,IODEV,N,NDIM,MT,MATER,LSECT
      PARAMETER       (MT=30)
      INTEGER          ITEMP(MT)
      DOUBLE PRECISION XYZ(3*MT)
C
      IEN   = IODEV('IENAR')
      NDIM  = IGETPA('NSPAR','NDIM ',0)
C
      DO N = NEL + 1, NEL + NELE
         READ(IEN,REC=N) MATER,LSECT,(ITEMP(I),I=1,NENOD)
         CALL COORD(XYZ,NDIM,ITEMP,NENOD)
         CALL DNANG(ITEMP,NENOD,N,XYZ)
      END DO
C
      END
C***********************************************************************
      SUBROUTINE DNANG(IEN,NENOD,N,XYZ)
C=======================================================================
C     Routine to compute the director angle
C=======================================================================
      IMPLICIT NONE
      INTEGER          IEN(*),NENOD,N
      DOUBLE PRECISION XYZ(NENOD,*)
C --- locals -----------------------------------------------------------
      INTEGER          I,IDEG,IELD,IOUT,IODEV,ML
      PARAMETER       (ML=4)
      DOUBLE PRECISION XI,DX,DXI(ML),DUM,DXXI,DYXI,PI2,CC,SS,PSI(ML),
     &                 DDOT
C
      IOUT = IODEV('OUTPU')
      IELD = IODEV('ELDAT')
      IDEG = NENOD - 1
      XI   = -1.D0
      DX   = 2.D0 / REAL(NENOD - 1)
      PI2  = 0.5D0*DACOS(-1.D0)
C
      IF(NENOD.GT.ML) THEN
         WRITE(IOUT,5000) NENOD,ML
         STOP
      END IF
C
      DO I = 1, NENOD
         CALL SIFL(XI,DXI,IDEG,1,IOUT)
         DXXI   = DDOT(NENOD,DXI,1,XYZ,1)
         DYXI   = DDOT(NENOD,DXI,1,XYZ(1,2),1)
         DUM    = DSQRT(DXXI*DXXI + DYXI*DYXI) 
         CC     = DXXI / DUM 
         SS     = DYXI / DUM
C
         IF(CC.EQ.0.D0) THEN
            PSI(I) = DASIN(SS) + PI2
         ELSE
            PSI(I) = DACOS(CC) + PI2
         END IF
C
         XI = XI + DX
C
      END DO
C
      WRITE(IELD,REC=N) (PSI(I),I=1,NENOD)
C
 5000 FORMAT(' *** ERROR in routine DNANG --- local array dimension',
     &       ' exceeded',/,
     &       ' NEDOF = ',I5,' MaxLocal array size = ',I5)
      END
C***********************************************************************
      INTEGER FUNCTION ELTYPE(LABEL)
C=======================================================================
C     PURPOSE
C     to get the element type number from written indicator label
C=======================================================================
      IMPLICIT NONE
      CHARACTER*(*) LABEL
C
      IF(INDEX(LABEL,'HEAT').NE.0) THEN
         ELTYPE = 1
      ELSE IF(INDEX(LABEL,'DIFF').NE.0) THEN
         ELTYPE = 1
      ELSE IF(INDEX(LABEL,'SOLI').NE.0) THEN
         ELTYPE = 2
      ELSE IF(INDEX(LABEL,'TRUS').NE.0) THEN
         ELTYPE = 3
      ELSE IF(INDEX(LABEL,'BEAM').NE.0) THEN
         ELTYPE = 4
      ELSE IF(INDEX(LABEL,'ARCH').NE.0) THEN
         ELTYPE = 6
      ELSE IF(INDEX(LABEL,'RMPL').NE.0) THEN
         ELTYPE = 10
      ELSE IF(INDEX(LABEL,'MITC').NE.0) THEN
         ELTYPE = 11
      END IF
C
      END
C***********************************************************************
      SUBROUTINE RBCON(LABEL,IIN,IOUT,IECHO,IEND)
C=======================================================================
C     Program to read boundary conditions
C=======================================================================
      IMPLICIT NONE
      CHARACTER*78     LABEL
      INTEGER          IIN,IOUT,IECHO,IEND
C --- local variables --------------------------------------------------
      INTEGER          MT,ID,NNOD,NDOF,N,I,J,NE,NG,IODEV,IGETPA
      PARAMETER       (MT=6)
      INTEGER          ITEMP(MT)
C
      ID   = IODEV('IDARR')
      NNOD = IGETPA('NSPAR','NNOD ',0)
      NDOF = IGETPA('NSPAR','NDOF ',0)
C
      CALL IZERO(ITEMP,NDOF)
      DO 100 N=1,NNOD
         WRITE(ID,REC=N) (ITEMP(I),I=1,NDOF)
 100  CONTINUE
C
 120  CONTINUE
      CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
      IF(IEND.GT.0) RETURN
      IF(INDEX(LABEL,'END').GT.0) RETURN
      READ(LABEL,*) N,NE,NG,(ITEMP(I),I=1,NDOF)
      IF (N.GT.0) THEN
         IF (NG.EQ.0) THEN
            NE = N
            NG = 1
         ELSE
            NE = NE - MOD(NE-N,NG)
         ENDIF
C
         DO 200 I=N,NE,NG
            WRITE(ID,REC=I) (ITEMP(J),J=1,NDOF)
 200     CONTINUE
      END IF
      GOTO 120
C
      END
C***********************************************************************
      SUBROUTINE RPARA(LABEL,IIN,IOUT,IECHO,IEND)
C=======================================================================
C     Program to read integer parameter data
C=======================================================================
      IMPLICIT NONE
      CHARACTER*78     LABEL
      INTEGER          IIN,IOUT,IECHO,IEND
C --- local variables --------------------------------------------------
      INTEGER          IMPAR,J,JJ,IND,IDUM,IODEV,ICHARC
      CHARACTER*78     L1,L2,L3
      DOUBLE PRECISION DATA
C
      IMPAR = IODEV('MPARA')
C
 100  CONTINUE
      CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
      IF(IEND.GT.0) RETURN
      IF(INDEX(LABEL,'END').GT.0) RETURN
      IND = ICHARC(LABEL,'=',78)
C
      IF(IND.GT.0) THEN
         DO 180 J=1,IND
            JJ=J
            CALL PARSER(LABEL,L2,L3,78,'=',',',JJ)
            READ(L2,*,END=1100,ERR=1100) DATA
            IF(INDEX(L3,'MITER').NE.0) THEN
               IDUM=INT(DATA)
               CALL PUTIPA('MPARA','MITER',IDUM,0)
	      ELSE IF(INDEX(L3,'NELPR').NE.0) THEN	
	         IDUM =INT(DATA)
               CALL PUTIPA('NSPAR','NELPR',IDUM,0)
            END IF
 180     CONTINUE
      END IF
      GOTO 100
C
 1100 CONTINUE
      END
C***********************************************************************
      SUBROUTINE RFPAR(PARAM,LABEL,IIN,IOUT,IECHO,IEND)
C=======================================================================
C     Program to read floating point parameter data
C=======================================================================
      IMPLICIT NONE
      CHARACTER        LABEL*78, PARAM*5
      INTEGER          IIN,IOUT,IECHO,IEND
C --- local variables --------------------------------------------------
      CHARACTER*78     L1,L2,L3
      INTEGER          ISET,IND,J,JJ,ICHARC
      DOUBLE PRECISION DATA
C
      ISET = 0
 100  CONTINUE
      CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
      IF(IEND.GT.0) RETURN
      IF(INDEX(LABEL,'END').GT.0) RETURN
      IF(INDEX(LABEL,'SET').GT.0) THEN
         READ(LABEL,*) ISET
         CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
         IF(IEND.GT.0) RETURN
      END IF
      IND = ICHARC(LABEL,'=',78)
      IF(IND.GT.0) THEN
         DO 180 J = 1,IND
            JJ = J
            CALL PARSER(LABEL,L2,L3,78,'=',',',JJ)
            READ(L2,*,END=1100,ERR=1100) DATA
            CALL PUTFPA(PARAM,L3(1:5),DATA,ISET)
 180     CONTINUE
      END IF
      GOTO 100
C
 1100 CONTINUE
      END
C***********************************************************************
      SUBROUTINE RTITLE(TITLE,IIN,IOUT,IECHO,IEND)
C=======================================================================
C     Program to read the title cards
C=======================================================================
      IMPLICIT NONE
      CHARACTER*78     TITLE(*)
      INTEGER          IIN,IOUT,IECHO,IEND
C --- local variables --------------------------------------------------
      INTEGER          MTIT,IGETPA,N
      CHARACTER*78     LABEL
C
      MTIT = IGETPA('MPARA','MTIT ',0)
      N    = 0
C
 100  CONTINUE
      CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
      IF(IEND.GT.0) RETURN
      IF(INDEX(LABEL,'END').GT.0) THEN
         CALL PUTIPA('NSPAR','NTIT ',N,0)
         RETURN
      END IF
      N = N + 1
      READ(LABEL,'(A)') TITLE(N)
      IF(N.LT.MTIT) THEN
         GOTO 100
      ELSE
         WRITE(IOUT,5000)
         STOP
      END IF
C
 5000 FORMAT(' *** ERROR *** TOO MANY TITLE CARDS ')
      END
C***********************************************************************
      SUBROUTINE RVARSP(LABEL,IIN,IOUT,IECHO,IEND)
C=======================================================================
C     Program to read  variable section  data
C=======================================================================
      IMPLICIT NONE
      CHARACTER*78     LABEL
      INTEGER          IIN,IOUT,IECHO,IEND
C --- local variables --------------------------------------------------
      INTEGER          MT,IEN,IELD,NELG,IODEV
      PARAMETER       (MT=27)
      INTEGER          MAT,LSE,NETYP,NENOD
      INTEGER          NOD,N,I,IELG,IGETPA,ITMP(MT)
      DOUBLE PRECISION T(MT),B(MT),P(MT)
C
      IEN  = IODEV('IENAR')
      IELD = IODEV('ELDAT')
C
 100  CONTINUE
      CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
      IF(INDEX(LABEL,'END').GT.0) RETURN
C
      READ(LABEL,*) IELG
C
      NELG  = IGETPA('NSPAR','NELG ',0)
      NENOD = IGETPA('NEPAR','NENOD',IELG)
      NETYP = IGETPA('NEPAR','NETYP',IELG)
C
      IF((IELG.GT.0).AND.(IELG.LE.NELG)) THEN
         CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
         IF(NETYP.EQ.6) THEN
            READ(LABEL,*) N,(B(I),T(I),I=1,NENOD)
            READ(IELD,REC=N) (P(I),I=1,NENOD)
            WRITE(IELD,REC=N) (P(I),B(I),T(I),I=1,NENOD)
         ELSE 
            READ(LABEL,*) N,(T(I),I=1,NENOD)
            WRITE(IELD,REC=N) (T(I),I=1,NENOD)
         END IF
C
C ------ be sure that the section set number will be zero ----
C
         READ(IEN,REC=N) MAT,LSE,(ITMP(I),I=1,NENOD)
         WRITE(IEN,REC=N) MAT,0,(ITMP(I),I=1,NENOD)
      END IF
C
      GOTO 100
C
      END
C***********************************************************************
      SUBROUTINE UNODE(IA)
C=======================================================================
C     PURPOSE
C     to mark unused nodes (symbol = 4 in ID array)
C=======================================================================
      IMPLICIT NONE
      INTEGER IA(*),ML
      PARAMETER (ML = 30)
      INTEGER N,NE,NG,NELG,NEL,NENOD,NNOD,ID,IEN,IODEV,IGETPA
      INTEGER LEN(ML),J,NDOF,MAT,LSE
C
      ID   = IODEV('IDARR')
      IEN  = IODEV('IENAR')
      NELG = IGETPA('NSPAR','NELG ',0)
      NNOD = IGETPA('NSPAR','NNOD ',0)
      NDOF = IGETPA('NSPAR','NDOF ',0)
C
      CALL IZERO(IA,NNOD)
C
      NE = 0
      DO NG = 1, NELG
         NEL   = IGETPA('NEPAR','NEL  ',NG)
         NENOD = IGETPA('NEPAR','NENOD',NG)
         DO N = 1, NEL
            NE = NE + 1
            READ(IEN,REC = NE) MAT,LSE,(LEN(J),J=1,NENOD)
            DO J = 1, NENOD
               IA(LEN(J)) = 1
            END DO
         END DO
      END DO
C
      DO N = 1, NNOD
         IF(IA(N).EQ.0) THEN
            WRITE(ID,REC=N) (4,J=1,NDOF)
         END IF
      END DO
C
      CALL IZERO(IA,NNOD)
C
      END
C***********************************************************************
      SUBROUTINE EQNUM(PERM)
C=======================================================================
C     Program to determine equation numbers
C-----------------------------------------------------------------------
C     NEQ =  number of active dof's
C=======================================================================
      IMPLICIT NONE
      INTEGER      PERM(*)
      INTEGER      MT,ID,NNOD,NDOF,NEQ,N,NN,I,K,IODEV,IGETPA
      PARAMETER   (MT=6)
      INTEGER      ITEMP(MT)
      CHARACTER*78 LABEL
C
      ID   = IODEV('IDARR')
      NNOD = IGETPA('NSPAR','NNOD ',0)
      NDOF = IGETPA('NSPAR','NDOF ',0)
C
      NEQ = 0	
C
      DO 400 N=1,NNOD
         NN=PERM(N)
         CALL IZERO(ITEMP,NDOF)
         READ(ID,REC=NN) (ITEMP(I),I=1,NDOF)
         DO 300 I=1,NDOF
            K=ITEMP(I)
            IF(K.EQ.0) THEN
               NEQ = NEQ + 1
               ITEMP(I) = NEQ
            ELSE IF(K.GT.0) THEN
               ITEMP(I) = 0
            END IF
 300     CONTINUE
         WRITE(ID,REC=NN) (ITEMP(I),I=1,NDOF)
 400  CONTINUE
      CALL PUTIPA('NSPAR','NEQ  ',NEQ,0)
C
      END
C***********************************************************************
      SUBROUTINE BANDW
C=======================================================================
C     Program to determine maximum half bandwidth
C=======================================================================
      IMPLICIT NONE
      INTEGER      MT,ML,ID,IEN,NEQ,NELG,NDOF,NE,NBAND,NG,NEL,NENOD,LDOF
      INTEGER      NEDOF,I,NGK,IODEV,IGETPA,MAT,LSE,J,ISYM
      PARAMETER   (MT=20,ML=60)
      INTEGER      LEN(MT),LM(ML)
      CHARACTER*78 LABEL
C
      ID  = IODEV('IDARR')
      IEN = IODEV('IENAR')
C
      NEQ   = IGETPA('NSPAR','NEQ  ',0)
      NELG  = IGETPA('NSPAR','NELG ',0)
      NDOF  = IGETPA('NSPAR','NDOF ',0)
      ISYM  = IGETPA('NSPAR','ISYM ',0)
      NE    = 0
      NBAND = 0
C
      DO 200 NG=1,NELG
         NEL   = IGETPA('NEPAR','NEL  ',NG)
         NENOD = IGETPA('NEPAR','NENOD',NG)
         LDOF  = IGETPA('NEPAR','NDOF ',NG)
         NEDOF = NENOD*LDOF
         DO 100 I=1,NEL
            NE = NE + 1
            CALL IZERO(LEN,NENOD)
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            CALL IZERO(LM,NEDOF)
            CALL FORMLM(LM,LEN,ID,NENOD,LDOF)
            CALL BAND(LM,NEDOF,NBAND)
 100     CONTINUE
 200  CONTINUE
C
      IF(ISYM.EQ.0) NBAND = 2*(NBAND - 1) + 1
      NGK = NEQ*NBAND
      CALL PUTIPA('NSPAR','NGK  ',NGK,0)
      CALL PUTIPA('NSPAR','NBAND',NBAND,0)
C
      END
C***********************************************************************
      SUBROUTINE BAND(LM,NEDOF,NBAND)
C=======================================================================
C     Update the matrix bandwidth
C=======================================================================
      IMPLICIT NONE
      INTEGER LM(*),NEDOF,NBAND
C --- local variables --------------------------------------------------
      INTEGER MIN,MAX,I,IDOF,IDIF
C
      MAX = 0
      MIN = 10000000
C
C     find the largest and smallest equation number
C
      DO 100 I = 1, NEDOF
         IDOF = LM(I)
         IF(IDOF.GT.0) THEN
            MAX = MAX0(MAX,IDOF)
            MIN = MIN0(MIN,IDOF)
         END IF
 100  CONTINUE
C
      IDIF = MAX - MIN + 1
      IF(IDIF.GT.NBAND) NBAND = IDIF
C
      END
C***********************************************************************
      SUBROUTINE WRDAT(TITLE)
C=======================================================================
C     Program to write global parameter data
C=======================================================================
      IMPLICIT NONE
      CHARACTER*78 TITLE(*)
C --- local variables --------------------------------------------------
      INTEGER      MENOD 
      PARAMETER   (MENOD = 30)
      INTEGER      N,NDIM,NNOD,NELG,NEL,NELE,NEQ,NBAND,NGK,NTIT,NENOD,
     &             IOUT,I,IEN,IODEV,IGETPA,IPLOT,ICOOR,J,MESH,MAT,LSE,
     &             NE,ITMP(MENOD),NETYP
      DOUBLE PRECISION TEMP(3)
C
      NDIM  = IGETPA('NSPAR','NDIM ',0)
      NNOD  = IGETPA('NSPAR','NNOD ',0)
      NELG  = IGETPA('NSPAR','NELG ',0)
      NELE  = IGETPA('NSPAR','NELE ',0)
      NEQ   = IGETPA('NSPAR','NEQ  ',0)
      NBAND = IGETPA('NSPAR','NBAND',0)
      NGK   = IGETPA('NSPAR','NGK  ',0)
      NTIT  = IGETPA('NSPAR','NTIT ',0)
C
      IOUT  = IODEV('OUTPU')
      IPLOT = IODEV('PLOT')
      MESH  = IODEV('MESH')
      ICOOR = IODEV('COORD')
      IEN   = IODEV('IENAR')
C
      WRITE(IOUT,'(1X,78A1)') ('*',I=1,78)
      WRITE(IOUT,'(1X,78A1)') ('=',I=1,78)
      WRITE(*,'(1X,78A1)') ('*',I=1,78)
      WRITE(*,'(1X,78A1)') ('=',I=1,78)
C
      WRITE(IOUT,'('' Job title: '')')
      WRITE(*,'('' Job title: '')')
      DO I = 1, NTIT
         WRITE(*, '(A)') TITLE(I)
         WRITE(IOUT, '(A)') TITLE(I)
         WRITE(MESH, '(A)') TITLE(I)
         WRITE(IPLOT,'(A)') TITLE(I)
      END DO
      WRITE(MESH ,'(80A1)')    ('#',I=1,78)
      WRITE(IPLOT,'(1X,78A1)') ('=',I=1,78)
C
C --- write mesh data, i.e. nodal coordinates and element connectivity ---
C
      WRITE(MESH,'(2(1X,I7))') NNOD,NDIM
      DO I = 1, NNOD
         READ(ICOOR,REC=I) (TEMP(J),J=1,NDIM)
         WRITE(MESH,'(I8,3(1P,E16.8))') I,(TEMP(J),J=1,NDIM)
      END DO
      WRITE(MESH ,'(80A1)') ('#',I=1,78)
C
      NE = 0
      WRITE(MESH,'(1X,I7)') NELG
      DO N = 1, NELG
         NEL   = IGETPA('NEPAR','NEL  ',N)
         NENOD = IGETPA('NEPAR','NENOD',N)
         NETYP = IGETPA('NEPAR','NETYP',N)
         WRITE(MESH,'(3(1X,I7))') NETYP,NEL,NENOD
         DO I = 1, NEL
            NE = NE + 1
            READ(IEN,REC=NE) MAT,LSE,(ITMP(J),J=1,NENOD)
            WRITE(MESH,'(32(1X,I7))') MAT,LSE,(ITMP(J),J=1,NENOD)
         END DO
      END DO
      WRITE(MESH ,'(80A1)') ('#',I=1,78)
C
C --- write neutral file ----
C
      CALL WRNEUT(TITLE)
C
C --- some characteristic numbers to standard output -----
C
      WRITE(*,'(1X,78A1)') ('=',I=1,78)
      WRITE(*,5000) NNOD,NELG,NELE,NEQ,NBAND,NGK
      WRITE(*,'(1X,78A1)') ('=',I=1,78)
      WRITE(IOUT,'(1X,78A1)') ('=',I=1,78)
      WRITE(IOUT,5000) NNOD,NELG,NELE,NEQ,NBAND,NGK
      WRITE(IOUT,'(1X,78A1)') ('=',I=1,78)
C
 5000 FORMAT(' NUMBER OF NODES           = ',I15,/,
     &       ' NUMBER OF ELEMENT GROUPS  = ',I15,/,
     &       ' NUMBER OF ELEMENTS        = ',I15,/,
     &       ' NUMBER OF EQUATIONS       = ',I15,/,
     &       ' MAXIMUM BANDWIDTH         = ',I15,/,
     &       ' NUMBER OF MATRIX ELEMENTS = ',I15)
      END
C***********************************************************************
      SUBROUTINE FORMLM(LM,LEN,ID,NENOD,NDOF)
C=======================================================================
C     Program to form the local - global dof map (location matrix)
C=======================================================================
      IMPLICIT NONE
      INTEGER LM(*),LEN(*),ID,NENOD,NDOF
C --- local varaibles --------------------------------------------------
      INTEGER    MT,I,J,JJ,NODE
      PARAMETER (MT=6)
      INTEGER    LD(MT)
C
      DO J=1,NENOD
         NODE=LEN(J)
         CALL IZERO(LD,NDOF)
         READ(ID,REC=NODE) (LD(I),I=1,NDOF)
         JJ=(J-1)*NDOF
         DO I=1,NDOF
            LM(JJ+I)=LD(I)
         END DO
      END DO
C
      END
C***********************************************************************
      SUBROUTINE REREC(LABEL,IIN,IOUT,IEND,IECHO)
C=======================================================================
C     Program to read a input file record and skip the comment cards
C======================================================================= 
      IMPLICIT NONE
      CHARACTER*78 LABEL
      INTEGER      IIN,IOUT,IECHO,IEND
C
      IEND = 0
C
 100  CONTINUE
      READ(IIN,'(A)',END=200) LABEL
C
      IF(INDEX(LABEL,'**').NE.0)      GOTO 100
      IF(INDEX(LABEL,'ENDDATA').NE.0) GOTO 200
C
      IF(IECHO.GT.0) WRITE(IOUT,'(A)') LABEL
      RETURN
C
 200  CONTINUE
      IEND = 1
C
      END
C***********************************************************************
      SUBROUTINE PARSER(L1,L2,L3,N,C1,C2,IND)
C=======================================================================
C     Program to parse input card
C=======================================================================
      IMPLICIT NONE
      INTEGER     N,IND
      CHARACTER*1 L1(N),L2(N),L3(N),C1,C2
C --- local variables --------------------------------------------------
      INTEGER NB,ND,NE,NP,IC,I
C
      NB = 1
      NE = N
      NP = 1
      IC = 0
C
      DO 100 I = 1,N
         IF(L1(I).EQ.C2) THEN
            IF(IC.EQ.IND-1) THEN
               NP = I
            END IF
         END IF
         IF(L1(I).EQ.C1) THEN
            IC = IC + 1
            IF(IC.EQ.IND) THEN
               NB = I
               GOTO 120
            END IF
         END IF
 100  CONTINUE
C
 120  CONTINUE
      DO 140 I = 1,N
         L2(I) = ' '
         L3(I) = ' '
 140  CONTINUE
C
      IC = 0
      DO 160 I = NB,N
         IF(L1(I).EQ.C2) THEN
            NE = I - 1
            GOTO 180
         END IF
 160  CONTINUE
C
 180  CONTINUE
      ND = NE - NB
      DO 200 I = 1,ND
         L2(I) = L1(NB+I)
 200  CONTINUE
C
      ND = NB - NP
      DO 220 I = 1,ND
         L3(I) = L1(NP+I)
 220  CONTINUE
C
      END
C***********************************************************************
      INTEGER FUNCTION ICHARC(L,C,N)
C=======================================================================
C     Function to count an occurrence of C in L
C=======================================================================
      IMPLICIT NONE
      INTEGER     N
      CHARACTER*1 L(N),C
C --- local variables --------------------------------------------------
      INTEGER     I
C
      ICHARC = 0
      DO 100 I = 1, N
         IF(L(I).EQ.C) ICHARC = ICHARC + 1
 100  CONTINUE
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE RANVEC(V,N)
C=======================================================================
C     Program to generate a random vector
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION V(1)
C
      DO J=1,N
         V(J)=2.*RANDO()-1.
      END DO
C
      END
C*********************************************************************** 
      FUNCTION RANF(ISTART)
C=======================================================================
C     Program to pic up random numbers
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (L=1029,I=221591,M=1048579)
      SAVE ISEED
      DATA ISEED /0/
C
      ISEED=MOD(ABS(ISTART),M)
      ENTRY RANDO()
      ISEED=MOD(ISEED*L+I,M)
      RANDO=REAL(ISEED)/REAL(M)  
C
      END
C***********************************************************************
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C-***-END-OF-FILE-******************************************************
