C***********************************************************************
      SUBROUTINE INTPNT(SK,WGTH,NIP,NENOD,IDEG,ITR,NDIM,NSK,NG)
C=======================================================================
C     Program to set up proper numerical integration 
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (MP=9)
      DIMENSION SK(1),WGTH(1)
      DIMENSION SKX(MP),SKY(MP),SKZ(MP),WGTX(MP),WGTY(MP),WGTZ(MP)
C
      NSK = NDIM
      ITR = 0
      IF(NDIM.EQ.1) THEN
         NIP = IGETPA('NEPAR','NIX  ',NG)
         CALL GAUSSP(SK,WGTH,NIP)
         IDEG = NENOD-1
      ELSE IF(NDIM.EQ.2) THEN
         IF((NENOD.EQ.3).OR.(NENOD.EQ.6)) ITR=1
         NIX = IGETPA('NEPAR','NIX  ',NG)
         NIY = IGETPA('NEPAR','NIY  ',NG)
         NIP = NIX*NIY
         CALL INTP2D(SK,WGTH,NIX,NIY,NIP,NENOD,IDEG,ITR,NSK,NG)
      ELSE IF(NDIM.EQ.3) THEN
         IF((NENOD.EQ.4).OR.(NENOD.EQ.10)) ITR=1
         IF(ITR.EQ.0) THEN
            NIX=IGETPA('NEPAR','NIX  ',NG)
            NIY=IGETPA('NEPAR','NIY  ',NG)
            NIZ=IGETPA('NEPAR','NIZ  ',NG)
            NIP=NIX*NIY*NIZ
            CALL GAUSSP(SKX,WGTX,NIX)
            CALL GAUSSP(SKY,WGTY,NIY)
            CALL GAUSSP(SKZ,WGTZ,NIZ)
            IP=0
            DO 260 IZ=1,NIZ
               DO 240 IY=1,NIY
                  DO 220 IX=1,NIX
                     IP=IP+1
                     II=(IP-1)*NDIM
                     WGTH(IP)=WGTX(IX)*WGTY(IY)*WGTZ(IZ)
                     SK(II+1)=SKX(IX)
                     SK(II+2)=SKY(IY)
                     SK(II+3)=SKZ(IZ)
 220              CONTINUE
 240           CONTINUE
 260        CONTINUE
         END IF
      END IF
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE INTP2D(SK,WGTH,NIX,NIY,NIP,NENOD,IDEG,ITR,NSK,NG)
C=======================================================================
C     Program to set up proper numerical integration in 2D
C=======================================================================
      IMPLICIT NONE
      INTEGER          NIX,NIY,NIP,NENOD,IDEG,ITR,NSK,NG
      DOUBLE PRECISION SK(*),WGTH(*)
      INTEGER          MP,IP,IY,IX,II
      PARAMETER       (MP = 9)
      DOUBLE PRECISION SKX(MP),SKY(MP),WGTX(MP),WGTY(MP)
C
      IF(ITR.EQ.0) THEN
         NSK = 2
         CALL GAUSSP(SKX,WGTX,NIX)
         CALL GAUSSP(SKY,WGTY,NIY)
         IP=0
         DO IY=1,NIY
            DO IX=1,NIX
               IP=IP+1
               II=(IP-1)*2
               WGTH(IP)=WGTX(IX)*WGTY(IY)
               SK(II+1)=SKX(IX)
               SK(II+2)=SKY(IY)
            END DO
         END DO
         IF(NENOD.EQ.4) THEN
            IDEG=1
         ELSE
            IDEG=2
         END IF
      ELSE
         NSK = 3
         NIP = NIX
         CALL QTRIA(SK,WGTH,NIP)
      END IF
C
      END
C***********************************************************************
      SUBROUTINE GAUSSP(SK,WGTH,NIP)
C=======================================================================
C     Program to set up sampling points and weigths in 
C             Gauss-Legendre numerical integration
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION SK(1),WGTH(1)
C
      IF(NIP.EQ.1) THEN
        SK(1)=0.D0
        WGTH(1)=2.D0
      ELSE IF(NIP.EQ.2) THEN
        SK(1)=-.577350269189626D0
        SK(2)=-SK(1)
        WGTH(1)=1.D0
        WGTH(2)=WGTH(1)
      ELSE IF(NIP.EQ.3) THEN
        SK(1)=-.774596669241483D0
        SK(2)=0.D0
        SK(3)=-SK(1)
        WGTH(1)=.555555555555556D0
        WGTH(2)=.888888888888889D0
        WGTH(3)=WGTH(1)
      ELSE IF(NIP.EQ.4) THEN
        SK(1)=-.861136311594053D0
        SK(2)=-.339981043584856D0
        SK(3)=-SK(2)
        SK(4)=-SK(1)
        WGTH(1)=.347854845137454D0
        WGTH(2)=.652145154862546D0
        WGTH(3)=WGTH(2)
        WGTH(4)=WGTH(1)
      ELSE IF(NIP.EQ.5) THEN
        SK(1)=-.906179845938664D0
        SK(2)=-.538469310105683D0
        SK(3)=0.D0
        SK(4)=-SK(2)
        SK(5)=-SK(1)
        WGTH(1)=.236926885056189D0
        WGTH(2)=.478628670499366D0
        WGTH(3)=.568888888888889D0
        WGTH(4)=WGTH(2)
        WGTH(5)=WGTH(1)
      ELSE IF(NIP.EQ.6) THEN
        SK(1)=-.932469514203152D0
        SK(2)=-.661209386466265D0
        SK(3)=-.238619186083197D0
        SK(4)=-SK(3)
        SK(5)=-SK(2)
        SK(6)=-SK(1)
        WGTH(1)=.171324492379170D0
        WGTH(2)=.360761573048139D0
        WGTH(3)=.467913934572691D0
        WGTH(4)=WGTH(3)
        WGTH(5)=WGTH(2)
        WGTH(6)=WGTH(1)
      ELSE IF(NIP.EQ.7) THEN
        SK(1)=-.949107912342759D0
        SK(2)=-.741531185599394D0
        SK(3)=-.405845151377397D0
        SK(4)=0.D0
        SK(5)=-SK(3)
        SK(6)=-SK(2)
        SK(7)=-SK(1)
        WGTH(1)=.129484966168870D0
        WGTH(2)=.279705391489277D0
        WGTH(3)=.381830050505119D0
        WGTH(4)=.417959183673469D0
        WGTH(5)=WGTH(3)
        WGTH(6)=WGTH(2)
        WGTH(7)=WGTH(1)
      ELSE IF(NIP.EQ.8) THEN
        SK(1)=-.960289856497536D0
        SK(2)=-.796666477413627D0
        SK(3)=-.525532409916329D0
        SK(4)=-.183434642495650D0
        SK(5)=-SK(4)
        SK(6)=-SK(3)
        SK(7)=-SK(2)
        SK(8)=-SK(1)
        WGTH(1)=.101228536290376D0
        WGTH(2)=.222381034453374D0
        WGTH(3)=.313706645877887D0
        WGTH(4)=.362683783378362D0
        WGTH(5)=WGTH(4)
        WGTH(6)=WGTH(3)
        WGTH(7)=WGTH(2)
        WGTH(8)=WGTH(1)
      ELSE IF(NIP.EQ.9) THEN
        SK(1)=-.968160239507626D0
        SK(2)=-.836031107326636D0
        SK(3)=-.613371432700590D0
        SK(4)=-.324253423403809D0
        SK(5)=0.D0
        SK(6)=-SK(4)
        SK(7)=-SK(3)
        SK(8)=-SK(2)
        SK(9)=-SK(1)
        WGTH(1)=.081274388361574D0
        WGTH(2)=.180648160694857D0
        WGTH(3)=.260610696402935D0
        WGTH(4)=.312347077040003D0
        WGTH(5)=.330239355001260D0
        WGTH(6)=WGTH(4)
        WGTH(7)=WGTH(3)
        WGTH(8)=WGTH(2)
        WGTH(9)=WGTH(1)
      END IF
      RETURN
      END
C***********************************************************************
      SUBROUTINE QTRIA(SK,WGTH,NIP)
C=======================================================================
C     Program to set up the numerical quadrature points and weights
C             for triangles (in area coordinates)
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION SK(3,1),WGTH(1)
C
      ONTH=1.D0/3.D0
      ONSI=1.D0/6.D0
      TWTH=2.D0/3.D0
C
      IF(NIP.EQ.1) THEN
         SK(1,1)=ONTH
         SK(2,1)=SK(1,1)
         WGTH(1)=1.0D0
      ELSE IF(NIP.EQ.3) THEN
         SK(1,1)=TWTH
         SK(2,1)=ONSI
         SK(1,2)=SK(2,1)
         SK(2,2)=SK(1,1)
         SK(1,3)=SK(2,1)
         SK(2,3)=SK(2,1)
         WGTH(1)=ONTH
         WGTH(2)=WGTH(1)
         WGTH(3)=WGTH(1)
      ELSE IF(NIP.EQ.4) THEN
         SK(1,1)=ONTH
         SK(2,1)=SK(1,1)
         SK(1,2)=0.6D0
         SK(2,2)=0.2D0
         SK(1,3)=SK(2,2)
         SK(2,3)=SK(1,2)
         SK(1,4)=SK(2,2)
         SK(2,4)=SK(2,2)
         WGTH(1)=-9.D0/16.D0
         WGTH(2)=25.D0/48.D0
         WGTH(3)=WGTH(2)
         WGTH(4)=WGTH(2)
      ELSE IF(NIP.EQ.7) THEN
         SK(1,1)=ONTH
         SK(2,1)=SK(1,1)
         SK(1,2)=0.797426985353087
         SK(2,2)=0.101286507323456
         SK(1,3)=SK(2,2)
         SK(2,3)=SK(1,2)
         SK(1,4)=SK(2,2)
         SK(2,4)=SK(2,2)
         SK(1,5)=0.470142064105115
         SK(2,5)=0.059715871789770
         SK(1,6)=SK(2,5)
         SK(2,6)=SK(1,5)
         SK(1,7)=SK(1,5)
         SK(2,7)=SK(1,5)
         WGTH(1)=0.225
         WGTH(2)=0.125939180544827
         WGTH(3)=WGTH(2)
         WGTH(4)=WGTH(2)
         WGTH(5)=0.132394152788506
         WGTH(6)=WGTH(5)
         WGTH(7)=WGTH(5)
      END IF
      DO 100 I=1,NIP
         SK(3,I)=1.D0-SK(1,I)-SK(2,I)
         WGTH(I)=0.5D0*WGTH(I)
 100  CONTINUE
      RETURN
      END
C***********************************************************************
