C***********************************************************************
      SUBROUTINE PRESOL(PC,A,IA,Y,X,N,ITR)
C=======================================================================
C     Driver routine for preconditioning step  My = x
C-----------------------------------------------------------------------
C     NOTE:  x should not be overwritten
C=======================================================================
      IMPLICIT NONE
      INTEGER IA(*),N,ITR
      REAL*8  PC(*),A(*),X(*),Y(*)
C --- locals ---
      INTEGER NA,N2,I,NP,NPC,NB,ISYM,ISTM,IPREC,IGETPA,IODEV,IOUT,ISTMO
C
      DO I=1,N
         Y(I)=0.D0
      END DO
C
      NA=IGETPA('NSPAR','NGK',0)
      N2=NA+N+2
      NP=IGETPA('NSPAR','NPR',0)
C
      IF(NP.GT.0) THEN
         NPC=N2
      ELSE
         NPC=1
      END IF
      NPC=1
C
      IPREC=IGETPA('NSPAR','IPREC',0)
      ISTMO=IGETPA('NSPAR','ISTMO',0)
C
      IF(IPREC.EQ.0) THEN
         CALL DCOPY(N,X,1,Y,1)
      ELSE IF(IPREC.EQ.1) THEN
         CALL ICBKS(PC,IA(NPC),Y,X,N,NA,ISTMO)
      ELSE IF(IPREC.EQ.100) THEN
         IF(ITR.NE.1) THEN
            CALL LUFBKS(PC,IA,Y,X,N,NA,ISTMO)
         ELSE
            CALL LUTFBK(PC,IA,Y,X,N,NA,ISTMO)
         END IF
      ELSE
         IOUT=IODEV('OUTPU')
         WRITE(IOUT,'('' Nonexistent preconditioner '')')
         STOP
      END IF 
C
      END
C***********************************************************************
      SUBROUTINE ICBKS(A,IA,Y,X,N,NA,ISTMO)
C=======================================================================
C     Driver routine for sparse incomplete LU backsubstitution  LUy = x 
C=======================================================================
      IMPLICIT NONE
      INTEGER IA(*),N,N1,NA,NB,ISTMO
      REAL*8  A(*),X(*),Y(*)
C
      N1=N+2
      NB=NA/N
C
      IF(ISTMO.EQ.4) THEN
         CALL ICBKS4(A,IA,IA(N1),Y,X,N)
      ELSE IF(ISTMO.EQ.5) THEN
         CALL ICBKS5(A,IA,IA(N1),Y,X,N)
      ELSE IF(ISTMO.EQ.7) THEN
         CALL ICBKS7(A,IA,Y,X,N,NB)
      END IF
C
      END
C***********************************************************************
      SUBROUTINE ICBKS4(A,IRS,ICN,Y,X,N)
C=======================================================================
C     Program for load vector reduction and backsubstitution CSR-format
C=======================================================================
      IMPLICIT NONE
      INTEGER IRS(*),ICN(*),N
      INTEGER I,L,II,J,K
      REAL*8  A(*),Y(*),X(*),D1
C
      CALL DCOPY(N,X,1,Y,1)
C
      DO I=1,N
         D1=0.D0
         DO L=IRS(I),IRS(I+1)-2
            D1=D1+A(L)*Y(ICN(L))
         END DO
         II=IRS(I+1)-1
         Y(I)=(Y(I)-D1)/A(II)
      END DO
C
      DO I=N,1,-1
         J=IRS(I+1)-1
         Y(I)=Y(I)/A(J)
         DO K=IRS(I+1)-2,IRS(I),-1
            Y(ICN(K))=Y(ICN(K))-A(K)*Y(I)
         END DO
      END DO
C
      END
C***********************************************************************
      SUBROUTINE ICBKS5(A,ICS,IRN,Y,X,N)
C=======================================================================
C     Program for load vector reduction and backsubstitution CSC-format
C=======================================================================
      IMPLICIT NONE
      INTEGER ICS(1),IRN(1),N
      INTEGER I,L,II,J,K
      REAL*8  A(1),Y(1),X(1),D1
C
      CALL DCOPY(N,X,1,Y,1)
C
C
      END
C***********************************************************************
      SUBROUTINE ICBKS7(A,IDP,Y,X,N,NB)
C=======================================================================
C     Program for load vector reduction and backsubstitution DIA format
C=======================================================================
      IMPLICIT NONE
      INTEGER IDP(1),N,NB
      INTEGER I,J,K,L
      REAL*8  A(N,NB),Y(1),X(1),D1
C
      CALL DCOPY(N,X,1,Y,1)
C
      DO I=1,N
         D1=0.D0
         DO L=1,NB-1
            K=I+IDP(L)
            J=MAX(1,K)
            D1=D1+A(I,L)*Y(J)
         END DO
         Y(I)=(Y(I)-D1)/A(I,NB)
      END DO
C
      DO I=N,1,-1
         Y(I)=Y(I)/A(I,NB)
         DO L=NB-1,1,-1
            K=I+IDP(L)
            J=MAX(1,K)
            Y(J)=Y(J)-A(I,L)*Y(I)
         END DO
      END DO
C
      END
C***********************************************************************
      SUBROUTINE LUFBKS(A,IA,Y,X,N,NA,ISTMO)
C=======================================================================
C     Driver routine for sparse incomplete LU backsubstitution  LUy = x 
C=======================================================================
      IMPLICIT NONE
      INTEGER IA(1),IP(1),N,N1,N2,NB,NA,ISTMO
      REAL*8  A(1),X(1),Y(1)
C
      N1=N+2
      N2=N1+NA
      NB=NA/N
C
      IF(ISTMO.EQ.4) THEN
         CALL LUFBK4(A,IA,IA(N1),IA(N2),Y,X,N)
      ELSE IF(ISTMO.EQ.7) THEN
         WRITE(6,'('' ROUTINE LUFBK NOT EXISTING FOR ILU'')')
C         CALL LUFBK7(A,IA,Y,X,N,NB)
      END IF
C
      END
C***********************************************************************
      SUBROUTINE LUFBK4(A,IRS,ICN,IDP,Y,X,N)
C=======================================================================
C     Program for sparse incomplete LU solution phase LUy = x 
C     Compressed row storage format
C=======================================================================
      IMPLICIT NONE
      INTEGER IRS(1),ICN(1),IDP(1),N,I,L
      REAL*8  A(1),X(1),Y(1)
C
C --- Ly = x 
C
      DO I=1,N
         Y(I)=X(I)
         DO L=IRS(I),IDP(I)-1
            Y(I)=Y(I)-A(L)*Y(ICN(L))
         END DO
      END DO 
C
C --- Uy = y  
C
      DO I=N,1,-1
         DO L=IDP(I)+1,IRS(I+1)-1
            Y(I)=Y(I)-A(L)*Y(ICN(L))
         END DO
         Y(I)=A(IDP(I))*Y(I)
      END DO
C
      END
C***********************************************************************
      SUBROUTINE LUTFBK(A,IA,Y,X,N,NA,ISTMO)
C=======================================================================
C     Driver routine for sparse incomplete LU-transpose
C     solution  (LU)^T y = x 
C=======================================================================
      IMPLICIT NONE
      INTEGER IA(1),IP(1),N,N1,N2,NB,NA,ISTMO
      REAL*8  A(1),X(1),Y(1)
C
      N1=N+2
      N2=N1+NA
      NB=NA/N
C
      IF(ISTMO.EQ.4) THEN
         CALL LUTFBK4(A,IA,IA(N1),IA(N2),Y,X,N)
      ELSE IF(ISTMO.EQ.7) THEN
         WRITE(6,'('' ROUTINE LUTFBK NOT EXISTING FOR ILU2'')')
C         CALL LUTFBK7(A,IA,Y,X,N,NB)
      END IF
C
      END
C***********************************************************************
      SUBROUTINE LUTFBK4(A,IRS,ICN,IDP,Y,X,N)
C=======================================================================
C     Program for sparse incomplete LU-transpose solution phase 
C     (LU)^T y = x 
C     Compressed row storage format
C=======================================================================
      IMPLICIT NONE
      INTEGER IRS(1),ICN(1),IDP(1),N,I,L
      REAL*8  A(1),X(1),Y(1),TMP
C
C --- U^T y = x 
C
      DO I=1,N
         Y(I)=X(I)
      END DO
C
      DO I=1,N
         Y(I)=A(IDP(I))*Y(I)
         DO L=IDP(I)+1,IRS(I+1)-1
            Y(ICN(L))=Y(ICN(L))-A(L)*Y(I)
         END DO
      END DO 
C
C --- L^T y = y  
C
      DO I=N,1,-1
         DO L=IRS(I),IDP(I)-1
            Y(ICN(L))=Y(ICN(L))-A(L)*Y(I)
         END DO
      END DO
C
      END
C***********************************************************************
