C***********************************************************************
      SUBROUTINE PRECON(A,IA)
C=======================================================================
C     Driver program for the preconditioner
C=======================================================================
      IMPLICIT NONE
      INTEGER IA(*)
      REAL*8  A(*)
      INTEGER IPREC,NGK,IOUT,K1,IGETPA,IODEV,I
C
      IPREC=IGETPA('NSPAR','IPREC',0)
      NGK  =IGETPA('NSPAR','NGK  ',0)
      IOUT =IODEV('OUTPU')
      K1   =NGK+1
C
C --- symmetric preconditioners first
C
      IF(IPREC.EQ.1) THEN
         CALL PIC(A,A(K1),IA)
         CALL PUTIPA('NSPAR','NPR',NGK,0)
C
C ---    nonsymmetric precontitioners
C
      ELSE IF(IPREC.EQ.100) THEN
         CALL PILU(A,A(K1),IA)
         CALL PUTIPA('NSPAR','NPR',NGK,0)
      ELSE IF(IPREC.NE.0) THEN
         WRITE(IOUT,'('' Nonexistent preconditioner => STOP '')')
         WRITE(*,'('' Nonexistent preconditioner => STOP '')')
         STOP
      END IF
C
      END
C***********************************************************************
      SUBROUTINE PIC(A,PC,IA)
C=======================================================================
C     Driver routine for the IC(0) preconditioners
C=======================================================================
      IMPLICIT NONE
      INTEGER IA(*)
      REAL*8  A(*),PC(*)
C --- local variables 
      INTEGER N,NA,NB,N2,N3,I,IOUT,IERR,IT,MIT,IODEV,IGETPA,ISTMO
      REAL*8  SHIFT,DUM,DMAX,DMIN,R1,STOL,FGETPA
      PARAMETER (MIT=4,STOL=3.D0)
C
      N     = IGETPA('NSPAR','NEQ',0)
      NA    = IGETPA('NSPAR','NGK',0)
      ISTMO = IGETPA('NSPAR','ISTMO',0)
      N2    = N + 2
      N3    = N2 + NA
      NB    = NA / N
      IOUT  = IODEV('OUTPU')
      SHIFT = FGETPA('FPARA','SHIFT',0)
C
      DO IT=1,MIT
         IERR=0
         CALL DCOPY(NA,A,1,PC,1)
         IF(ISTMO.EQ.4) THEN
            CALL PIC4(A,PC,IA,IA(N2),IA(N3),N,SHIFT,DMIN,DMAX,IERR)
         ELSE IF(ISTMO.EQ.7) THEN
            CALL PIC7(A,PC,IA,N,NB,SHIFT,DMIN,DMAX,IERR)
         END IF
C
C         WRITE(IOUT,5000) SHIFT,DMAX,DMIN,DABS(DMIN)/DMAX
         WRITE(IOUT,5050) SHIFT
         WRITE(*,5050) SHIFT
C
         IF(IERR.LE.0) THEN
            RETURN
         ELSE
            IF(IT.EQ.MIT) THEN
               WRITE(IOUT,5100) IERR,DMIN
               WRITE(*,5100) IERR,DMIN
               STOP
            ELSE
               IF(IT.EQ.1) THEN
                  R1=DABS(DMIN/DMAX)
               END IF
               SHIFT = SHIFT + STOL*R1
C               IF(SHIFT.LT.STOL*R1) THEN
C                  SHIFT=STOL*R1
C               ELSE
C                  WRITE(IOUT,5100) IERR,DMIN
C                  STOP
C               END IF
            END IF
         END IF
      END DO
C
C 5000 FORMAT('## IC -- Sft Max/Min-Diag R',3(1P,E12.4),0P,F10.5)
 5050 FORMAT(' IC preconditioner computed SHIFT = ',1P,E12.3) 
 5100 FORMAT(' *** ERROR *** NEGATIVE PIVOT IN IC FACTORIZATION ',/,
     &       ' *** ERROR *** EQUATION ',I8,'  VALUE ',1PE13.5)
      END
C***********************************************************************
      SUBROUTINE PIC4(A,AF,IRS,ICN,IW,N,SHIFT,DMIN,DMAX,IERR)
C=======================================================================
C     Program for IC(0) decomposition CRS-format
C=======================================================================
      IMPLICIT NONE
      INTEGER IRS(*),ICN(*),IW(*),N,IERR
      REAL*8  A(*),AF(*),SHIFT,DMIN,DMAX
C --- locals ---
      INTEGER I,J,M,J1,II,JJ,IK,JK
      REAL*8  TMP1,TMP2,TMP3
C
      CALL IZERO(IW,N)
C
      DMIN=0.D0
      DMAX=A(1)
C
      DO I=1,N
         TMP2=0.D0
         DO M=IRS(I),IRS(I+1)-1
            IW(ICN(M))=M
         END DO
         DO J1=IRS(I),IRS(I+1)-2
            J =ICN(J1)
            TMP1=0.D0
            DO JK=IRS(J),IRS(J+1)-2
               IK=IW(ICN(JK))
               IF(IK.GT.0) THEN
                  TMP1=TMP1+AF(IK)*AF(JK)
               END IF
            END DO
            JJ=IRS(J+1)-1
            AF(J1)=(AF(J1)-TMP1)/AF(JJ)
            TMP2=TMP2+AF(J1)*AF(J1)
         END DO
         II=IRS(I+1)-1
         IF(A(II).GT.DMAX) DMAX=A(II)
         IF(A(II).LT.DMIN) DMIN=A(II)
         TMP3=AF(II)*(1.D0+SHIFT)-TMP2
         IF(TMP3.LT.0.D0) THEN
            IERR=I
            DMIN=TMP3
            RETURN
         ELSE
            AF(II)=DSQRT(TMP3)
         END IF
         DO M=IRS(I),IRS(I+1)-1
            IW(ICN(M))=0
         END DO
      END DO
C
      END
C***********************************************************************
      INTEGER FUNCTION IAPOS(IRS,ICN,I,J)
C=======================================================================
C     Function to get the location of element I,J of A in sparse format
C=======================================================================      
      DIMENSION IRS(1),ICN(1)
C
      IAPOS=0
      IB=IRS(I)
      IE=IRS(I+1)-1
      DO K=IB,IE
         IF(ICN(K).EQ.J) THEN
            IAPOS=K
            RETURN
         END IF
      END DO
C
      END
C***********************************************************************
      SUBROUTINE PIC7(A,AF,IDP,N,NB,SHIFT,DMIN,DMAX,IERR)
C=======================================================================
C     Program for incomplete Cholesky decomposition CDS-format
C=======================================================================
      IMPLICIT NONE
      INTEGER IDP(1),N,NB,IERR
      INTEGER I,J,M,I1,J1,K1,K,L,IK,JK,IL,NA,ICPOS
      REAL*8  A(N,NB),AF(N,NB),SHIFT,DMIN,DMAX,TMP1,TMP2,TMP3
C
      NA=N*NB
C
      DMIN=A(1,NB)
      DMAX=0.D0
C
      DO I=1,N
         TMP2=0.D0
         DO L=1,NB-1
            J=I+IDP(L)
            IF(J.GT.0) THEN
               TMP1=0.D0
               DO M=1,L-1
                  K=I+IDP(M)
                  IF(K.GT.0) THEN
                     I1=I
                     J1=J
                     K1=K
                     IK=ICPOS(IDP,NB,I1,K1)
                     JK=ICPOS(IDP,NB,J1,K1)
                     IF((IK.GT.0).AND.(JK.GT.0)) THEN
                        TMP1=TMP1+AF(I,IK)*AF(J,JK)
                     END IF
                  END IF
               END DO
               AF(I,L)=(AF(I,L)-TMP1)/AF(J,NB)
               TMP2=TMP2+AF(I,L)*AF(I,L)
            END IF
         END DO
         DMIN =MIN(DMIN,A(I,NB))
         DMAX =MAX(DMAX,A(I,NB))
         TMP3=AF(I,NB)+SHIFT*A(I,NB)-TMP2
         IF(TMP3.LT.0.D0) THEN
            IERR=I
            DMIN=TMP3
            RETURN
         ELSE
            AF(I,NB)=DSQRT(TMP3)
         END IF
      END DO
C
      END
C***********************************************************************
      INTEGER FUNCTION ICPOS(IDP,NB,I,J)
C=======================================================================
C     Function to get the location of element I,J of A in sparse format
C=======================================================================      
      IMPLICIT NONE
      INTEGER IDP(*),NB,I,J,K,JJ
C
      ICPOS=0
      DO K=1,NB
         JJ=I+IDP(K)
         IF(JJ.EQ.J) THEN
            ICPOS=K
            RETURN
         END IF
      END DO
C
      END
C***********************************************************************
C
C///////////////////////////////////////////////////////////////////////
C     NON-SYMMETRIC PRECONDITIONERS
C\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
C
C***********************************************************************
      SUBROUTINE PILU(A,PC,IA)
C=======================================================================
C     Driver routine for the ILU preconditioners
C=======================================================================
      IMPLICIT NONE
      INTEGER IA(*)
      REAL*8  A(*),PC(*)
      INTEGER N,NA,N2,N3,N4,NB,I,IOUT,IERR,IT,IGETPA,IODEV,MIT,ISTMO
      REAL*8  SHIFT,DUM,DMAX,DMIN,R1,STOL,FGETPA
      PARAMETER (MIT=4,STOL=1.5D0)
C
      N=IGETPA('NSPAR','NEQ',0)
      NA=IGETPA('NSPAR','NGK',0)
      ISTMO=IGETPA('NSPAR','ISTMO',0)
      N2=N+2
      N3=N2+NA
      N4=N3+N
      NB=NA/N
      IOUT=IODEV('OUTPU')
      SHIFT=FGETPA('FPARA','SHIFT',0)
C
      DO IT=1,MIT
         IERR=0
         IF(ISTMO.EQ.4) THEN
            CALL PILU4(A,PC,IA,IA(N2),IA(N3),IA(N4)
     &           ,N,SHIFT,DMIN,DMAX,IERR)
         END IF
C
C         WRITE(IOUT,5000) DMAX,DMIN,SHIFT,DABS(DMIN)/DMAX
         WRITE(IOUT,5050) SHIFT
C
         IF(IERR.LE.0) THEN
            RETURN
         ELSE
            IF(IT.EQ.MIT) THEN
               WRITE(IOUT,5100) IERR,DMIN
               WRITE(*,5100) IERR,DMIN
               STOP
            ELSE
               R1=DABS(DMIN/DMAX)
               IF(SHIFT.LT.STOL*R1) THEN
                  SHIFT=STOL*R1
               ELSE
                  WRITE(IOUT,5100) IERR,DMIN
                  WRITE(*,5100) IERR,DMIN
                  STOP
               END IF
            END IF
         END IF
      END DO
C
C 5000 FORMAT('## -- Max/Min-Diag Shift R',3(1P,E12.4),0P,F10.5)
 5050 FORMAT(' ILU preconditioner computed SHIFT = ',1P,E12.3) 
 5100 FORMAT(' *** ERROR *** ZERO PIVOT IN ILU FACTORIZATION ',/,
     &       ' *** ERROR *** EQUATION ',I8,'  VALUE ',1PE13.5)
      END
C***********************************************************************
      SUBROUTINE PILU4(A,AF,IRS,ICN,IDP,IW,N,SHIFT,DMIN,DMAX,IERR)
C=======================================================================
C     Program to the form the ILU(0) preconditioner
C=======================================================================
      IMPLICIT NONE
      INTEGER IRS(*),ICN(*),IDP(*),IW(*),N,NA,IERR
      INTEGER I,J,J1,J2,JJ,JROW,JW,K
      REAL*8  A(*),AF(*),SHIFT,DMIN,DMAX,TMP,ZERO
      DATA ZERO /0.D0/
C
      NA=IRS(N+1)-1
      CALL DCOPY(NA,A,1,AF,1)
      CALL IZERO(IW,N)
C
      DMIN=A(1)
      DMAX=0.D0
C
      DO K=1,N
         J1=IRS(K)
         J2=IRS(K+1)-1
         DO J=J1,J2
            IW(ICN(J))=J
         END DO
         DO J=J1,IDP(K)-1
            JROW=ICN(J)
            TMP=AF(J)*AF(IDP(JROW))
            AF(J)=TMP
            DO JJ=IDP(JROW)+1,IRS(JROW+1)-1
               JW=IW(ICN(JJ))
               IF(JW.NE.0) THEN
                  AF(JW)=AF(JW)-TMP*AF(JJ)
               END IF
            END DO
         END DO
         J=IDP(K)
         DMIN =MIN(DMIN,A(J))
         DMAX =MAX(DMAX,A(J))
         IF(AF(J).NE.ZERO) THEN
            AF(J)=1.D0/AF(J)
         ELSE
            IERR=K
            DMIN=0.D0
         END IF
         DO I=J1,J2
            IW(ICN(I))=0
         END DO
      END DO
C
      END
C***********************************************************************
