C***********************************************************************
      SUBROUTINE APNT(IRS,ICN,MAXNC)
C=======================================================================
C     Program to form the stiffness matrix pointer array
C     for Compressed Sparse Row storage format (CSR) 
C     also known as CRS (Compressed Row Storage)
C=======================================================================
      PARAMETER (MT=60)
      DIMENSION IRS(1),ICN(1),LM(MT),IEN(MT)
C
      IOUT  = IODEV('OUTPU')
      ID    = IODEV('IDARR')
      IENA  = IODEV('IENAR')
      NEQ   = IGETPA('NSPAR','NEQ  ',0)
      NELG  = IGETPA('NSPAR','NELG ',0)
	NELE  = IGETPA('NSPAR','NELE ',0)
	NELPR = IGETPA('NSPAR','NELPR',0)
      ISYM  = IGETPA('NSPAR','ISYM ',0) 
      MIA   = IGETPA('MPARA','MIA  ',0)
	IF(NELPR.LE.0) NELPR = 1000
      IF(NEQ+1.GT.MIA) THEN
         WRITE(IOUT,5000) NEQ+1,MIA
         STOP
      END IF
C
      MEDOF=1
      DO 100 NG=1,NELG
         NENOD=IGETPA('NEPAR','NENOD',NG)
         NDOF =IGETPA('NEPAR','NDOF ',NG)
         NEDOF=NENOD*NDOF
         MEDOF=MAX(NEDOF,MEDOF)
 100  CONTINUE
      NBAND=(MEDOF-1)*MAXNC
      DO 200 I=1,NEQ+1
         IRS(I)=(I-1)*NBAND+1
 200  CONTINUE
      NGK=IRS(NEQ+1)-1
      NITOT=NEQ+1+NGK
      IF(NITOT.GT.MIA) THEN
         WRITE(IOUT,5000) NITOT,MIA
         STOP
      END IF
	CALL IZERO(ICN,NGK)
      NE=0
	WRITE(*,'('' Start forming pointer arrays '')')
      DO 400 NG=1,NELG
         NEL  =IGETPA('NEPAR','NEL  ',NG)
         NENOD=IGETPA('NEPAR','NENOD',NG)
         NDOF =IGETPA('NEPAR','NDOF ',NG)
         NEDOF=NENOD*NDOF
         DO 300 N=1,NEL
            NE=NE+1
            READ(IENA,REC=NE) MAT,LSE,(IEN(J),J=1,NENOD)
            CALL FORMLM(LM,IEN,ID,NENOD,NDOF)
            CALL APNTE(IRS,ICN,LM,NEDOF,NEQ,ISYM)
	      IF((MOD(NE,NELPR).EQ.0).AND.(NE.GE.NELPR)) THEN
			WRITE(*,5100) NE,REAL(NE)/REAL(NELE)*100.
	      END IF
 300     CONTINUE
 400  CONTINUE
C
C --- compress and sort the ICN array and update IRS ---    
C
      CALL COMP_ADJ(NEQ,IRS,ICN,NBAND)
	WRITE(*,'('' Pointer arrays completed'')')
C
      NGK=IRS(NEQ+1)-1
      CALL PUTIPA('NSPAR','NGK  ',NGK,0)
      CALL PUTIPA('NSPAR','NBAND',NBAND,0)
C
      RETURN
 5000 FORMAT(' *** ERROR *** MAXIMUM DIMENSIONS EXCEEDED ',/,
     &       '               SPACE NEEDEED FOR  ',I10,'  INTEGERS ',/,
     &       '               DIMENSION OF ARRAY ',I10)
 5100 FORMAT(' Element ',I8,3X,F5.1,' %')
      END
C***********************************************************************
      SUBROUTINE COMP_ADJ(NEQ,IRS,ICN,NBAND)
C=======================================================================
C     Program to compress and sort the adjacency list
C=======================================================================
      IMPLICIT NONE
      INTEGER NEQ,IRS(*),ICN(*),NBAND
C --- locals -----------------------------------------------------------
      INTEGER I,L,IB,IE,IEB,IROWS,NZERO,NCNU
C
      NZERO=0
      IROWS=1
      IB=1
      NBAND=0
      DO 500 I=1,NEQ
         IE=IRS(I+1)
         IEB=IE-IB
         NCNU=0
         DO 420 L=IB,IE-1
            IF(ICN(L).GT.0) NCNU=NCNU+1
 420     CONTINUE
         NBAND=MAX(NBAND,NCNU)
         IROWS=IROWS+NCNU
         IRS(I+1)=IROWS
         IF(NCNU.GE.2) THEN
            CALL SSORTI(ICN(IB),NCNU)
         END IF
         IF(NZERO.GT.0) THEN
            DO 440 L=IB,IB+NCNU-1
               ICN(L-NZERO)=ICN(L)
 440        CONTINUE
         END IF
         NZERO=NZERO+IEB-NCNU
         IB=IE
 500  CONTINUE
C
      END
C***********************************************************************
      SUBROUTINE APNTE(IRS,ICN,LM,NEDOF,NEQ,ISYM)
C=======================================================================
C     Program to fill the stiffness matrix pointer array for element
C=======================================================================
      DIMENSION IRS(1),ICN(1),LM(1)
      LOGICAL NFOUND
C
      IOUT =IODEV('OUTPU')
      MIA  =IGETPA('MPARA','MIA  ',0)
C
      DO 280 I=1,NEDOF
         IROW=LM(I)
         IF(IROW.GT.0) THEN
            DO 260 J=1,NEDOF
               ICOL=LM(J)
               IF(ICOL.GT.0) THEN
                  IF((ISYM.NE.1).OR.(ICOL.LE.IROW)) THEN
                     IB=IRS(IROW)
                     IE=IRS(IROW+1)-1
                     NCNU=0
                     NFOUND=.TRUE.
                     DO 100 L=IB,IE
                        IF(ICN(L).GT.0) NCNU=NCNU+1
                        IF(ICN(L).EQ.ICOL) NFOUND=.FALSE.
 100                 CONTINUE
                     IF(NFOUND) THEN
                        NCOL=IB+NCNU
                        ICN(NCOL)=ICOL
                     END IF
                  END IF
               END IF
 260        CONTINUE
         END IF
 280  CONTINUE
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE SSORTI(IA,N)
C=======================================================================
C     Program to sort integer array, Shell-Metzner sorting algorithm
C=======================================================================     
      INTEGER IA(N)
C
      JUMP=N
 10   CONTINUE
      JUMP=JUMP/2
      IF(JUMP.EQ.0) RETURN
      J2=N-JUMP
      DO 30 J=1,J2
         I=J
 20      CONTINUE
         J3=I+JUMP
         IF(IA(I).GT.IA(J3)) THEN
            IHOLD=IA(I)
            IA(I)=IA(J3)
            IA(J3)=IHOLD
            I=I-JUMP
            IF(I.GT.0) GOTO 20
         END IF
 30   CONTINUE
      GOTO 10
C
      END
C***********************************************************************
      SUBROUTINE APNTD(IA)
C=======================================================================
C     Program to set up the pointer array for sparse DIAgonal storage
C     format
C=======================================================================
      IMPLICIT NONE 
      INTEGER    IA(*)
C --- locals -----------------------------------------------------------
      INTEGER    MT,IOUT,IODEV,IGETPA,NEQ,NELG,ISYM,MXDIF,NE,NG,NEDOF,
     &           N,MAT,LSE,I,J,NDOF,NENOD,NHBAND,NGK,II,ID,IENA,NEL
      PARAMETER (MT=60)
      INTEGER    LM(MT),IEN(MT),NBAND
C
      IOUT  = IODEV('OUTPU')
      ID    = IODEV('IDARR')
      IENA  = IODEV('IENAR')
      NEQ   = IGETPA('NSPAR','NEQ',0)
      NELG  = IGETPA('NSPAR','NELG',0)
      ISYM  = IGETPA('NSPAR','ISYM',0)
      MXDIF = 0
      NE    = 0
C
      DO 400 NG=1,NELG
         NEL  =IGETPA('NEPAR','NEL  ',NG)
         NENOD=IGETPA('NEPAR','NENOD',NG)
         NDOF =IGETPA('NEPAR','NDOF ',NG)
         NEDOF=NENOD*NDOF
         DO 300 N=1,NEL
            NE=NE+1
            READ(IENA,REC=NE) MAT,LSE,(IEN(J),J=1,NEDOF)
            CALL FORMLM(LM,IEN,ID,NENOD,NDOF)
            CALL CDSTOR(IA,LM,NEDOF,MXDIF,ISYM,IOUT)            
 300     CONTINUE
 400  CONTINUE
C
      NBAND=0
      DO I=1,MXDIF
         IF(IA(I).GT.0) NBAND = NBAND + 1
      END DO
      NHBAND = NBAND - 1
      II = 1
      DO I = 2, MXDIF
         IF(IA(I).GT.0) THEN
            II=II+1
            IA(II)=IA(I)
         END IF
      END DO
      DO I=1,NBAND
         IA(I)=IA(I)-1
      END DO
C
      NGK   = ((1-ISYM)*NHBAND+NBAND)*NEQ
      NBAND = (1-ISYM)*NHBAND+NBAND
      CALL PUTIPA('NSPAR','NGK  ',NGK  ,0)
      CALL PUTIPA('NSPAR','NBAND',NBAND,0)
C
      IF(ISYM.EQ.0) THEN
         DO I = NHBAND + 1, 1, -1
            IA(I+NHBAND) = IA(I)
         END DO
         DO I=1,NHBAND
            IA(I)=-IA(NBAND-I+1)
         END DO
      ELSE
         DO I=1,NBAND
            IA(I)=-IA(I)
         END DO
         CALL SSORTI(IA,NBAND)
      END IF
C      WRITE(6,'('' IA '',10I6)') (IA(I),I=1,NBAND)
C
      END
C***********************************************************************
      SUBROUTINE CDSTOR(IA,LM,NR,MXDIF,ISYM,IOUT)
C=======================================================================
C     Program to find the diagonal entries for compressed diagonal 
C     storage
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION LM(*),IA(*)
C
      DO J=1,NR
         ICOL=LM(J)
         IF(ICOL.GT.0) THEN
            DO I=1,NR
               IROW=LM(I)
               IF(ICOL.LE.IROW) THEN
                  NDIFF=IROW-ICOL+1
                  IA(NDIFF)=NDIFF
                  IF(NDIFF.GT.MXDIF) MXDIF=NDIFF
               END IF
            END DO
         END IF
      END DO
C
      END
C***********************************************************************
      SUBROUTINE IDPTR(IRS,ICN,IDP,N,IOUT)
C=======================================================================
C     Program to form the diagonal pointer array for CSR- or CSC-mode
C=======================================================================
      IMPLICIT NONE
      INTEGER IRS(*),ICN(*),IDP(*),N,IOUT
C --- locals -----------------------------------------------------------
      INTEGER I,J,K,II
C
      DO 200 I=1,N
         II=0
         DO 160 K=IRS(I),IRS(I+1)-1
            J=ICN(K)
            IF(I.EQ.J) THEN
               II=K
            END IF
 160     CONTINUE
         IF(II.GT.0) THEN
            IDP(I)=II
         ELSE
            WRITE(IOUT,'('' ERROR *** DIAGONAL ENTRY NOT FOUND '')')
         END IF
 200  CONTINUE
C
      END
C***********************************************************************
      SUBROUTINE NODE_GRAPH(NP,IS,IADJ,ISYM)
C=======================================================================
C     Program to form the nodal adjacency graph
C=======================================================================
      IMPLICIT NONE
      INTEGER NP,IS(*),IADJ(*),ISYM
C --- locals -----------------------------------------------------------
      EXTERNAL IGETPA,IODEV
      INTEGER NGR,NELGR,NEL,NPE,N,NDUM,NODEJ,I,J,IOUT,IEN,ITMP(30)
     &       ,NZERO,NCNU,IB,IE,IROWS,L,NN,MIA,NBAND,IGETPA,IODEV
     &       ,MAT,LSE

      MIA = IGETPA('MPARA','MIA',0)
      IF(NP+1.GT.MIA) THEN
         WRITE(IOUT,5000) NP+1,MIA
         STOP
      END IF
C
      IOUT = IODEV('OUTPU')
      WRITE(IOUT,'('' Start processing nodal graph '')')
C
C --- estimate the degree of each node (overestimate) -----
C
      NELGR = IGETPA('NSPAR','NELG',0)
C
      CALL IZERO(IS,NP)
C
      IEN = IODEV('IENAR')
      NN = 0
      DO NGR = 1, NELGR
         NEL = IGETPA('NEPAR','NEL',NGR)
         NPE = IGETPA('NEPAR','NENOD',NGR)
         DO N = 1, NEL
            NN = NN + 1
            READ(IEN,REC=NN) MAT,LSE,(ITMP(J), J = 1, NPE)
            DO J=1,NPE
               NODEJ=ITMP(J)
               IS(NODEJ)=IS(NODEJ)+NPE
            END DO
         END DO
      END DO
C
      NDUM = 1
      DO I = 1, NP
         NDUM = NDUM + IS(I)
         IS(I) = NDUM - IS(I)
      END DO
      IS(NP+1) = NDUM
C
      IF((NDUM+NP+1).GT.MIA) THEN
         WRITE(IOUT,5000) NDUM,MIA
         STOP
      END IF

C      WRITE(IOUT,'('' Size of adjacency list estimate'',I10)') NDUM
C      WRITE(IOUT,'(10I7)') NP
C      WRITE(IOUT,'(10I7)') (IS(I),I=1,NP+1)
C
      CALL IZERO(IADJ,NDUM)
C
      NN = 0
      DO NGR=1,NELGR
         NEL = IGETPA('NEPAR','NEL',NGR)
         NPE = IGETPA('NEPAR','NENOD',NGR)
         DO N = 1, NEL
            NN = NN + 1
            READ(IEN, REC = NN) MAT,LSE,(ITMP(J), J = 1, NPE)
            CALL APNTE(IS,IADJ,ITMP,NPE,NP,ISYM)
         END DO
      END DO
C
C --- compress and sort the IADJ array and update IS ---
C
      CALL COMP_ADJ(NP,IS,IADJ,NBAND)
C      WRITE(IOUT,'('' NBAND '',I6)') NBAND
C
      NDUM=IS(NP+1)-1
      CALL PUTIPA('NSPAR','NGK',NDUM,0)
C      WRITE(IOUT,'('' Size of adjacency list '',I10)') NDUM
C      WRITE(IOUT,'(10I7)') NP
C      WRITE(IOUT,'(10I7)') (IS(I),I=1,NP+1)
C      WRITE(IOUT,'('' IADJ '')')
C      WRITE(IOUT,'(10I7)') (IADJ(I),I=1,NDUM)
C
 5000 FORMAT(' *** ERROR *** MAXIMUM DIMENSIONS EXCEEDED ',/,
     &       '               SPACE NEEDEED FOR  ',I10,'  INTEGERS ',/,
     &       '               DIMENSION OF ARRAY ',I10)
      END
C
C***********************************************************************
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C-***-END-OF-FILE-******************************************************

