C***********************************************************************
      SUBROUTINE INITIO
C=======================================================================
C     Program to initialize internal file units
C-----------------------------------------------------------------------
C     Files required for
C     INPUT input file
C     MESH  output file for mesh data
C     PLOT  output file for results
C     COORD_inates
C     IENAR_ray
C     IDARR_ay
C     NEPAR element parameter array
C     NSPAR system paramerer array
C     MPARA array for maximum values of system parameters
C     CPARA array for constitutive parameters
C     SPARA array for section parameters
C     FPARA array for general real valued parameters
C     CLOAD file for concentrated load data
C     ELOAD file for element distributed loads
C     ELDAT file for element data (director angles, thickness etc ..)
C=======================================================================
      CHARACTER*40 FINPUT,FOUTP
      NBITR=64
      NBITI=32
C ----------------------------------------------------------------------
      WRITE(*,'('' Input file name '')')
      READ(*,'(A)') FINPUT

      II = 0
      IB = 0
      IE = 0
      DO I = 1, 40
         IF(FINPUT(I:I).EQ.'.') II = I
         IF((IB.EQ.0).AND.(FINPUT(I:I).NE.' ')) IB = I
      END DO
      DO I = 40, 1, -1
         IF((IE.EQ.0).AND.(FINPUT(I:I).NE.' ')) IE = I
      END DO

      IFILE=IODEV('INPUT')
      OPEN(UNIT=IFILE,FILE=FINPUT(IB:IE),STATUS='OLD')

      II = II - 1
      IF(II.LT.0) II = IE
      IN = II - IB + 1

      IFILE = IODEV('OUTPU')
      FOUTP(1:IN) = FINPUT(IB:II)
      FOUTP(IN+1:IN+4) = '.out'
      OPEN(UNIT=IFILE,FILE=FOUTP,STATUS='UNKNOWN')
      WRITE(*,'('' Output file :               '',A)') FOUTP

      IFILE = IODEV('MESH ')
      FOUTP(IN+1:IN+4) = '.mes'
      OPEN(UNIT=IFILE,FILE=FOUTP,STATUS='UNKNOWN')
      WRITE(*,'('' Output file for mesh data:  '',A)') FOUTP

      IFILE = IODEV('NEUTR')
      FOUTP(IN+1:IN+4) = '.neu'
      OPEN(UNIT=IFILE,FILE=FOUTP,STATUS='UNKNOWN')
      WRITE(*,'('' Output neutral mesh file:   '',A)') FOUTP

      IFILE = IODEV('PLOT ')
      FOUTP(IN+1:IN+4) = '.res'
      WRITE(*,'('' Output file for results:    '',A)') FOUTP
      OPEN(UNIT=IFILE,FILE=FOUTP,STATUS='UNKNOWN')
C-----------------------------------------------------------------------
      IFILE=IODEV('COORD')
      LREC=3*NBITR
      OPEN(UNIT=IFILE,ACCESS='DIRECT',RECL=LREC,STATUS='SCRATCH')
C
      IFILE=IODEV('IENAR')
      LREC=22*NBITI
      OPEN(UNIT=IFILE,ACCESS='DIRECT',RECL=LREC,STATUS='SCRATCH')
C
      IFILE=IODEV('IDARR')
      LREC=6*NBITI
      OPEN(UNIT=IFILE,ACCESS='DIRECT',RECL=LREC,STATUS='SCRATCH')
C
      IFILE=IODEV('NEPAR')
      OPEN(UNIT=IFILE,ACCESS='DIRECT',RECL=NBITI,STATUS='SCRATCH')
C
      IFILE=IODEV('NSPAR')
      OPEN(UNIT=IFILE,ACCESS='DIRECT',RECL=NBITI,STATUS='SCRATCH')
C
      IFILE=IODEV('MPARA')
      OPEN(UNIT=IFILE,ACCESS='DIRECT',RECL=NBITI,STATUS='SCRATCH')
C
      IFILE=IODEV('CPARA')
      OPEN(UNIT=IFILE,ACCESS='DIRECT',RECL=NBITR,STATUS='SCRATCH')
C
      IFILE=IODEV('SPARA')
      OPEN(UNIT=IFILE,ACCESS='DIRECT',RECL=NBITR,STATUS='SCRATCH')
C
      IFILE=IODEV('FPARA')
      OPEN(UNIT=IFILE,ACCESS='DIRECT',RECL=NBITR,STATUS='SCRATCH')
C
      IFILE=IODEV('CLOAD')
      LREC=3*NBITI+NBITR
      OPEN(UNIT=IFILE,ACCESS='DIRECT',RECL=LREC,STATUS='SCRATCH')
C
      IFILE=IODEV('ELOAD')
      LREC=60*NBITR
      OPEN(UNIT=IFILE,ACCESS='DIRECT',RECL=LREC,STATUS='SCRATCH')
C
      IFILE=IODEV('ELDAT')
      LREC=20*NBITR
      OPEN(UNIT=IFILE,ACCESS='DIRECT',RECL=LREC,STATUS='SCRATCH')
C ----------------------------------------------------------------------
      END
C***********************************************************************
      FUNCTION IODEV(FILE)
C=======================================================================
C     Function to get unit numbers
C=======================================================================
      CHARACTER*5 FILE
C
      IF(INDEX(FILE,'INPUT').NE.0) THEN
         IODEV=4
      ELSE IF(INDEX(FILE,'OUTPU').NE.0) THEN
         IODEV=9
      ELSE IF(INDEX(FILE,'MESH').NE.0) THEN
         IODEV=7
      ELSE IF(INDEX(FILE,'NEUTR').NE.0) THEN
         IODEV=8
      ELSE IF(INDEX(FILE,'PLOT').NE.0) THEN
         IODEV=11
      ELSE IF(INDEX(FILE,'COORD').NE.0) THEN
         IODEV=21
      ELSE IF(INDEX(FILE,'IENAR').NE.0) THEN
         IODEV=22
      ELSE IF(INDEX(FILE,'IDARR').NE.0) THEN
         IODEV=23
      ELSE IF(INDEX(FILE,'NEPAR').NE.0) THEN
         IODEV=24
      ELSE IF(INDEX(FILE,'NSPAR').NE.0) THEN
         IODEV=25
      ELSE IF(INDEX(FILE,'MPARA').NE.0) THEN
         IODEV=26
      ELSE IF(INDEX(FILE,'CPARA').NE.0) THEN
         IODEV=27
      ELSE IF(INDEX(FILE,'SPARA').NE.0) THEN
         IODEV=28
      ELSE IF(INDEX(FILE,'FPARA').NE.0) THEN
         IODEV=29
      ELSE IF(INDEX(FILE,'CLOAD').NE.0) THEN
         IODEV=30
      ELSE IF(INDEX(FILE,'ELOAD').NE.0) THEN
         IODEV=31
      ELSE IF(INDEX(FILE,'ELDAT').NE.0) THEN
         IODEV=32
      ELSE 
         WRITE(6,5000) FILE
         STOP
      END IF
C
 5000 FORMAT(' *** ERROR *** UNKNOWN FILE IDENTIFIER ',A)
      END
C***********************************************************************
      INTEGER FUNCTION IGETPA(TABLE,PARAM,N)
C=======================================================================
C     Program to get an integer parameter from the parameter data files
C=======================================================================
      CHARACTER*5 TABLE,PARAM
C
      CALL PADDR(TABLE,PARAM,IFILE,IPOSI,N)
      READ(IFILE,REC=IPOSI,ERR=100) IGETPA
      RETURN
 100  CONTINUE
      IGETPA=0
C
      END
C***********************************************************************
      SUBROUTINE PUTIPA(TABLE,PARAM,IVAL,N)
C=======================================================================
C     Program to put an integer parameter to the parameter data files
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      CHARACTER*5 TABLE,PARAM
C
      CALL PADDR(TABLE,PARAM,IFILE,IPOSI,N)
      WRITE(IFILE,REC=IPOSI) IVAL
C
      RETURN
      END
C***********************************************************************
      FUNCTION FGETPA(TABLE,PARAM,N)
C=======================================================================
C     Program to get a parameter from the parameter data files
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      CHARACTER*5 TABLE,PARAM
C
      CALL PADDR(TABLE,PARAM,IFILE,IPOSI,N)
      READ(IFILE,REC=IPOSI,ERR=100) FGETPA
      RETURN
 100  CONTINUE
      FGETPA=0.D0
C
      END
C***********************************************************************
      SUBROUTINE PUTFPA(TABLE,PARAM,VALUE,N)
C=======================================================================
C     Program to put a parameter to the parameter data files
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      CHARACTER*5 TABLE,PARAM
C
      CALL PADDR(TABLE,PARAM,IFILE,IPOSI,N)
      WRITE(IFILE,REC=IPOSI) VALUE
C
      END
C***********************************************************************
      SUBROUTINE PADDR(TABLE,PARAM,IFILE,IPOSI,N)
C=======================================================================
C     Program to find the position and file unit of a certain parameter
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      CHARACTER*5 TABLE,PARAM
C
      IF(INDEX(TABLE,'NEPAR').NE.0) THEN
         IFILE = IODEV('NEPAR')
         IPOSI = NEPAR(PARAM,N)
      ELSE IF(INDEX(TABLE,'NSPAR').NE.0) THEN
         IFILE = IODEV('NSPAR')
         IPOSI = NSPAR(PARAM)
      ELSE IF(INDEX(TABLE,'MPARA').NE.0) THEN
         IFILE = IODEV('MPARA')
         IPOSI = MPARA(PARAM)
      ELSE IF(INDEX(TABLE,'CPARA').NE.0) THEN
         IFILE = IODEV('CPARA')
         IPOSI = IMATP(PARAM,N)
      ELSE IF(INDEX(TABLE,'SPARA').NE.0) THEN
         IFILE = IODEV('SPARA')
         IPOSI = ISECP(PARAM,N)
      ELSE IF(INDEX(TABLE,'FPARA').NE.0) THEN
         IFILE = IODEV('FPARA')
         IPOSI = IFPAR(PARAM)
      ELSE
         IOUT = IODEV('OUTPU')
         WRITE(IOUT,5000) TABLE
         STOP
      END IF
C
 5000 FORMAT(' ** Error in PADDR ** Unknown parameter array ',A)
      END
C***********************************************************************
      INTEGER FUNCTION NEPAR(PARAM,N)
C=======================================================================
C     Function to get an element parameter (NEPAR) address
C=======================================================================
      PARAMETER (M=50)
      CHARACTER*5 PARAM
C
      IN=(N-1)*M
      IF(INDEX(PARAM,'NEL').NE.0) THEN
         NEPAR=IN+1
      ELSE IF(INDEX(PARAM,'NETYP').NE.0) THEN
         NEPAR=IN+2
      ELSE IF(INDEX(PARAM,'NENOD').NE.0) THEN
         NEPAR=IN+3
      ELSE IF(INDEX(PARAM,'NDOF').NE.0) THEN
         NEPAR=IN+4
      ELSE IF(INDEX(PARAM,'IEQEL').NE.0) THEN
         NEPAR=IN+5
      ELSE IF(INDEX(PARAM,'NIX').NE.0) THEN
         NEPAR=IN+6
      ELSE IF(INDEX(PARAM,'NIY').NE.0) THEN
         NEPAR=IN+7
      ELSE IF(INDEX(PARAM,'NIZ').NE.0) THEN
         NEPAR=IN+8
      ELSE IF(INDEX(PARAM,'IETYP').NE.0) THEN
         NEPAR=IN+9
      ELSE
         IOUT = IODEV('OUTPU')
         WRITE(IOUT,5000) PARAM
         STOP
      END IF
C
 5000 FORMAT(' ** Error in NEPAR ** Unknown parameter ',A)
      END
C***********************************************************************
      INTEGER FUNCTION NSPAR(PARAM)
C=======================================================================
C     Function to get a global parameter (NSPAR) address
C=======================================================================
      CHARACTER*5 PARAM
C
      IF(INDEX(PARAM,'NDIM').NE.0) THEN
         NSPAR=1
      ELSE IF(INDEX(PARAM,'NNOD').NE.0) THEN
         NSPAR=2
      ELSE IF(INDEX(PARAM,'NELG').NE.0) THEN
         NSPAR=3
      ELSE IF(INDEX(PARAM,'NDOF').NE.0) THEN
         NSPAR=4
      ELSE IF(INDEX(PARAM,'NELE').NE.0) THEN
         NSPAR=5
      ELSE IF(INDEX(PARAM,'NEQ').NE.0) THEN
         NSPAR=6
      ELSE IF(INDEX(PARAM,'NBAND').NE.0) THEN
         NSPAR=7
      ELSE IF(INDEX(PARAM,'NCFOR').NE.0) THEN
         NSPAR=8
      ELSE IF(INDEX(PARAM,'NTIT').NE.0) THEN
         NSPAR=9
      ELSE IF(INDEX(PARAM,'IMETH').NE.0) THEN
         NSPAR=10
      ELSE IF(INDEX(PARAM,'NGK').NE.0) THEN
         NSPAR=11
      ELSE IF(INDEX(PARAM,'ISYM').NE.0) THEN
         NSPAR=12
      ELSE IF(INDEX(PARAM,'IPREC').NE.0) THEN
         NSPAR=13
      ELSE IF(INDEX(PARAM,'ISTMO').NE.0) THEN
         NSPAR=14
      ELSE IF(INDEX(PARAM,'NPR').NE.0) THEN
         NSPAR=15
	ELSE IF(INDEX(PARAM,'REORD').NE.0) THEN
	   NSPAR=16
	ELSE IF(INDEX(PARAM,'NELPR').NE.0) THEN
	   NSPAR=17
      ELSE
         IOUT = IODEV('OUTPU')
         WRITE(IOUT,5000) PARAM
         STOP
      END IF
C
 5000 FORMAT(' ** Error in NSPAR ** Unknown parameter ',A)
      END
C***********************************************************************
      INTEGER FUNCTION MPARA(PARAM)
C=======================================================================
C     Function to get a maximum parameter (MPARA) address
C=======================================================================
      CHARACTER*5 PARAM
C
      IF(INDEX(PARAM,'MA').NE.0) THEN
         MPARA=1
      ELSE IF(INDEX(PARAM,'MIA').NE.0) THEN
         MPARA=2
      ELSE IF(INDEX(PARAM,'MTIT').NE.0) THEN
         MPARA=3
      ELSE IF(INDEX(PARAM,'MITER').NE.0) THEN
         MPARA=4
      ELSE IF(INDEX(PARAM,'MU   ').NE.0) THEN
         MPARA=5
      ELSE
         IOUT = IODEV('OUTPU')
         WRITE(IOUT,5000) PARAM
         STOP
      END IF
C
 5000 FORMAT(' ** Error in MPARA ** Unknown parameter ',A)
      END
C***********************************************************************
      INTEGER FUNCTION IMATP(LABEL,ISET)
C=======================================================================
C     Function to get the material parameter address
C=======================================================================
      PARAMETER (MP=30)
      CHARACTER*5 LABEL
C
      IF(INDEX(LABEL,'EX').NE.0) THEN
         IMATP=(ISET-1)*MP+1
      ELSE IF(INDEX(LABEL,'EY').NE.0) THEN
         IMATP=(ISET-1)*MP+2
      ELSE IF(INDEX(LABEL,'EZ').NE.0) THEN
         IMATP=(ISET-1)*MP+3
      ELSE IF(INDEX(LABEL,'GX').NE.0) THEN
         IMATP=(ISET-1)*MP+4
      ELSE IF(INDEX(LABEL,'GY').NE.0) THEN
         IMATP=(ISET-1)*MP+5
      ELSE IF(INDEX(LABEL,'GZ').NE.0) THEN
         IMATP=(ISET-1)*MP+6
      ELSE IF(INDEX(LABEL,'PRX').NE.0) THEN
         IMATP=(ISET-1)*MP+7
      ELSE IF(INDEX(LABEL,'PRY').NE.0) THEN
         IMATP=(ISET-1)*MP+8
      ELSE IF(INDEX(LABEL,'PRZ').NE.0) THEN
         IMATP=(ISET-1)*MP+9
      ELSE IF(INDEX(LABEL,'CONDX').NE.0) THEN
         IMATP=(ISET-1)*MP+11
      ELSE IF(INDEX(LABEL,'CONDY').NE.0) THEN
         IMATP=(ISET-1)*MP+12
      ELSE IF(INDEX(LABEL,'CONDZ').NE.0) THEN
         IMATP=(ISET-1)*MP+13
      ELSE IF(INDEX(LABEL,'VELOX').NE.0) THEN
         IMATP=(ISET-1)*MP+14
      ELSE IF(INDEX(LABEL,'VELOY').NE.0) THEN
         IMATP=(ISET-1)*MP+15
      ELSE IF(INDEX(LABEL,'VELOZ').NE.0) THEN
         IMATP=(ISET-1)*MP+16
      ELSE IF(INDEX(LABEL,'REACC').NE.0) THEN
         IMATP=(ISET-1)*MP+17
      ELSE
         IOUT = IODEV('OUTPU')
         WRITE(IOUT,5000) LABEL
         STOP
      END IF
C
 5000 FORMAT(' ** Error in IMATP ** Unknown parameter ',A)
      END
C***********************************************************************
      INTEGER FUNCTION ISECP(LABEL,ISET)
C=======================================================================
C     Function to get the section parameter address
C=======================================================================
      PARAMETER (MP=30)
      CHARACTER*5 LABEL
C
      IF(INDEX(LABEL,'AA').NE.0) THEN
         ISECP=(ISET-1)*MP+1
      ELSE IF(INDEX(LABEL,'IZ').NE.0) THEN
         ISECP=(ISET-1)*MP+2
      ELSE IF(INDEX(LABEL,'THICK').NE.0) THEN
         ISECP=(ISET-1)*MP+3
      ELSE IF(INDEX(LABEL,'WIDTH').NE.0) THEN
         ISECP=(ISET-1)*MP+4
      ELSE
         IOUT = IODEV('OUTPU')
         WRITE(IOUT,5000) LABEL
         STOP
      END IF
C
 5000 FORMAT(' ** Error in ISECP ** Unknown parameter ',A)
      END
C***********************************************************************
      INTEGER FUNCTION IFPAR(LABEL)
C=======================================================================
C     Function to get the floating point parameter address
C=======================================================================
      CHARACTER*5 LABEL
C
      IF(INDEX(LABEL,'BEGIN').NE.0) THEN
         IFPAR=1
      ELSE IF(INDEX(LABEL,'START').NE.0) THEN
         IFPAR=2
      ELSE IF(INDEX(LABEL,'OVERH').NE.0) THEN
         IFPAR=3
      ELSE IF(INDEX(LABEL,'TIINP').NE.0) THEN
         IFPAR=4
      ELSE IF(INDEX(LABEL,'TIDPR').NE.0) THEN
         IFPAR=5
      ELSE IF(INDEX(LABEL,'TIELE').NE.0) THEN
         IFPAR=6
      ELSE IF(INDEX(LABEL,'TISOL').NE.0) THEN
         IFPAR=7
      ELSE IF(INDEX(LABEL,'TISTR').NE.0) THEN
         IFPAR=8
      ELSE IF(INDEX(LABEL,'TOTAL').NE.0) THEN
         IFPAR=9
      ELSE IF(INDEX(LABEL,'PENA').NE.0) THEN
         IFPAR=11
      ELSE IF(INDEX(LABEL,'OMEGA').NE.0) THEN
         IFPAR=12
      ELSE IF(INDEX(LABEL,'STABC').NE.0) THEN
         IFPAR=13
      ELSE IF(INDEX(LABEL,'ATOL').NE.0) THEN
         IFPAR=20
      ELSE IF(INDEX(LABEL,'RTOL').NE.0) THEN
         IFPAR=21
      ELSE IF(INDEX(LABEL,'RINI').NE.0) THEN
         IFPAR=22
      ELSE IF(INDEX(LABEL,'SHIFT').NE.0) THEN
         IFPAR=23
      ELSE
         IOUT = IODEV('OUTPU')
         WRITE(IOUT,5000) LABEL
         STOP
      END IF
C
 5000 FORMAT(' ** Error in IFPAR ** Unknown parameter ',A)
      END
C***********************************************************************
