C***********************************************************************
      SUBROUTINE WRNEUT(TITLE)
C=======================================================================
C     Program to write element and coordinate data to a neutral file 
C======================================================================= 
      IMPLICIT NONE
      CHARACTER*78 TITLE(*)
C --- local variables --------------------------------------------------
      INTEGER      MENOD 
      PARAMETER   (MENOD = 30)
      INTEGER      N,NDIM,NNOD,NELG,NEL,NELE,NEQ,NBAND,NGK,NTIT,NENOD,
     &             IOUT,I,IEN,IODEV,IGETPA,IPLOT,ICOOR,J,MESH,MAT,LSE,
     &             NE,ITMP(MENOD),NETYP,NGR,INEUT,IBEAM
      DOUBLE PRECISION TEMP(3)

      NDIM  = IGETPA('NSPAR','NDIM ',0)
      NNOD  = IGETPA('NSPAR','NNOD ',0)
      NELG  = IGETPA('NSPAR','NELG ',0)
      NELE  = IGETPA('NSPAR','NELE ',0)
      NEQ   = IGETPA('NSPAR','NEQ  ',0)
      NBAND = IGETPA('NSPAR','NBAND',0)
      NGK   = IGETPA('NSPAR','NGK  ',0)
      NTIT  = IGETPA('NSPAR','NTIT ',0)
C
      IEN   = IODEV('IENAR')
      ICOOR = IODEV('COORD')
      INEUT = IODEV('NEUTR')
C
C --- header ---
C
      CALL WRNTIT(INEUT)
C
C --- data group 21: nodes --- 
C
      CALL WRN21(NDIM,NNOD,ICOOR,INEUT)
C
C --- beam cross section properties ---
C
      IBEAM=0
      DO 140 NGR=1,NELG
         NETYP = IGETPA('NEPAR','NETYP',N)
C         IF(NETYP.NE.0) IBEAM=1
 140  CONTINUE
      IF(IBEAM.EQ.1) THEN
C
      END IF   
C
C --- data group 22: elements --- 
C
      WRITE(INEUT,4020)
      N=0
      DO 200 NGR=1,NELG
         NEL   = IGETPA('NEPAR','NEL  ',NGR)
         NENOD = IGETPA('NEPAR','NENOD',NGR)
         NETYP = IGETPA('NEPAR','NETYP',NGR)
         DO 160 I=1,NEL
            N=N+1
            READ(IEN,REC=N) MAT,LSE,(ITMP(J),J=1,NENOD)
            CALL WRNELE(ITMP,NENOD,NETYP,MAT,LSE,INEUT,NDIM,N)
 160     CONTINUE
 200  CONTINUE
      WRITE(INEUT,4040) NELE
      WRITE(INEUT,4999)
C
C --- data group 401: SPDISP data ---
C
C      CALL WRN401(ID,NDOF,NP,NCN,INEUT)
C
C --- data group 402:  CFORCE data ---
C
C      CALL WRN402(ISCR,INEUT,NCN,NDOF)
C
      WRITE(INEUT,5000)
      CLOSE(INEUT)
C
      RETURN
 4020 FORMAT('** NEUTRAL FILE <ELEMENT DATA> INFORMATION **')
 4040 FORMAT('** NEUTRAL FILE <ELEMENT DATA> # OF ELEMENTS ',I8,' **')
 4999 FORMAT('**')
 5000 FORMAT('** NEUTRAL FILE <END OF DATA> **')
      END 
C***********************************************************************
      SUBROUTINE WRN21(NDIM,NP,ICOOR,INEUT)
C=======================================================================
C     Program to write nodal point coordinates to neutral file
C=======================================================================
      IMPLICIT NONE
      INTEGER NDIM,NP,ICOOR,INEUT
      DOUBLE PRECISION TEMP(3)
      INTEGER I,J,I2,I3
C
      I2=0	! definition coordinate system number
      I3=0	! displacement coordinate system number
      WRITE(INEUT,4000)
      DO 120 I=1,NP
         CALL FZERO(TEMP,3)
         READ(ICOOR,REC=I) (TEMP(J),J=1,NDIM)
 100     CONTINUE
         WRITE(INEUT,5100) 21,2
         WRITE(INEUT,5100) I,I2,I3
         WRITE(INEUT,5200) (TEMP(J),J=1,3)
 120  CONTINUE
C
      WRITE(INEUT,4100) NP
      WRITE(INEUT,4200)
C
      RETURN
 4000 FORMAT('** NEUTRAL FILE <NODE DATA> INFORMATION **')
 4100 FORMAT('** NEUTRAL FILE <END NODE DATA> # OF NODES = ',I8,' **')
 4200 FORMAT('**')
 5100 FORMAT(8I10)
 5200 FORMAT(5(1PE14.7,1X))
      END
C***********************************************************************
      SUBROUTINE WRNELE(IEN,NPE,NELTYP,MATER,LSECT,INEUT,NDIM,N)
C=======================================================================
C     Program to write element data in the neutral file
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (MR=40)
      DIMENSION IEN(*)
C --- local arrays ---
      DIMENSION ITMP(MR)
C
      CALL NISAEP(NELTYP,IEN,NPE,NDIM,ITMP,NNOD,NKTP,NORDR,KISO,IBMFLG)
C
      WRITE(INEUT,5100) 22,3
      WRITE(INEUT,5100) N,NNOD,NKTP,NORDR,MATER,LSECT
      WRITE(INEUT,5100) KISO,IBMFLG
      WRITE(INEUT,5100) (ITMP(J),J=1,NNOD)
C
      RETURN
 5100 FORMAT(8I10)
      END
C***********************************************************************
      SUBROUTINE NISAEP(NELTYP,IEN,NPE,NDIM
     &     ,ITMP,NNOD,NKTP,NORDR,KISO,IBF)
C=======================================================================
C     Program to set up NISA element parameters from HFEM el. param.
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (MIORD=20)
      DIMENSION IEN(*),ITMP(*),IORD(MIORD)
C
      NKTP=20
      NORDR=1
      KISO=0
      IBF=0
      NNOD=NPE
C
      DO J = 1, NPE
         IORD(J)=J
      END DO
      IF(NELTYP.EQ.12) THEN
         NKTP=40
         IF(NPE.EQ.3) NORDR=10
      ELSE IF((NELTYP.EQ.10).OR.(NELTYP.EQ.11)) THEN
         NKTP=20
         IF(NPE.EQ.3) NORDR=10
      ELSE IF((NELTYP.EQ.2).AND.(NDIM.EQ.3)) THEN
         NKTP=4
         IF(NPE.EQ.20) NORDR = 2
         CALL NISA_NODORD(NELTYP,NPE,IORD)
      END IF
C
      DO 200 J=1,NPE
         ITMP(J)=IEN(IORD(J))
 200  CONTINUE
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE NISA_NODORD(NELTYP,NPE,IORD)
C=======================================================================
C     Program to convert FEMME node numbering convention to NISA
C=======================================================================
      IMPLICIT NONE
      INTEGER IORD(*),NPE,NELTYP,NETYP
C
      NETYP=NELTYP/100
      IF((NETYP.EQ.22).OR.(NETYP.EQ.32)) THEN
         IF(NPE.EQ.6) THEN
            IORD(1)=1
            IORD(2)=4
            IORD(3)=2
            IORD(4)=5
            IORD(5)=3
            IORD(6)=6
         ELSE IF(NPE.GE.8) THEN
            IORD(1)=1
            IORD(2)=5
            IORD(3)=2
            IORD(4)=6
            IORD(5)=3
            IORD(6)=7
            IORD(7)=4
            IORD(8)=8
         END IF
      ELSE IF(NETYP.EQ.33) THEN
         IF(NPE.EQ.20) THEN
            IORD(1)=1
            IORD(2)=9
            IORD(3)=2
            IORD(4)=10
            IORD(5)=3
            IORD(6)=11
            IORD(7)=4
            IORD(8)=12
            IORD(9)=17
            IORD(10)=18
            IORD(11)=19
            IORD(12)=20
            IORD(13)=5
            IORD(14)=13
            IORD(15)=6
            IORD(16)=14
            IORD(17)=7
            IORD(18)=15
            IORD(19)=8
            IORD(20)=16
         END IF
      END IF
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE WRNTIT(INEUT)
C=======================================================================
C     Program to write neutral file title
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      CHARACTER LABEL*80,DATE*10,TIME*10
C
      LABEL='HFEM -- educational finite element program version 2002'
      WRITE(INEUT,'(80A)') LABEL
      RETURN
      END
C***********************************************************************
      SUBROUTINE WRN401(ID,NDOF,NP,NC,INEUT)
C=======================================================================
C     Program to write specific displacement data
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (MDOF=30,M6=6)
      DIMENSION ID(NDOF,1),ITMP(MDOF)
C
      WRITE(INEUT,4000)
      DO 2000 I=1,NP
         CALL IZERO(ITMP,M6)
         DO 1200 J=1,NDOF
            ITMP(J)=ID(J,I)
 1200    CONTINUE
         II=0
         DO 1220 J=1,NDOF
            IF(ITMP(J).LE.0) THEN
               ITMP(J)=1
               II=II+1
            ELSE
               ITMP(J)=0
            END IF
 1220    CONTINUE
         IF(II.GT.0) THEN
            IF((NC.EQ.2).AND.(NDOF.EQ.3)) THEN
               ITMP(6)=ITMP(3)
               ITMP(3)=0
            END IF
            WRITE(INEUT,5100) 401,3
            IDS=1
            WRITE(INEUT,5100) I,IDS,(ITMP(J),J=1,M6)
            IZ=0
            RZ=0.D0
            WRITE(INEUT,5200) (RZ,IZ,J=1,3)
            WRITE(INEUT,5200) (RZ,IZ,J=1,3)
         END IF
 2000 CONTINUE
C
      RETURN
 4000 FORMAT('** NEUTRAL FILE <SPDISP DATA> INFORMATION **')
 5100 FORMAT(2I10,4X,6I1)
 5200 FORMAT(3(1PE14.7,1X,I6,1X))
      END
C***********************************************************************
      SUBROUTINE WRN402(IDATA,INEUT,NC,NDOF)
C=======================================================================
C     Program to write specific displacement data
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (M6=6)
      DIMENSION ITMP(M6),TMP(M6)
      CHARACTER*78 LABEL
C
      REWIND IDATA
      READ(IDATA,'(A)',END=3000,ERR=3000) LABEL
      WRITE(INEUT,4000)
      GOTO 120
 100  CONTINUE
      READ(IDATA,'(A)',END=3000,ERR=3000) LABEL
 120  CONTINUE
      READ(LABEL,*) ND,NODE,LDOF,FF
      CALL IZERO(ITMP,M6)
      CALL FZERO(TMP,M6)
      ITMP(LDOF)=1
      TMP(LDOF)=FF
      IF((NC.EQ.2).AND.(NDOF.EQ.3)) THEN
         ITMP(6)=ITMP(3)
         ITMP(3)=0
         TMP(6)=TMP(3)
         TMP(3)=0.
      END IF
      WRITE(INEUT,5100) 402,3
      WRITE(INEUT,5100) NODE,ND,(ITMP(J),J=1,M6)
      CALL IZERO(ITMP,M6)
      WRITE(INEUT,5200) (TMP(J),ITMP(J),ITMP(J),J=1,3)
      WRITE(INEUT,5200) (TMP(J),ITMP(J),ITMP(J),J=4,6)
      GOTO 100
 3000 CONTINUE
C
      RETURN
 4000 FORMAT('** NEUTRAL FILE <CFORCE DATA> INFORMATION **')
 5100 FORMAT(2I10,4X,6I1)
 5200 FORMAT(3(1PE14.7,1X,I6,1X,I3,1X))
      END
C***********************************************************************
      SUBROUTINE WRNISA(DATA,LREC,IDTYP,EDAT
     &     ,NP,NDOF,LVEC,INISA,TIT3,NNN)
C=======================================================================
C     Program to write data at nodes for NISA external file
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION DATA(1),IDTYP(1),TEMP(10),EDAT(1)
      CHARACTER*78 LREC(1)
      CHARACTER*12 FNAME
      CHARACTER*80 TIT3
C
      NDV=3
      LREC(1)='FEMME displacement data'
      LREC(2)='displacements'
      LREC(3)='displacements'
C
      WRITE(*,*) TIT3
      READ(TIT3,'(60X,I6)') NNN
      TIT3(79:80) = '  '
C
      FNAME(1:3) = 'di_'
      IF(NNN.LT.10) THEN
         FNAME(4:4) = TIT3(66:66)
         FNAME(5:8)='.ext'
      ELSE IF(NNN.LT.100) THEN
         FNAME(4:5) = TIT3(65:66)
         FNAME(6:9)='.ext'
      ELSE IF(NNN.LT.1000) THEN
         FNAME(4:6) = TIT3(64:66)
         FNAME(7:10)='.ext'
      ELSE IF(NNN.LT.10000) THEN
         FNAME(4:7) = TIT3(63:66)
         FNAME(8:11)='.ext'
      ELSE 
         FNAME(4:8) = TIT3(62:66)
         FNAME(9:12)='.ext'
      END IF
C
      OPEN(UNIT=INISA,STATUS='UNKNOWN',FILE=FNAME)
C
      WRITE(INISA,5000) LREC(1)
      WRITE(INISA,5000) LREC(2)
      WRITE(INISA,5000) LREC(3)
      WRITE(INISA,'(2I8)') NP,NDV
      DO 220 I=1,NP
      CALL FZERO(TEMP,NDV)
      DO 200 L=1,NDOF
      TEMP(L)=DATA((I-1)*NDOF+L)
 200  CONTINUE
      WRITE(INISA,5060) I,(TEMP(L),L=1,NDV)
 220  CONTINUE
C
      CLOSE(INISA)
C
      RETURN
 5000 FORMAT(A)
 5060 FORMAT(I8,1X,5(E13.7,1X))
      END 
C****-END-OF-FILE-****************************************************** 
