C***********************************************************************
      SUBROUTINE SPMUL(Y,A,D,IA,N,NB,ISYM,ISTM)
C=======================================================================
C     Program to MULtiply a SParse matrix A with a vector D result in Y
C-----------------------------------------------------------------------
C     SMXV - symmetric matrix     CR - compressed row storage mode
C     MXV  - unsymmetric matrix   CD - compressed diagonal storage
C=======================================================================
      IMPLICIT NONE
      INTEGER IA(1),N,NB,ISYM,ISTM,N2,I
      REAL*8  Y(1),A(1),D(1)
C
      N2=N+2
C
      DO I=1,N
         Y(I)=0.0D0
      END DO
C
      IF(ISYM.EQ.1) THEN
         IF(ISTM.EQ.4) THEN
            CALL SMXVCR(Y,A,D,IA,IA(N2),N)
         ELSE IF(ISTM.EQ.5) THEN
            CALL SMXVCC(Y,A,D,IA,IA(N2),N)
         ELSE IF(ISTM.EQ.7) THEN
            CALL SMXVCD(Y,A,D,IA,N,NB)
         END IF
      ELSE
         IF(ISTM.EQ.4) THEN
            CALL MXVCR(Y,A,D,IA,IA(N2),N)
         ELSE IF(ISTM.EQ.5) THEN
            CALL MXVCC(Y,A,D,IA,IA(N2),N)
         ELSE IF(ISTM.EQ.7) THEN
            CALL MXVCD(Y,A,D,IA,N,NB)
         END IF
      END IF
C
      END
C***********************************************************************
      SUBROUTINE SMXVCR(Y,A,D,IRS,ICN,N)
C=======================================================================
C     Program to multiply symmetric sparse matrix with vector
C=======================================================================
      IMPLICIT NONE
      INTEGER IRS(1),ICN(1),N,I,L
      REAL*8  Y(1),A(1),D(1)
C
      DO I=1,N
         DO L=IRS(I),IRS(I+1)-1
            Y(I)=Y(I)+A(L)*D(ICN(L))
         END DO
         DO L=IRS(I),IRS(I+1)-2
            Y(ICN(L))=Y(ICN(L))+A(L)*D(I)
         END DO
      END DO
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE SMXVCC(Y,A,D,ICS,IRN,N)
C=======================================================================
C     Program for Symmetric Matrix Vector multiplication
C     Sparse Compressed Column storage format
C=======================================================================
      IMPLICIT NONE
      INTEGER ICS(*),IRN(*),I,L,N,IROW
      REAL*8  A(*),Y(*),D(*),TMP
C
      DO I=1,N
         TMP=D(I)
         DO L=ICS(I),ICS(I+1)-1
            IROW=IRN(L)
            Y(IROW)=Y(IROW)+A(L)*TMP
         END DO
         DO L=ICS(I)+1,ICS(I+1)-1
            IROW=IRN(L)
            Y(I)=Y(I)+A(L)*D(IROW)
         END DO
      END DO
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE SMXVCD(Y,A,D,IDP,N,NB)
C=======================================================================
C     Program to multiply symmetric sparse matrix with vector
C=======================================================================
      IMPLICIT NONE
      INTEGER IDP(1),N,NB,I,J,L,LL
      REAL*8  Y(N),A(N,NB),D(N)
C
      DO J=1,NB
         L=IDP(J)
         DO I=1,N
            LL=MAX(1,I+L)
            Y(I)=Y(I)+A(I,J)*D(LL)
         END DO
      END DO
C
      DO J=1,NB-1
         L=IDP(J)
         DO I=1,N
            LL=MAX(1,I+L)
            Y(LL)=Y(LL)+A(I,J)*D(I)
         END DO
      END DO
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE MXVCR(Y,A,D,IRS,ICN,N)
C=======================================================================
C     Program for Matrix Vector multiplication 
C     Sparse compressed row storage format
C=======================================================================
      IMPLICIT NONE
      INTEGER IRS(1),ICN(1),I,L,N
      REAL*8 A(1),Y(1),D(1)
C
      DO I=1,N
         DO L=IRS(I),IRS(I+1)-1
            Y(I)=Y(I)+A(L)*D(ICN(L))
         END DO
      END DO
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE MXVCC(Y,A,D,ICS,IRN,N)
C=======================================================================
C     Program for Matrix Vector multiplication 
C     Sparse compressed column storage format
C=======================================================================
      IMPLICIT NONE
      INTEGER ICS(*),IRN(*),I,L,N,IROW
      REAL*8  A(*),Y(*),D(*),TMP
C
      DO I=1,N
         TMP=D(I)
         DO L=ICS(I),ICS(I+1)-1
            IROW=IRN(L)
            Y(IROW)=Y(IROW)+A(L)*TMP
         END DO
      END DO
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE MXVCD(Y,A,D,IDP,N,NB)
C=======================================================================
C     Program for Matrix Vector multiplication 
C     Sparse compressed diagonal storage format
C=======================================================================
      IMPLICIT NONE
      INTEGER IDP(1),I,J,L,I1,I2,N,NB
      REAL*8  A(N,NB),Y(1),D(1),TMP
C
      DO J=1,NB
         L=IDP(J)
         I1=MAX(1,1+L)
         I2=MIN(N,N+L)
         DO I=I1,I2
            Y(I)=Y(I)+A(I,J)*D(I+L)
         END DO
      END DO
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE TSPMUL(Y,A,D,IA,N,NB,ISYM,ISTM)
C=======================================================================
C     Program to MULtiply Transpose of a SParse matrix A 
C     with a vector D result in Y
C-----------------------------------------------------------------------
C     CR - compressed row storage mode
C     CD - compressed diagonal storage
C=======================================================================
      IMPLICIT NONE
      INTEGER IA(1),N,N2,NB,I,ISYM,ISTM
      REAL*8  Y(1),A(1),D(1)
C
      N2=N+2
C
      DO I=1,N
         Y(I)=0.D0
      END DO
C
C --- for symmetric matrices it is the same than ordinary multiply 
C
      IF(ISYM.EQ.1) THEN
         IF(ISTM.EQ.4) THEN
            CALL SMXVCR(Y,A,D,IA,IA(N2),N)
         ELSE IF(ISTM.EQ.7) THEN
            CALL SMXVCD(Y,A,D,IA,N,NB)
         END IF
      ELSE
         IF(ISTM.EQ.4) THEN
            CALL TMXVCR(Y,A,D,IA,IA(N2),N)
         ELSE IF(ISTM.EQ.7) THEN
            CALL TMXVCD(Y,A,D,IA,N,NB)
         END IF
      END IF
C
      END
C***********************************************************************
      SUBROUTINE TMXVCR(Y,A,D,IRS,ICN,N)
C=======================================================================
C     Program to multiply transpose of sparse matrix with vector
C=======================================================================
      IMPLICIT NONE
      INTEGER IRS(1),ICN(1),N,I,L
      REAL*8  Y(1),A(1),D(1)
C
      DO I=1,N
         DO L=IRS(I),IRS(I+1)-1
            Y(ICN(L))=Y(ICN(L))+A(L)*D(I)
         END DO
      END DO
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE TMXVCD(Y,A,D,IDP,N,NB)
C=======================================================================
C     Program to multiply transpose of sparse matrix with vector
C=======================================================================
      IMPLICIT NONE
      INTEGER IDP(1),N,NB,I,J,L,I1,I2
      REAL*8  Y(1),A(N,NB),D(1)
C
      DO J=1,NB
         L=IDP(J)
         I1=MAX(1,1+L)
         I2=MIN(N,N+L)
         DO I=I1,I2
            Y(I)=Y(I)+A(I,J)*D(I+L)
         END DO
      END DO
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE FMXVCR(Y,A,X,IA,JA,W,N)
C=======================================================================
C     Sparse matrix vector multiply of symmetric factorized matrix 
C     stored in CRS mode  y = (L^T)Lx
C     array Y has to be set to zero in the calling routine
C=======================================================================
      IMPLICIT NONE
      INTEGER IA(*),JA(*),N
      DOUBLE PRECISION Y(*),A(*),X(*),W(*)
C --- locals
      INTEGER I,J,K,JSTRT,JSTOP
      DOUBLE PRECISION ZERO,TEMP
      PARAMETER (ZERO=0.0D0)
C
C --- w=L*x
C
      DO I=N,1,-1
         JSTRT=IA(I)
         JSTOP=IA(I+1)-1
         TEMP=ZERO
         DO J=JSTRT,JSTOP
            K=JA(J)
            TEMP=TEMP+A(J)*X(K)
         END DO
         W(I)=TEMP
      END DO
C
C --- y=L^T*w
C
      DO I=1,N
         JSTRT=IA(I)
         JSTOP=IA(I+1)-1
         TEMP=W(I)
         DO J=JSTRT,JSTOP
            K=JA(J)
            Y(K)=Y(K)+TEMP*A(J)
         END DO
      END DO
C
      END
C***********************************************************************
      DOUBLE PRECISION FUNCTION RNORM(A,IA,IP)
C=======================================================================
C     Function to compute the maximum norm of a matrix A stored
C     in sparse storage format
C=======================================================================
      IMPLICIT NONE
      INTEGER IA(1),IP(1),N,ISYM,I1,NB
      REAL*8 A(1),RNORM4,RNORM7
C
      N=IP(5)
      ISYM=IP(3)
      RNORM=0.D0
      I1=N+2
      IF(IP(4).EQ.4) THEN
         RNORM=RNORM4(A,IA,IA(I1),N,ISYM)
      ELSE IF(IP(4).EQ.5) THEN
         RNORM=RNORM4(A,IA,IA(I1),N,ISYM)
      ELSE IF(IP(4).EQ.7) THEN
         NB=IP(6)/N
         RNORM=RNORM7(A,N,NB,ISYM)
      END IF
C
      RETURN
      END
C***********************************************************************
      DOUBLE PRECISION FUNCTION RNORM4(A,IRS,ICN,N,ISYM)
C=======================================================================
C     Function to compute the maximum norm of a matrix A stored
C     in sparse storage format
C=======================================================================
      IMPLICIT NONE
      INTEGER IRS(1),ICN(1),N,ISYM,I,L
      REAL*8 A(1),DUM
C
      RNORM4=0.D0
      DO I=1,N
         DUM=0.D0
         DO L=IRS(I),IRS(I+1)-1
            DUM=DUM+DABS(A(L))
         END DO
         RNORM4=MAX(RNORM4,DUM)
      END DO
C
      RETURN
      END
C***********************************************************************
      DOUBLE PRECISION FUNCTION RNORM7(A,N,NB,ISYM)
C=======================================================================
C     Function to compute the maximum norm of a matrix A stored
C     in sparse storage format
C=======================================================================
      IMPLICIT NONE
      INTEGER N,NB,ISYM,I,J
      REAL*8 A(N,NB),DUM
C
      RNORM7=0.D0
      DO I=1,N
         DUM=0.D0
         DO J=1,NB
            DUM=DUM+DABS(A(I,J))
         END DO
         RNORM7=MAX(RNORM7,DUM)
      END DO
C
      RETURN
      END
C****-END-OF-FILE-******************************************************
