C***********************************************************************
      SUBROUTINE MITC(A,U,F,IA,NG,NE,TASK)
C=======================================================================
C     Program to set up things related to MITC plate element
C=======================================================================
      IMPLICIT NONE
      DOUBLE PRECISION A(*),U(*),F(*)
      INTEGER          IA(1)
      CHARACTER*78     TASK
C --- local variables --------------------------------------------------
      INTEGER          ME,ID,IEN,IODEV,IGETPA,NEQ,NDIM,NEL,NENOD,NDOF,
     &                 IEQEL,NEDOF,N,NE,J,NG,MAT,LSE,IPLOT,IETYP
      PARAMETER       (ME=40) 
      INTEGER          LM(ME),LEN(ME)
      DOUBLE PRECISION EK(ME*ME),XYZ(3*ME),FGETPA,STAB
      CHARACTER*13     LABEL
C
      ID  = IODEV('IDARR')
      IEN = IODEV('IENAR')
C
      NEQ   = IGETPA('NSPAR','NEQ  ',0)
      NDIM  = IGETPA('NSPAR','NDIM ',0)
      NEL   = IGETPA('NEPAR','NEL  ',NG)
      NENOD = IGETPA('NEPAR','NENOD',NG)
      NDOF  = IGETPA('NEPAR','NDOF ',NG)
      IEQEL = IGETPA('NEPAR','IEQEL',NG)
      NEDOF = NENOD*NDOF
C
      IF(INDEX(TASK,'FORM-MATRIX').NE.0)  THEN
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            IF((IEQEL.NE.1).OR.(N.EQ.1)) THEN
               CALL COORD(XYZ,NDIM,LEN,NENOD)
               CALL MITCK(EK,XYZ,NENOD,NDOF,NDIM,MAT,LSE,NG,NE)
            END IF
C
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL ASSEM(A,IA,EK,LM,NEDOF,NE)
         END DO
      ELSE IF(INDEX(TASK,'LOAD').NE.0) THEN
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            CALL COORD(XYZ,NDIM,LEN,NENOD)
            CALL RMLOA(EK,XYZ,NENOD,NDOF,NDIM,MAT,LSE,NG,NE)
C
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL ADDRHS(F,EK,LM,NEDOF)
         END DO
      ELSE IF(INDEX(TASK,'COMPUTE').NE.0)  THEN
C
         STAB  = FGETPA('FPARA','STABC',0)
         IPLOT = IODEV('PLOT') 
         WRITE(IPLOT,5000) NG,STAB
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            CALL COORD(XYZ,NDIM,LEN,NENOD)
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL MITCR(U,XYZ,NENOD,LM,NDOF,MAT,LSE,NG,NE)
         END DO
      END IF
C
 5000 FORMAT(' Element group ',I3,' --- stabilized MITC plate elements',
     &       ' (stab = ',F6.3,')',/,
     &       ' Elem   intp  Bending moments',23X,' Shear forces')
      END
C***********************************************************************
      SUBROUTINE MITCK(EK,XY,NENOD,NDOF,NDIM,MAT,LSE,NG,N)
C=======================================================================
C     Program to set up the stiffness matrix for beam model
C=======================================================================
      IMPLICIT NONE
      INTEGER          NENOD,NDOF,NDIM,MAT,LSE,NG,N
      DOUBLE PRECISION EK(*),XY(NENOD,*)
C --- locals -----------------------------------------------------------
      INTEGER          MW,MEDOF,NB,NS,MN
      PARAMETER       (MW=9,MEDOF=12,MN=4,NB=3,NS=2)
      INTEGER          IPL(MN),IMI(MN),IOUT,IELD,IODEV,IGETPA,I,IP,ISK,
     &                 IDEG,ITR,NIX,NIY,NIP,NEDOF,NSK
      DOUBLE PRECISION WGTH(MW),SK(2*MW),BB(NB*MEDOF),BS(NS*MEDOF),
     &                 CB(NB*NB),CS(NS*NS),SF(MN),SFX(MN),SFY(MN),
     &                 SFLX(MN),SFLY(MN),RSX(MEDOF),RSY(MEDOF),
     &                 XJI(MN),YIJ(MN),SI(MN),CO(MN),XL(MN),
     &                 H,T(MN),TH,STAB,DET,WT,FGETPA,DDOT
      CHARACTER*78     LABEL
C
      IOUT = IODEV('OUTPU')
      IELD = IODEV('ELDAT')
C
      NIX   = IGETPA('NEPAR','NIX  ',NG)
      NIY   = IGETPA('NEPAR','NIY  ',NG)
      NIP   = NIX*NIY
      NEDOF = NENOD*NDOF
      STAB  = FGETPA('FPARA','STABC',0)
C
      ITR = 0
      IF(NENOD.EQ.3) ITR = 1
C
      CALL FZERO(EK,NEDOF*NEDOF)
C
      CALL GIPIM(IPL,IMI,NENOD)
C
      CALL INTP2D(SK,WGTH,NIX,NIY,NIP,NENOD,IDEG,ITR,NSK,NG)
C
      H = 0.D0
      DO I = 1, NENOD
         XJI(I) = XY(I,1) - XY(IPL(I),1)
         YIJ(I) = XY(IPL(I),2) - XY(I,2)
         XL(I)  = SQRT(XJI(I)*XJI(I) + YIJ(I)*YIJ(I))
         SI(I)  = XJI(I)/XL(I)
         CO(I)  = YIJ(I)/XL(I)
         H      = MAX(H,XL(I))
      END DO
C
      CALL THICK(NENOD,T,IELD,N,LSE)
C
      DO IP = 1, NIP
         ISK = (IP-1)*NSK + 1
         CALL INTF2D(XY,SK(ISK),SF,SFX,SFY
     &        ,SFLX,SFLY,DET,ITR,NENOD,N,IOUT)
         CALL RMITC(RSX,RSY,SF,IPL,IMI,CO,SI,NENOD,NDOF,NDIM)
C
         CALL FZERO(BB,NB*NEDOF)
         CALL FZERO(BS,NS*NEDOF)
         CALL BBRM(BB,NB,SFX,SFY,NENOD,NDOF)
         CALL BSRMR(BS,NS,SFX,SFY,RSX,RSY,NENOD,NDOF,NDIM)
C
         TH = DDOT(NENOD,SF,1,T,1)
         CALL CMKLRR(CB,NB,TH,MAT)
         CALL CMRMRR(CS,NS,TH,MAT)
         CALL REDSH(CS,NS,H,TH,STAB)
C
         WT = WGTH(IP)*DET
         CALL DSCAL(NB*NB,WT,CB,1)
         CALL DSCAL(NS*NS,WT,CS,1)
C
         CALL BTDB(EK,BB,CB,NEDOF,NB,NB,NB)
         CALL BTDB(EK,BS,CS,NEDOF,NS,NS,NS)
      END DO
C
      END
C***********************************************************************
      SUBROUTINE THICK(NENOD,T,IELD,N,LSE)
C=======================================================================
C     Program to set up the nodal thickness array
C=======================================================================
      IMPLICIT NONE
      INTEGER          NENOD,IELD,N,LSE,I
      DOUBLE PRECISION T(*),TH,FGETPA
C
      IF(LSE.GT.0) THEN
         TH = FGETPA('SPARA','THICK',LSE)
         DO I = 1, NENOD
            T(I) = TH
         END DO
      ELSE
         READ(IELD,REC=N) (T(I),I=1,NENOD)
      END IF
C
      END
C***********************************************************************
      SUBROUTINE BBRM(B,NB,SFX,SFY,NPE,NLDF)
C=======================================================================
C     Program to form the curvature-displacement matrix 
C     for Reissner-Mindlin plate bending elements
C=======================================================================
      IMPLICIT NONE
      INTEGER          NB,NPE,NLDF
      DOUBLE PRECISION B(NB,*),SFX(*),SFY(*)
C --- locals -----------------------------------------------------------
      INTEGER          I,IX,IY
C
      IX = -1
      DO I = 1, NPE
         IX = IX + NLDF
         IY = IX + 1
         B(1,IY) =  SFX(I)
         B(2,IX) = -SFY(I)
         B(3,IX) = -SFX(I)
         B(3,IY) =  SFY(I)
      END DO
C
      END 
C***********************************************************************
      SUBROUTINE BSRMR(B,NB,SFX,SFY,RSX,RSY,NPE,NLDF,NC)
C=======================================================================
C     Program to form the shear-displacement matrix 
C     for Reissner-Mindlin plate bending elements
C     Reduction operator used in the definition of rotations
C=======================================================================
      IMPLICIT NONE
      INTEGER          NB,NPE,NLDF,NC
      DOUBLE PRECISION B(NB,*),SFX(*),SFY(*),RSX(*),RSY(*)
      INTEGER          I,IW,IX,IY
C
      IW = -NC
      DO I = 1, NPE
         IW = IW + NLDF
         IX = IW + 1
         IY = IX + 1
         B(1,IW)= SFX(I)
         B(1,IX)= RSY(IX)
         B(1,IY)= RSY(IY)
         B(2,IW)= SFY(I)
         B(2,IX)=-RSX(IX)
         B(2,IY)=-RSX(IY)
      END DO
C
      END 
C***********************************************************************
      SUBROUTINE RMITC(RSX,RSY,SF,IPL,IMI,CO,SI,NPE,NLDF,NC)
C=======================================================================
C     Program to evaluate modified rotation components
C=======================================================================
      IMPLICIT NONE
      INTEGER          NPE,NLDF,NC,IPL(*),IMI(*)
      DOUBLE PRECISION RSX(*),RSY(*),SF(*),CO(*),SI(*)
C --- locals -----------------------------------------------------------
      INTEGER          I,IX,IY,IP,IM,IMM,NR
      DOUBLE PRECISION PF,DEM,DEP,RX1,RX2,RY1,RY2
C
      PF=0.5D0
      NR=NPE*NLDF
      CALL FZERO(RSX,NR)
      CALL FZERO(RSY,NR)
      IX=-NC+1
      DO I=1,NPE
         IP  = IPL(I)
         IM  = IMI(I)
         IMM = IMI(IM)
         IX  = IX+NLDF
         IY  = IX+1
         DEM = CO(IM)*SI(IMM)-CO(IMM)*SI(IM)
         DEP = CO(IP)*SI(I)-CO(I)*SI(IP)
         RX1 = SF(I)+SI(IMM)*CO(IM)*SF(IM)/DEM-SI(IP)*CO(I)*SF(IP)/DEP
         RY1 = SF(I)-CO(IMM)*SI(IM)*SF(IM)/DEM+CO(IP)*SI(I)*SF(IP)/DEP
         RX2 = SI(IMM)*SI(IM)*SF(IM)/DEM-SI(IP)*SI(I)*SF(IP)/DEP
         RY2 =-CO(IMM)*CO(IM)*SF(IM)/DEM+CO(IP)*CO(I)*SF(IP)/DEP
         RSX(IX) = PF*RX1
         RSX(IY) = PF*RX2
         RSY(IX) = PF*RY2
         RSY(IY) = PF*RY1
      END DO
C
      END
C***********************************************************************
      SUBROUTINE MITCR(U,XY,NENOD,LM,NDOF,MAT,LSE,NG,N)
C=======================================================================
C     Program to set up the stiffness matrix for beam model
C=======================================================================
      IMPLICIT NONE
      INTEGER          LM(*),NENOD,NDOF,MAT,LSE,NG,N
      DOUBLE PRECISION U(*),XY(NENOD,*)
C --- locals -----------------------------------------------------------
      INTEGER          MW,MEDOF,NB,NS,MN
      PARAMETER       (MW=9,MEDOF=12,MN=4,NB=3,NS=2)
      INTEGER          IPL(MN),IMI(MN),IOUT,IPLOT,IODEV,IGETPA,I,IP,ISK,
     &                 IDEG,ITR,NIX,NIY,NIP,NEDOF,NSK,IELD
      DOUBLE PRECISION WGTH(MW),SK(2*MW),BB(NB*MEDOF),BS(NS*MEDOF),
     &                 CB(NB*NB),CS(NS*NS),SF(MN),SFX(MN),SFY(MN),
     &                 SFLX(MN),SFLY(MN),RSX(MEDOF),RSY(MEDOF),
     &                 XJI(MN),YIJ(MN),SI(MN),CO(MN),XL(MN),UL(MEDOF),
     &                 BEND(NB),CURV(NB),SHEA(NS),SFOR(NS),
     &                 H,T(MN),TH,STAB,DET,WT,FGETPA,DDOT
      CHARACTER*78     LABEL
C
      IOUT  = IODEV('OUTPU')
      IELD  = IODEV('ELDAT')
      IPLOT = IODEV('PLOT')
C
      NIX   = IGETPA('NEPAR','NIX  ',NG)
      NIY   = IGETPA('NEPAR','NIY  ',NG)
      NIP   = NIX*NIY
      NEDOF = NENOD*NDOF
      STAB  = FGETPA('FPARA','STABC',0)
C
      CALL FZERO(UL,NEDOF)
      CALL GETELV(UL,U,LM,NEDOF)
C
      CALL GIPIM(IPL,IMI,NENOD)
C
      CALL INTP2D(SK,WGTH,NIX,NIY,NIP,NENOD,IDEG,ITR,NSK,NG)
C
      H = 0.D0
      DO I = 1, NENOD
         XJI(I) = XY(I,1) - XY(IPL(I),1)
         YIJ(I) = XY(IPL(I),2) - XY(I,2)
         XL(I)  = SQRT(XJI(I)*XJI(I) + YIJ(I)*YIJ(I))
         SI(I)  = XJI(I)/XL(I)
         CO(I)  = YIJ(I)/XL(I)
         H      = MAX(H,XL(I))
      END DO
C
      CALL THICK(NENOD,T,IELD,N,LSE)
C
      DO IP = 1, NIP
         ISK=(IP-1)*NSK+1
         CALL INTF2D(XY,SK(ISK),SF,SFX,SFY
     &        ,SFLX,SFLY,DET,ITR,NENOD,N,IOUT)
         CALL RMITC(RSX,RSY,SF,IPL,IMI,CO,SI,NENOD,NDOF,2)
C
         CALL FZERO(BB,NB*NEDOF)
         CALL FZERO(BS,NS*NEDOF)
         CALL BBRM(BB,NB,SFX,SFY,NENOD,NDOF)
         CALL BSRMR(BS,NS,SFX,SFY,RSX,RSY,NENOD,NDOF,2)
         CALL FZERO(CURV,NB)
         CALL FZERO(SHEA,NS)
         CALL MULTF(CURV,BB,UL,NB,NB,NEDOF)
         CALL MULTF(SHEA,BS,UL,NS,NS,NEDOF)
         TH = DDOT(NENOD,SF,1,T,1)
         CALL CMKLRR(CB,NB,TH,MAT)
         CALL CMRMRR(CS,NS,TH,MAT)
         CALL REDSH(CS,NS,H,TH,STAB)
         CALL FZERO(BEND,NB)
         CALL FZERO(SFOR,NS)
         CALL MULTF(BEND,CB,CURV,NB,NB,NB)
         CALL MULTF(SFOR,CS,SHEA,NS,NS,NS)
         WRITE(IPLOT,5100) N,IP,(BEND(I),I=1,3),(SFOR(I),I=1,2)
      END DO
C
 5100 FORMAT(1X,I6,I4,5(1P,E13.5))
      END
C***********************************************************************
      SUBROUTINE CMKLRR(C,NC,T,MAT)
C=======================================================================
C     Program to set up constitutive matrix for plate elements
C     bending part of the resultant constitutive matrix
C-----------------------------------------------------------------------
C=======================================================================
      IMPLICIT NONE
      INTEGER          NC,MAT
      DOUBLE PRECISION C(NC,*),T
C --- locals -----------------------------------------------------------
      DOUBLE PRECISION EX,PRX,DUM,FGETPA
C
      CALL FZERO(C,NC*NC)
C
      EX  = FGETPA('CPARA','EX   ',MAT)
      PRX = FGETPA('CPARA','PRX  ',MAT)
      DUM = EX*T**3/(12.0*(1.0 - PRX*PRX))
C
      C(1,1) = DUM
      C(2,1) = PRX*DUM
      C(1,2) = PRX*DUM
      C(2,2) = DUM
      C(3,3) = 0.5D0*(1.0 - PRX)*DUM
C
      END
C***********************************************************************
      SUBROUTINE CMRMRR(C,NC,T,MAT)
C=======================================================================
C     Program to set up constitutive matrix for Reissner Mindlin
C     model, shear part of the resultant constitutive matrix
C-----------------------------------------------------------------------
C=======================================================================
      IMPLICIT NONE
      INTEGER          NC,MAT
      DOUBLE PRECISION C(NC,*),T
C --- locals -----------------------------------------------------------
      DOUBLE PRECISION EX,PRX,DUM,FGETPA
C
      CALL FZERO(C,NC*NC)
C
      EX  = FGETPA('CPARA','EX   ',MAT)
      PRX = FGETPA('CPARA','PRX  ',MAT)
      DUM = 0.5D0*EX*T/(1.D0 + PRX)
C
      C(1,1) = DUM
      C(2,2) = DUM
C
      END
C***********************************************************************
      SUBROUTINE REDSH(C,MC,H,T,STAB)
C=======================================================================
C     Purpose
C     perform the stabilization of the shear in Reissner-Mindlin model
C=======================================================================
      IMPLICIT NONE
      INTEGER          MC
      DOUBLE PRECISION C(MC,*),H,T,STAB,DUM
C
      DUM=1.D0/(1.D0+STAB*(H/T)**2)
      C(1,1)=C(1,1)*DUM
      C(2,2)=C(2,2)*DUM
C
      END
C***********************************************************************
      SUBROUTINE GIPIM(IPL,IMI,NPE)
C=======================================================================
C     Purpose
C     to get the previous node arrays 
C=======================================================================
      IMPLICIT NONE
      INTEGER IPL(*),IMI(*),NPE,I
C
      DO I=1,NPE
         IMI(I)=I-1+INT(NPE*AINT(1.D0/REAL(I)))
         IPL(I)=MOD(I+NPE,NPE)+1
      END DO
C
      END
C***********************************************************************
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C-***-END-OF-FILE-******************************************************
