C***********************************************************************
      SUBROUTINE IZERO(IA,N)
C=======================================================================
C     Program to zero an integer array
C=======================================================================
      DIMENSION IA(1)
C
      DO 100 I=1,N
         IA(I)=0
 100  CONTINUE
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE FZERO(A,N)
C=======================================================================
C     Program to zero a floating point array
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z) 
      DIMENSION A(1)
C
      DO 100 I=1,N
         A(I)=0.D0
 100  CONTINUE
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE MULT2S(Y,A,D,IRS,ICN,N)
C=======================================================================
C     Program to multiply symmetrix sparse matrix with vector
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION Y(1),A(1),D(1),IRS(1),ICN(1)
C
      DO 300 I=1,N
         DO 100 L=IRS(I),IRS(I+1)-1
            Y(I)=Y(I)+A(L)*D(ICN(L))
 100     CONTINUE
         DO 200 L=IRS(I),IRS(I+1)-2
            Y(ICN(L))=Y(ICN(L))+A(L)*D(I)
 200     CONTINUE
 300  CONTINUE
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE MULT2(Y,A,D,IRS,ICN,N)
C=======================================================================
C     Program to multiply sparse matrix with vector
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION Y(1),A(1),D(1),IRS(1),ICN(1)
C
      DO 200 I=1,N
         DO 100 L=IRS(I),IRS(I+1)-1
            Y(I)=Y(I)+A(L)*D(ICN(L))
 100     CONTINUE
 200  CONTINUE
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE MULT2T(Y,A,D,IRS,ICN,N)
C=======================================================================
C     Program to multiply the transpose of sparse matrix with vector
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION Y(1),A(1),D(1),IRS(1),ICN(1)
C
      DO 200 I=1,N
         DO 100 L=IRS(I),IRS(I+1)-1
            Y(ICN(L))=Y(ICN(L))+A(L)*D(I)
 100     CONTINUE
 200  CONTINUE
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE MULTF(Y,A,X,NA,N,M)
C=======================================================================
C     Program to multiply full matrix A with vector X (Y=AX)
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(NA,1),Y(1),X(1)
C
      DO 200 J=1,M
         DO 100 I=1,N
            Y(I)=Y(I)+A(I,J)*X(J)
 100     CONTINUE
 200  CONTINUE
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE GETELV(EV,GV,LM,NEDOF)
C=======================================================================
C     Program to get the element vector from global vector
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION EV(1),GV(1),LM(1)
C
      DO 200 I=1,NEDOF
         IDOF=LM(I)
         IF(IDOF.GT.0) THEN
            EV(I)=GV(IDOF)
         END IF
 200  CONTINUE
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE PUTELV(EV,GV,LM,NEDOF)
C=======================================================================
C     Program to put the element vector to the global vector
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION EV(1),GV(1),LM(1)
C
      DO 200 I=1,NEDOF
         IDOF=LM(I)
         IF(IDOF.GT.0) THEN
            GV(IDOF)=GV(IDOF)+EV(I)
         END IF
 200  CONTINUE
C
      RETURN
      END
C***********************************************************************
