C***********************************************************************
      SUBROUTINE ITESOL(A,X,B,IA,IOUT)
C=======================================================================
C     Driver program for iterative solution of linear equations Ax = b
C-----------------------------------------------------------------------
C     Calling parameters:
C     A:  array storing the matrix, possibly preconditioner and
C         working vectors
C     X:  vector of unknown
C     B:  rhs vector
C=======================================================================
      IMPLICIT NONE
      INTEGER          IA(*)
      DOUBLE PRECISION A(*),X(*),B(*)
C --- local variables ---
      DOUBLE PRECISION FGETPA,RINI,DNRM2
      INTEGER          IOUT,IMETH,NEQ,NGK,NPR,N1,N2
      INTEGER          IODEV,IGETPA
C
      IOUT  = IODEV('OUTPU') 
      NEQ   = IGETPA('NSPAR','NEQ  ',0)
      IMETH = IGETPA('NSPAR','IMETH',0)
      NGK   = IGETPA('NSPAR','NGK',0)
C
      CALL PRECON(A,IA)
      NPR   = IGETPA('NSPAR','NPR',0)
C
      N1  = NGK + 1
      N2  = N1 + NPR
C
      RINI = DNRM2(NEQ,B,1)
      CALL PUTFPA('FPARA','RINI',RINI,0)
C
      IF(IMETH.EQ.100) THEN
         CALL PCG(A,IA,A(N1),X,B,A(N2),NEQ)
      ELSE IF(IMETH.EQ.200) THEN
         CALL PBCG(A,IA,A(N1),X,B,A(N2),NEQ)
      END IF
C
      END
C***********************************************************************
      INTEGER FUNCTION ICONV(RES,IT,NAME)
C=======================================================================
C     Function to return the convergence flag
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      CHARACTER*(*) NAME
      PARAMETER (EPS = 1.E-16,ZERO = 0.D0)
C
      ATOL  = FGETPA('FPARA','ATOL ',0)
      RTOL  = FGETPA('FPARA','RTOL ',0)
      RINI  = FGETPA('FPARA','RINI ',0)
      MITER = IGETPA('MPARA','MITER',0)
      IOUT  = IODEV('OUTPU')
C
      ICONV = 0
C
      IF(ATOL.LE.ZERO) ATOL = DSQRT(EPS)
      IF(RTOL.LE.ZERO) RTOL = DSQRT(EPS)
C
      REF = RTOL*RINI + ATOL
C      WRITE(39,'(I6,2(1P,E13.5))') IT,RES/RINI,LOG10(RES/RINI)
      IF(RES.LT.REF) THEN
         WRITE(IOUT,5000) IT,RES
         WRITE(*,5000) IT,RES
         ICONV=1
      ELSE
         IF(IT.GE.MITER) THEN
            WRITE(IOUT,5100) IT,RES
            WRITE(*,5100) IT,RES
            ICONV=-1
         ELSE
            WRITE(IOUT,'('' IT ERR '',I6,E13.5)') IT,RES
            WRITE(*,'('' IT ERR '',I6,E13.5)') IT,RES
         END IF
      END IF
C
 5000 FORMAT(' Iteration converged after iteration ',I6,/,
     &       ' Norm of residual = ',E13.5)
 5100 FORMAT(' Iteration not converged in ',I6,' iterations',/,
     &       ' Norm of residual = ',E13.5)
      END
C***********************************************************************
      SUBROUTINE PCG(A,IA,P,X,F,W,N)
C=======================================================================
C     Program to solve linear equation system AX=F with 
C     preconditioned conjugate gradient method
C=======================================================================
      IMPLICIT NONE
      INTEGER IA(*),N
      REAL*8  A(*),P(*),X(*),F(*),W(N,4)
C --- locals ---
      INTEGER I,IT,ICF,ICONV,NA,NB,ISYM,ISTM,IGETPA
      REAL*8  RES,RESNOR,BE,AL,DDOT,DNRM2,DUM,RHO,RHN
      CHARACTER*43 NAME
      DATA NAME /'Preconditioned Conjugate Gradient iteration'/
C
      IT  = 0
      NA  = IGETPA('NSPAR','NGK',0)
      NB  = NA/N
      ISYM=IGETPA('NSPAR','ISYM',0)
      ISTM=IGETPA('NSPAR','ISTMO',0)
C
      CALL FZERO(W,4*N)
      CALL DCOPY(N,F,1,W(1,3),1)
C
      CALL PRESOL(P,A,IA,W(1,2),W(1,3),N,0)
C
      RHN=DDOT(N,W(1,2),1,W(1,3),1)
      CALL DCOPY(N,W(1,2),1,W(1,4),1)
      RESNOR=DNRM2(N,W(1,3),1)
      ICF=ICONV(RESNOR,IT,NAME)
      IF(ICF.NE.0) RETURN
C
 200  CONTINUE
      IT=IT+1
C
      CALL SPMUL(W,A,W(1,4),IA,N,NB,ISYM,ISTM)
C
      DUM=DDOT(N,W,1,W(1,4),1)
      AL=RHN/DUM
      CALL DAXPY(N,AL,W(1,4),1,X,1)
      CALL DAXPY(N,-AL,W,1,W(1,3),1)
      RESNOR=DNRM2(N,W(1,3),1)
      ICF=ICONV(RESNOR,IT,NAME)
      IF(ICF.NE.0) RETURN
C
      CALL PRESOL(P,A,IA,W(1,2),W(1,3),N,0)
C
      RHO=RHN
      RHN=DDOT(N,W(1,2),1,W(1,3),1)
      BE=RHN/RHO
      CALL DAXPY(N,BE,W(1,4),1,W(1,2),1)
      CALL DCOPY(N,W(1,2),1,W(1,4),1)
      GOTO 200
C
      END
C***********************************************************************
      SUBROUTINE PBCG(A,IA,PC,X,F,D,N)
C=======================================================================
C     Program to solve nonsymmetric equation system 
C     with the Bi-Conjugate Gradiend method
C=======================================================================
      IMPLICIT NONE
      INTEGER IA(*),N
      REAL*8  A(*),PC(*),F(N),X(N),D(N,6)
C --- locals ---
      INTEGER I,IT,ICF,ICONV,NB,ISYM,ISTM,IGETPA,NA
      REAL*8  AL,GA,TH,BE,RES,DDOT,DNRM2,RN,RO,GAM,FSMAL
      CHARACTER*46 NAME
      DATA NAME /'Preconditioned Bi-Conjugate Gradient iteration'/
C
      NA   = IGETPA('NSPAR','NGK',0)
      NB   = NA/N
      ISYM = IGETPA('NSPAR','ISYM',0)
      ISTM = IGETPA('NSPAR','ISTMO',0)
C
      FSMAL = 1.E-16
      CALL FZERO(D,6*N)
C
      CALL DCOPY(N,F,1,D,1)
      CALL DCOPY(N,F,1,D(1,3),1)
C
      IT  = 0
      RES = DNRM2(N,D,1)
      ICF = ICONV(RES,IT,NAME)
 200  CONTINUE
      IT = IT + 1
C
      CALL PRESOL(PC,A,IA,D(1,2),D,N,0)
      CALL PRESOL(PC,A,IA,D(1,4),D(1,3),N,1)
C
      RN = DDOT(N,D(1,2),1,D(1,3),1)
C
      IF(IT.GT.1) THEN
         BE = RN/RO
         DO I=1,N
            D(I,5)=D(I,2)+BE*D(I,5)
            D(I,6)=D(I,4)+BE*D(I,6)
         END DO
      ELSE
         CALL DCOPY(N,D(1,2),1,D(1,5),1)
         CALL DCOPY(N,D(1,4),1,D(1,6),1)
      END IF
C
      CALL SPMUL (D(1,2),A,D(1,5),IA,N,NB,ISYM,ISTM)
      CALL TSPMUL(D(1,4),A,D(1,6),IA,N,NB,ISYM,ISTM)
C
      GAM = DDOT(N,D(1,2),1,D(1,6),1)
      AL  = RN/GAM
      DO I=1,N
         X(I)=X(I)+AL*D(I,5)
         D(I,1)=D(I,1)-AL*D(I,2)
         D(I,3)=D(I,3)-AL*D(I,4)
      END DO
C
      RES = DNRM2(N,D,1)
      ICF = ICONV(RES,IT,NAME)
      IF(ICF.NE.0) RETURN
      RO = RN
      GOTO 200
C
      END
C***********************************************************************
C
C****-END-OF-FILE-******************************************************
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
