C***********************************************************************
      SUBROUTINE INTFUN(XYZ,SK,F,DFX,DFY,DFZ
     &     ,DLX,DLY,DLZ,DET,ND,ITR,NOD,N,IOUT)
C=======================================================================
C     Program to get the interpolation functions
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION XYZ(*),SK(*),F(*),DFX(*),DFY(*),DFZ(*)
      DIMENSION DLX(*),DLY(*),DLZ(*)
C
      IF(ND.EQ.1) THEN
         X=SK(1)
         IDEG=NOD-1
         CALL SIFL(X,F,IDEG,0,IOUT)
         CALL SIFL(X,DLX,IDEG,1,IOUT)
         DET=DDOT(NOD,DLX,1,XYZ,1)
         IF(DET.LE.0.D0) THEN
            WRITE(IOUT,5000) N
            STOP
         END IF
         DETINV=1.D0/DET
         CALL DCOPY(NOD,DLX,1,DFX,1)
         CALL DSCAL(NOD,DETINV,DFX,1)
      ELSE IF(ND.EQ.2) THEN
         IF(ITR.EQ.0) THEN
            X=SK(1)
            Y=SK(2)
            CALL SIFQ(X,Y,F,DLX,DLY,NOD)
         ELSE
            CALL SIFT(SK,F,DLX,DLY,NOD)
         END IF
         CALL JACO2D(XYZ,DLX,DLY,DFX,DFY,DET,NOD,N,IOUT)
      ELSE IF(ND.EQ.3) THEN
         IF(ITR.EQ.0) THEN
            X=SK(1)
            Y=SK(2)
            Z=SK(3)
            CALL SIF3D(X,Y,Z,F,DLX,DLY,DLZ,NOD)
         ELSE
C --------- tetrahedral interpolation functions here -----
         END IF
         CALL JACO3D(XYZ,DLX,DLY,DLZ,DFX,DFY,DFZ,DET,NOD,N,IOUT)
      END IF
C
 5000 FORMAT(' *** ERROR *** NEGATIVE OR ZERO JACOBIAN IN ELEMENT ',I6) 
      END
C***********************************************************************
      SUBROUTINE INTF2D(XY,SK,F,DFX,DFY,DLX,DLY,DET,ITR,NOD,N,IOUT)
C=======================================================================
C     Program to get the interpolation functions in 2-D
C=======================================================================
      IMPLICIT NONE
      INTEGER          ITR,NOD,N,IOUT
      DOUBLE PRECISION XY(*),SK(*),F(*),DFX(*),DFY(*),DLX(*),DLY(*),DET
C
      IF(ITR.EQ.0) THEN
         CALL SIFQ(SK(1),SK(2),F,DLX,DLY,NOD)
      ELSE
         CALL SIFT(SK,F,DLX,DLY,NOD)
      END IF
C
      CALL JACO2D(XY,DLX,DLY,DFX,DFY,DET,NOD,N,IOUT)
C
      END
C***********************************************************************
      SUBROUTINE SIFL(X,FX,IDEG,IORD,IOUT)
C=======================================================================
C     Program to set up standard Lagrange interpolation functions in 1D
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION FX(*)
C
      IF(IDEG.EQ.1) THEN
         IF(IORD.EQ.0) THEN
            FX(1)=(1.-X)/2.
            FX(2)=(1.+X)/2.
         ELSE IF(IORD.EQ.1) THEN
            FX(1)=-.5
            FX(2)=.5
         ELSE 
            WRITE(IOUT,5000) IORD,IDEG
            STOP
         END IF
      ELSE IF(IDEG.EQ.2) THEN
         IF(IORD.EQ.0) THEN
            FX(1)=X*(X-1.)/2.
            FX(2)=1.-X*X
            FX(3)=X*(X+1.)/2.
         ELSE IF(IORD.EQ.1) THEN
            FX(1)=(X-.5)
            FX(2)=-2.*X
            FX(3)=(X+.5)
         ELSE IF(IORD.EQ.2) THEN
            FX(1)=1.
            FX(2)=-2.
            FX(3)=1.
         ELSE
            WRITE(IOUT,5000) IORD,IDEG
            STOP
         END IF
      ELSE IF(IDEG.EQ.3) THEN
         X1=-1.
         X2=-1./3.
         X3=1./3.
         X4=1.
         DX1=X-X1
         DX2=X-X2
         DX3=X-X3
         DX4=X-X4
         IF(IORD.EQ.0) THEN
            FX(1)= -9./16.*DX2*DX3*DX4
            FX(2)= 27./16.*DX1*DX3*DX4
            FX(3)=-27./16.*DX1*DX2*DX4
            FX(4)=  9./16.*DX1*DX2*DX3
         ELSE IF(IORD.EQ.1) THEN
            FX(1)= -9./16.*(DX3*DX4+DX2*DX4+DX2*DX3)
            FX(2)= 27./16.*(DX3*DX4+DX1*DX4+DX1*DX3)
            FX(3)=-27./16.*(DX2*DX4+DX1*DX4+DX1*DX2)
            FX(4)=  9./16.*(DX2*DX3+DX1*DX3+DX1*DX2)
         ELSE
            WRITE(IOUT,5000) IORD,IDEG
            STOP
         END IF    
      END IF
C
      RETURN
 5000 FORMAT(' *** STOP *** IN -SIFL- : IORD = 'I2,', IDEG = 'I2)
      END
C***********************************************************************
      SUBROUTINE HI1LAG(X,F,N,IORD,IOUT)
C=======================================================================
C     Program to evaluate 1-D hierarchical interpolation functions
C-----------------------------------------------------------------------
C     X     = argument 
C     F     = interpolation functions of degree N
C             F(1) = (1-X)/2, F(2) = (1+X)/2 : nodal interpolation 
C             F(3) ... F(N+1) : internal interpolation functions 
C             generated from Legendre polynomials
C     N     = degree of the polynomial
C     IORD  = order of derivative (0 or 1)
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION F(*)
      SQRT(X)=DSQRT(X)
C
C --- generate Legendre polynomials using a stable recursion formula
C
      F(1)=1.D0
      F(2)=X
      DO 100 I=1,N-1
         F(I+2)=2.D0*X*F(I+1)-F(I)-(X*F(I+1)-F(I))/REAL(I+1)
 100  CONTINUE 
C
C --- set up interpolation functions or their derivatives
C
      IF(IORD.EQ.0) THEN
         DO I=N,2,-1
            F(I+1)=(F(I+1)-F(I-1))/SQRT(REAL(4*I)-2.D0)
         END DO
         F(1)=0.5D0*(1.D0-X)
         F(2)=0.5D0*(1.D0+X)
      ELSE IF(IORD.EQ.1) THEN
         DO I=N,2,-1
            F(I+1)=SQRT(REAL(I)-0.5D0)*F(I)
         END DO
         F(1)=-0.5D0
         F(2)= 0.5D0
      ELSE 
         WRITE(IOUT,5000) IORD
         STOP
      END IF
C
 5000 FORMAT(' *** ERROR *** in HI1LAG >>> derivative order ',I3)
      END
C***********************************************************************
      SUBROUTINE SIFHER(X,FX,DJAC,IORD)
C=======================================================================
C     Program to set up 1-D cubic Hermitian interpolation functions
C             on an interval (-1,1)
C-----------------------------------------------------------------------
C     X    : point of evaluation 
C     FX   : the value of a function or its derivatives
C     DJAC : inverse jacobian (2/XLL)
C     IORD : order of derivative
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION FX(*)
C     -----
      B=0.5D0
      C=0.25D0
      F1=X-1.D0
      F2=X+1.D0
      F3=2.D0+X
      F4=2.D0-X         
      IF(IORD.EQ.0) THEN 
         FX(1)=C*F1*F1*F3
         FX(2)=C*F2*F1*F1/DJAC
         FX(3)=C*F2*F2*F4
         FX(4)=C*F1*F2*F2/DJAC
      ELSE IF(IORD.EQ.1) THEN
         FX(1)=B*F1*(F3+B*F1)*DJAC
         FX(2)=B*F1*(F2+B*F1)
         FX(3)=B*F2*(F4-B*F2)*DJAC
         FX(4)=B*F2*(F1+B*F2)
      ELSE IF(IORD.EQ.2) THEN
         FX(1)=(F1+B*F3)*DJAC*DJAC
         FX(2)=(F1+B*F2)*DJAC
         FX(3)=(-F2+B*F4)*DJAC*DJAC
         FX(4)=(F2+B*F1)*DJAC
      END IF
C
      END
C***********************************************************************
      SUBROUTINE HI1HER(X,F,DJAC,N,IORD)
C=======================================================================
C     Program to set up 1-D hierarchical Hermitian interpolation 
C             functions on the interval (-1,1)
C-----------------------------------------------------------------------
C     X    : point of evaluation 
C     F    : the value of a function or its derivatives
C     DJAC : inverse jacobian (2/XLL)
C     N    : degree of the polynomial (N > or = 3)
C     IORD : order of derivative
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION F(*)
C
C --- Generate first the internal modes from
C --- Legendre polynomials using a stable recursion formula
C
      F(1) = 1.0D0
      F(2) = X
      DO I = 1, N-1
         F(I+2) = 2.D0*X*F(I+1)-F(I)-(X*F(I+1)-F(I))/REAL(I+1)
      END DO
C
C --- set up the internal interpolation functions or their derivatives
C
      IF(IORD.EQ.0) THEN
         DO I = N, 4, -1
            F1 = 1.0/DSQRT(4.0D0*REAL(I) - 6.0D0)
            F2 = 1.0/(2.0*REAL(I) - 1.0)
            F3 = 1.0/(2.0*REAL(I) - 5.0)
            F(I+1)=F1*(F2*(F(I+1)-F(I-1)) - F3*(F(I-1)-F(I-3)))
         END DO
      ELSE IF(IORD.EQ.1) THEN
         DO I = N, 4, -1
            F1 = DJAC/DSQRT(4.0D0*REAL(I) - 6.0D0)
            F(I+1) = F1*(F(I) - F(I-2))
         END DO
      ELSE IF(IORD.EQ.2) THEN
         DO I = N, 4, -1
            F(I+1) = DJAC*DJAC*DSQRT(REAL(I)-1.5D0)*F(I-1)
         END DO
      END IF
C
C --- the nodal interpolation ------
C
      B  = 0.5D0
      C  = 0.25D0
      F1 = X - 1.D0
      F2 = X + 1.D0
      F3 = 2.D0 + X
      F4 = 2.D0 - X         
      IF(IORD.EQ.0) THEN 
         F(1) = C*F1*F1*F3
         F(2) = C*F2*F1*F1/DJAC
         F(3) = C*F2*F2*F4
         F(4) = C*F1*F2*F2/DJAC
      ELSE IF(IORD.EQ.1) THEN
         F(1) = B*F1*(F3+B*F1)*DJAC
         F(2) = B*F1*(F2+B*F1)
         F(3) = B*F2*(F4-B*F2)*DJAC
         F(4) = B*F2*(F1+B*F2)
      ELSE IF(IORD.EQ.2) THEN
         F(1) = (F1+B*F3)*DJAC*DJAC
         F(2) = (F1+B*F2)*DJAC
         F(3) = (-F2+B*F4)*DJAC*DJAC
         F(4) = (F2+B*F1)*DJAC
      END IF
C
      END
C***********************************************************************
C     2 - D
C***********************************************************************
      SUBROUTINE SIFQ(X,Y,F,FX,FY,NPE)
C=======================================================================
C     Program to evaluate standard interpolation functions for quadrilat
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION F(*),FX(*),FY(*)
      XY=X*Y
C
C --- bilinear shape functions ---
C
      C=0.25
      F(1)=C*(1.-X-Y+XY)
      F(2)=C*(1.+X-Y-XY)
      F(3)=C*(1.+X+Y+XY)
      F(4)=C*(1.-X+Y-XY)
      FX(1)=C*(-1.+Y)
      FX(2)=-FX(1)
      FX(3)=C*(1.+Y)
      FX(4)=-FX(3)
      FY(1)=C*(-1.+X)
      FY(2)=C*(-1.-X)
      FY(3)=-FY(2)
      FY(4)=-FY(1)
C
C --- quadratic interpolation functions (serendipity/Lagrange) ---
C
      IF(NPE.GE.8) THEN
         B=0.5
         X2=2.*X
         Y2=2.*Y
         XY2=2.*XY
         XX=X*X
         YY=Y*Y
         XXY=XX*Y
         XYY=X*YY
         IF(NPE.EQ.9) THEN
            F(9)=(1.-XX)*(1.-YY)
            FX(9)=-X2*(1.-YY)
            FY(9)=-Y2*(1.-XX)
            DUM=C*F(9)
            F(1)=F(1)-DUM
            F(2)=F(2)-DUM
            F(3)=F(3)-DUM
            F(4)=F(4)-DUM
            DUM=C*FX(9)
            FX(1)=FX(1)-DUM
            FX(2)=FX(2)-DUM
            FX(3)=FX(3)-DUM
            FX(4)=FX(4)-DUM
            DUM=C*FY(9)
            FY(1)=FY(1)-DUM
            FY(2)=FY(2)-DUM
            FY(3)=FY(3)-DUM
            FY(4)=FY(4)-DUM
         ELSE
            F(9)=0.
            FX(9)=0.
            FY(9)=0.
         END IF
C
         F(5)=B*((1.-XX)*(1.-Y)-F(9))
         F(6)=B*((1.-YY)*(1.+X)-F(9))
         F(7)=B*((1.-XX)*(1.+Y)-F(9))
         F(8)=B*((1.-YY)*(1.-X)-F(9))
         DUM=B*FX(9)
         FX(5)=-X*(1.-Y)-DUM
         FX(6)=B*(1.-YY)-DUM
         FX(7)=-X*(1.+Y)-DUM
         FX(8)=-B*(1.-YY)-DUM
         DUM=B*FY(9)
         FY(5)=-B*(1.-XX)-DUM
         FY(6)=-Y*(1.+X)-DUM
         FY(7)=B*(1.-XX)-DUM
         FY(8)=-Y*(1.-X)-DUM
C
         F(1)=F(1)-B*(F(5)+F(8))
         F(2)=F(2)-B*(F(5)+F(6))
         F(3)=F(3)-B*(F(6)+F(7))
         F(4)=F(4)-B*(F(7)+F(8))
         FX(1)=FX(1)-B*(FX(5)+FX(8))
         FX(2)=FX(2)-B*(FX(5)+FX(6))
         FX(3)=FX(3)-B*(FX(6)+FX(7))
         FX(4)=FX(4)-B*(FX(7)+FX(8))
         FY(1)=FY(1)-B*(FY(5)+FY(8))
         FY(2)=FY(2)-B*(FY(5)+FY(6))
         FY(3)=FY(3)-B*(FY(6)+FY(7))
         FY(4)=FY(4)-B*(FY(7)+FY(8))
      END IF
C
      END
C***********************************************************************
      SUBROUTINE SIFT(SK,F,FX,FY,NOD)
C=======================================================================
C     Program to set up standard interpolation functions for triangles
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION SK(*),F(*),FX(*),FY(*)
C
      IF(NOD.EQ.3) THEN
         F(1)=SK(1)
         F(2)=SK(2)
         F(3)=SK(3)
C
         FX(1)=1.D0
         FX(2)=0.D0
         FX(3)=-1.D0
C
         FY(1)=0.D0
         FY(2)=1.D0
         FY(3)=-1.D0
      ELSE IF(NOD.EQ.6) THEN
         F(1)=SK(1)*(2.D0*SK(1)-1.D0)
         F(2)=SK(2)*(2.D0*SK(2)-1.D0)
         F(3)=SK(3)*(2.D0*SK(3)-1.D0)
         F(4)=4.D0*SK(1)*SK(2)
         F(5)=4.D0*SK(2)*SK(3)
         F(6)=4.D0*SK(3)*SK(1)
C
         FX(1)=4.D0*SK(1)-1.D0
         FX(2)=0.D0
         FX(3)=4.D0*(SK(1)+SK(2))-3.D0
         FX(4)=4.D0*SK(2)
         FX(5)=-4.D0*SK(2)
         FX(6)=4.D0*(1.D0-SK(2)-2.D0*SK(1))
C
         FY(1)=0.D0
         FY(2)=4.D0*SK(2)-1.D0
         FY(3)=4.D0*(SK(1)+SK(2))-3.D0
         FY(4)=4.D0*SK(1)
         FY(5)=4.D0*(1.D0-SK(1)-2.D0*SK(2))
         FY(6)=-4.D0*SK(1)
      END IF
C
      END
C***********************************************************************
      SUBROUTINE JACO2D(XY,DKSI,DETA,DNX,DNY,DET,NPE,N,IOUT)
C=======================================================================
C     Program to evaluate Jacobian of the isoparametric mapping
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION XY(NPE,*),DKSI(*),DETA(*),DNX(*),DNY(*)
C
      ZERO=1.0D-10
      XJ11=DDOT(NPE,DKSI,1,XY(1,1),1)
      XJ12=DDOT(NPE,DKSI,1,XY(1,2),1)
      XJ21=DDOT(NPE,DETA,1,XY(1,1),1)
      XJ22=DDOT(NPE,DETA,1,XY(1,2),1)
      DET=XJ11*XJ22-XJ12*XJ21
      IF(DET.LE.ZERO) THEN
         WRITE(IOUT,5000) N,DET
         WRITE(IOUT,5010) XJ11,XJ12,XJ21,XJ22
         WRITE(IOUT,5020)
         WRITE(IOUT,5030) (DKSI(I),DETA(I),XY(I,1),XY(I,2),I=1,NPE)
         STOP
      END IF
      DUM=1.0/DET
      DO 120 K=1,NPE
         DNX(K)=(DKSI(K)*XJ22-DETA(K)*XJ12)*DUM
         DNY(K)=(DETA(K)*XJ11-DKSI(K)*XJ21)*DUM
  120 CONTINUE
C
 5000 FORMAT(' *** ERROR *** NONPOSITIVE JACOBIAN FOR ELEMENT 'I5/,
     2       '               DETERMINANT 'E15.7/,
     3       '               ELEMENTS OF JACOBIAN MATRIX')
 5010 FORMAT(13X,2E15.7)
 5020 FORMAT('    DKSI        DETA        X           Y')
 5030 FORMAT(1X,4E12.3)
      END
C***********************************************************************
C     3 - D
C***********************************************************************
      SUBROUTINE SIF3D(X,Y,Z,P,DKSI,DETA,DZTA,NOD)
C=======================================================================
C     Program to set up 3-D standard interpolation functions
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION P(*),DKSI(*),DETA(*),DZTA(*)
      XY=X*Y
      XZ=X*Z
      YZ=Y*Z
      XYZ=X*Y*Z
C
C***  TRILINEAR SHAPE FUNCTIONS
C
      C=0.125D0
      P(1)=C*(1.-X-Y-Z+XY+XZ+YZ-XYZ)
      P(2)=C*(1.+X-Y-Z-XY-XZ+YZ+XYZ)
      P(3)=C*(1.+X+Y-Z+XY-XZ-YZ-XYZ)
      P(4)=C*(1.-X+Y-Z-XY+XZ-YZ+XYZ)
      P(5)=C*(1.-X-Y+Z+XY-XZ-YZ+XYZ)
      P(6)=C*(1.+X-Y+Z-XY+XZ-YZ-XYZ)
      P(7)=C*(1.+X+Y+Z+XY+XZ+YZ+XYZ)
      P(8)=C*(1.-X+Y+Z-XY-XZ+YZ-XYZ)
      DKSI(1)=C*(-1.+Y+Z-YZ)
      DKSI(2)=-DKSI(1)
      DKSI(3)=C*(1.+Y-Z-YZ)
      DKSI(4)=-DKSI(3)
      DKSI(5)=C*(-1.+Y-Z+YZ)
      DKSI(6)=-DKSI(5)
      DKSI(7)=C*(1.+Y+Z+YZ)
      DKSI(8)=-DKSI(7)
      DETA(1)=C*(-1.+X+Z-XZ)
      DETA(2)=C*(-1.-X+Z+XZ)
      DETA(3)=-DETA(2)
      DETA(4)=-DETA(1)
      DETA(5)=C*(-1.+X-Z+XZ)
      DETA(6)=C*(-1.-X-Z-XZ)
      DETA(7)=-DETA(6)
      DETA(8)=-DETA(5)
      DZTA(1)=C*(-1.+X+Y-XY)
      DZTA(2)=C*(-1.-X+Y+XY)
      DZTA(3)=C*(-1.-X-Y-XY)
      DZTA(4)=C*(-1.+X-Y+XY)
      DZTA(5)=-DZTA(1)
      DZTA(6)=-DZTA(2)
      DZTA(7)=-DZTA(3)
      DZTA(8)=-DZTA(4)
      IF(NOD.EQ.8) RETURN
C
C --- parabolic interpolation functions
C
      A=0.5D0
      B=0.25D0
      XX=X*X
      YY=Y*Y
      ZZ=Z*Z
      XXY=XX*Y
      XXZ=XX*Z
      XYY=X*YY
      XZZ=X*ZZ
      YYZ=YY*Z
      YZZ=Y*ZZ
      XXYZ=XXY*Z
      XYYZ=XYY*Z
      XYZZ=X*YZZ
      P(9)=B*(1.-Y-Z+YZ-XX+XXY+XXZ-XXYZ)
      P(10)=B*(1.+X-Z-XZ-YY-XYY+YYZ+XYYZ)
      P(11)=B*(1.+Y-Z-YZ-XX-XXY+XXZ+XXYZ)
      P(12)=B*(1.-X-Z+XY-YY+XYY+YYZ-XYYZ)
      P(13)=B*(1.-Y+Z-YZ-XX+XXY-XXZ+XXYZ)
      P(14)=B*(1.+X+Z+XZ-YY-XYY-YYZ-XYYZ)
      P(15)=B*(1.+Y+Z+YZ-XX-XXY-XXZ-XXYZ)
      P(16)=B*(1.-X+Z-XZ-YY+XYY-YYZ+XYYZ)
      P(17)=B*(1.-X-Y+XY-ZZ+XZZ+YZZ-XYZZ)
      P(18)=B*(1.+X-Y-XY-ZZ-XZZ+YZZ+XYZZ)
      P(19)=B*(1.+X+Y+XY-ZZ-XZZ-YZZ-XYZZ)
      P(20)=B*(1.-X+Y-XY-ZZ+XZZ-YZZ+XYZZ)
      P(1)=P(1)-A*(P(9)+P(12)+P(17))
      P(2)=P(2)-A*(P(9)+P(10)+P(18))
      P(3)=P(3)-A*(P(10)+P(11)+P(19))
      P(4)=P(4)-A*(P(11)+P(12)+P(20))
      P(5)=P(5)-A*(P(13)+P(16)+P(17))
      P(6)=P(6)-A*(P(13)+P(16)+P(17))
      P(7)=P(7)-A*(P(14)+P(15)+P(19))
      P(8)=P(8)-A*(P(15)+P(16)+P(20))
      DKSI(9)=A*(-X+XY+XZ-XYZ)
      DKSI(10)=B*(1.-Z-YY+YYZ)
      DKSI(11)=A*(-X-XY+XZ+XYZ)
      DKSI(12)=-DKSI(10)
      DKSI(13)=A*(-X+XY-XZ+XYZ)
      DKSI(14)=B*(1.+Z-YY-YYZ)
      DKSI(15)=A*(-X-XY-XZ-XYZ)
      DKSI(16)=-DKSI(14)
      DKSI(17)=B*(-1.+Y+ZZ-YZZ)
      DKSI(18)=-DKSI(17)
      DKSI(19)=B*(1.+Y-ZZ-YZZ)
      DKSI(20)=-DKSI(19)
      DKSI(1)=DKSI(1)-A*(DKSI(9)+DKSI(12)+DKSI(17))
      DKSI(2)=DKSI(2)-A*(DKSI(9)+DKSI(10)+DKSI(18))
      DKSI(3)=DKSI(3)-A*(DKSI(10)+DKSI(11)+DKSI(19))
      DKSI(4)=DKSI(4)-A*(DKSI(11)+DKSI(12)+DKSI(20))
      DKSI(5)=DKSI(5)-A*(DKSI(13)+DKSI(16)+DKSI(17))
      DKSI(6)=DKSI(6)-A*(DKSI(13)+DKSI(14)+DKSI(18))
      DKSI(7)=DKSI(7)-A*(DKSI(14)+DKSI(15)+DKSI(19))
      DKSI(8)=DKSI(8)-A*(DKSI(15)+DKSI(16)+DKSI(20))
      DETA(9)=B*(-1.+Z+XX-XXZ)
      DETA(10)=A*(-Y-XY+YZ+XYZ)
      DETA(11)=-DETA(9)
      DETA(12)=A*(-Y+XY+YZ-XYZ)
      DETA(13)=B*(-1.-Z+XX+XXZ)
      DETA(14)=A*(-Y-XY-YZ-XYZ)
      DETA(15)=-DETA(13)
      DETA(16)=A*(-Y+XY-YZ+XYZ)
      DETA(17)=B*(-1.+X+ZZ-XZZ)
      DETA(18)=B*(-1.-X+ZZ+XZZ)
      DETA(19)=-DETA(18)
      DETA(20)=-DETA(17)
      DETA(1)=DETA(1)-A*(DETA(9)+DETA(12)+DETA(17))
      DETA(2)=DETA(2)-A*(DETA(9)+DETA(10)+DETA(18))
      DETA(3)=DETA(3)-A*(DETA(10)+DETA(11)+DETA(19))
      DETA(4)=DETA(4)-A*(DETA(11)+DETA(12)+DETA(20))
      DETA(5)=DETA(5)-A*(DETA(13)+DETA(16)+DETA(17))
      DETA(6)=DETA(6)-A*(DETA(13)+DETA(14)+DETA(18))
      DETA(7)=DETA(7)-A*(DETA(14)+DETA(15)+DETA(19))
      DETA(8)=DETA(8)-A*(DETA(15)+DETA(16)+DETA(20))
      DZTA(9)=B*(-1.+Y+XX-XXY)
      DZTA(10)=B*(-1.-X+YY+XYY)
      DZTA(11)=B*(-1.-Y+XX+XXY)
      DZTA(12)=B*(-1.+X+YY-XYY)
      DZTA(13)=-DZTA(9)
      DZTA(14)=-DZTA(10)
      DZTA(15)=-DZTA(11)
      DZTA(16)=-DZTA(12)
      DZTA(17)=A*(-Z+XZ+YZ-XYZ)
      DZTA(18)=A*(-Z-XZ+YZ+XYZ)
      DZTA(19)=A*(-Z-XZ-YZ-XYZ)
      DZTA(20)=A*(-Z+XZ-YZ+XYZ)
      DZTA(1)=DZTA(1)-A*(DZTA(9)+DZTA(12)+DZTA(17))
      DZTA(2)=DZTA(2)-A*(DZTA(9)+DZTA(19)+DZTA(18))
      DZTA(3)=DZTA(3)-A*(DZTA(10)+DZTA(11)+DZTA(19))
      DZTA(4)=DZTA(4)-A*(DZTA(11)+DZTA(12)+DZTA(20))
      DZTA(5)=DZTA(5)-A*(DZTA(13)+DZTA(16)+DZTA(17))
      DZTA(6)=DZTA(6)-A*(DZTA(13)+DZTA(14)+DZTA(18))
      DZTA(7)=DZTA(7)-A*(DZTA(14)+DZTA(15)+DZTA(19))
      DZTA(8)=DZTA(8)-A*(DZTA(15)+DZTA(16)+DZTA(20))
C
      END
C***********************************************************************
      SUBROUTINE JACO3D(XYZ,DKSI,DETA,DZTA,DNX,DNY,DNZ,DET,NPE,N,IOUT)
C=======================================================================
C     Program to evaluate the Jacobian for a 3-D solid element
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (ZERO=1.E-16)
      DIMENSION XYZ(NPE,*),DKSI(*),DETA(*),DZTA(*)
      DIMENSION DNX(*),DNY(*),DNZ(*)
C
      XJ11=DDOT(NPE,DKSI,1,XYZ(1,1),1)
      XJ12=DDOT(NPE,DKSI,1,XYZ(1,2),1)
      XJ13=DDOT(NPE,DKSI,1,XYZ(1,3),1)
      XJ21=DDOT(NPE,DETA,1,XYZ(1,1),1)
      XJ22=DDOT(NPE,DETA,1,XYZ(1,2),1)
      XJ23=DDOT(NPE,DETA,1,XYZ(1,3),1)
      XJ31=DDOT(NPE,DZTA,1,XYZ(1,1),1)
      XJ32=DDOT(NPE,DZTA,1,XYZ(1,2),1)
      XJ33=DDOT(NPE,DZTA,1,XYZ(1,3),1)
C
      DET=XJ11*(XJ22*XJ33-XJ23*XJ32)-XJ12*(XJ21*XJ33-XJ23*XJ31)+
     &    XJ13*(XJ21*XJ32-XJ22*XJ31)
C
      IF(DET.LT.ZERO) THEN
         WRITE(IOUT,5000) N,DET
         WRITE(IOUT,5010) XJ11,XJ12,XJ13,XJ21,XJ22,XJ23,XJ31,XJ32,XJ33
         WRITE(IOUT,5020)
         WRITE(IOUT,5030)
     &        (DKSI(I),DETA(I),DZTA(I),(XYZ(I,J),J=1,3),I=1,NPE)
         STOP
      END IF
C
      DUM=1.0/DET
      XI11=DUM*(XJ22*XJ33-XJ23*XJ32)
      XI12=DUM*(XJ23*XJ31-XJ21*XJ33)
      XI13=DUM*(XJ21*XJ32-XJ22*XJ31)
      XI21=DUM*(XJ13*XJ32-XJ12*XJ33)
      XI22=DUM*(XJ11*XJ33-XJ13*XJ31)
      XI23=DUM*(XJ12*XJ31-XJ11*XJ32)
      XI31=DUM*(XJ12*XJ23-XJ13*XJ22)
      XI32=DUM*(XJ13*XJ21-XJ11*XJ23)
      XI33=DUM*(XJ11*XJ22-XJ12*XJ21)
      DO 120 K=1,NPE
      DNX(K)=DKSI(K)*XI11+DETA(K)*XI12+DZTA(K)*XI13
      DNY(K)=DKSI(K)*XI21+DETA(K)*XI22+DZTA(K)*XI23
      DNZ(K)=DKSI(K)*XI31+DETA(K)*XI32+DZTA(K)*XI33
  120 CONTINUE
C
C
 5000 FORMAT(' *** ERROR *** JACOBIAN SINGULAR FOR ELEMENT 'I5/,
     &       '               DETERMINANT 'E15.7/,
     &       '               ELEMENTS OF JACOBIAN MATRIX')
 5010 FORMAT(13X,3E15.7)
 5020 FORMAT('    DKSI        DETA        DZTA        X           Y',
     &       '           Z')
 5030 FORMAT(1X,6E12.3)
      END
C***********************************************************************
