C***********************************************************************
      SUBROUTINE HIF2D(XY,SK,F,FGX,FGY
     &     ,FLX,FLY,DET,ISH,NGE,NFI,N,IOUT)
C======================================================================
C     Program to get the hierarchic interpolation functions in 2-D 
C-----------------------------------------------------------------------
C     XY          = nodal point X and Y coordinates
C     SK          = integration point coordinates
C     F, FGX, FGY = function and its derivatives values in global coord
C     FLX, FLY    = derivatives of int. f. in local coordinates
C     DET         = determinat of the Jacobian
C     ISH         = flag for element shape (0 = quad, 1 = tria)
C     NGE         = number of nodes in geometry interpolation
C     NFI         = number of nodes in function interpolation
C     N           = element number
C     IOUT        = output unit
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION XY(*),SK(*),F(*),FGX(*),FGY(*),FLX(*),FLY(*)
      DIMENSION AJI(2,2)
C
      IF(ISH.EQ.0) THEN
         X=SK(1)
         Y=SK(2)
         CALL HIFQ(F,FLX,FLY,X,Y,NFI)
      ELSE
         CALL HIFT(SK,F,FLX,FLY,NFI)
      END IF
C
      CALL JACO2I(XY,FLX,FLY,AJI,DET,NGI,N,IOUT)
      CALL SFDGL(FGX,FGY,FLX,FLY,AJI,NFI)
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE JACO2I(XY,DKSI,DETA,AJI,DET,NPE,N,IOUT)
C=======================================================================
C     Program to evaluate the inverse of Jacobian 
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION XY(2,*),DKSI(1),DETA(1),AJI(2,2)
C
      ZERO=1.0D-10
      XJ11=DDOT(NPE,DKSI,1,XY,1)
      XJ12=DDOT(NPE,DKSI,1,XY(1,2),1)
      XJ21=DDOT(NPE,DETA,1,XY,1)
      XJ22=DDOT(NPE,DETA,XY(1,2),1)
      DET=XJ11*XJ22-XJ12*XJ21
C
      IF(DET.LE.ZERO) THEN
         WRITE(IOUT,5000) N,DET
         WRITE(IOUT,5010) XJ11,XJ12,XJ21,XJ22
         WRITE(IOUT,5020)
         WRITE(IOUT,5030) (DKSI(I),DETA(I),XY(I,1),XY(I,2),I=1,NPE)
         STOP
      END IF
C
      DUM=1.0/DET
      CHAN=XJ11
      AJI(1,1)=XJ22*DUM
      AJI(1,2)=-XJ12*DUM
      AJI(2,1)=-XJ21*DUM
      AJI(2,2)=CHAN*DUM
C
      RETURN
 5000 FORMAT(' *** ERROR *** NONPOSITIVE JACOBIAN FOR ELEMENT 'I5/,
     2       '               DETERMINANT 'E15.7/,
     3       '               ELEMENTS OF JACOBIAN MATRIX')
 5010 FORMAT(13X,2E15.7)
 5020 FORMAT('    DKSI        DETA        X           Y')
 5030 FORMAT(1X,4E12.3)
      END
C***********************************************************************
v      SUBROUTINE SFDGL(SFX,SFY,SFXI,SFET,AJI,NR)
C=======================================================================
C     Program to get the shape function derivatives in global coord.
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION SFX(*),SFY(*),SFXI(*),SFET(*),AJI(2,2)
C
      DO 280 I=1,NR
         SFX(I)=SFXI(I)*AJI(1,1)+SFET(I)*AJI(1,2)
         SFY(I)=SFXI(I)*AJI(2,1)+SFET(I)*AJI(2,2)
 280  CONTINUE
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE HIFQ(F,FX,FY,X,Y,NPE)
C=======================================================================
C     Program to set up hierarchical family of 2-D C-0 shape functions
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION F(1),FX(1),FY(1)
C
      C=0.25
      XY=X*Y
      F(1)=C*(1.-X-Y+XY)
      F(2)=C*(1.+X-Y-XY)
      F(3)=C*(1.+X+Y+XY)
      F(4)=C*(1.-X+Y-XY)
      FX(1)=C*(-1.+Y)
      FX(2)=-FX(1)
      FX(3)=C*(1.+Y)
      FX(4)=-FX(3)
      FY(1)=C*(-1.+X)
      FY(2)=C*(-1.-X)
      FY(3)=-FY(2)
      FY(4)=-FY(1)
C
      IF(NPE.GE.8) THEN
         B=0.5
         X2=2.*X
         Y2=2.*Y
         XY2=2.*XY
         XX=X*X
         YY=Y*Y
         XXY=XX*Y
         XYY=X*YY
         F(5)=B*(1.-Y-XX+XXY)
         F(6)=B*(1.+X-YY-XYY)
         F(7)=B*(1.+Y-XX-XXY)
         F(8)=B*(1.-X-YY+XYY)
         FX(5)=-X+XY
         FX(6)=B*(1.-YY)
         FX(7)=-X-XY
         FX(8)=B*(-1.+YY)
         FY(5)=B*(-1.+XX)
         FY(6)=-Y-XY
         FY(7)=B*(1.-XX)
         FY(8)=-Y+XY
         IF(NPE.EQ.9) THEN
            F(9)=(1.-XX)*(1.-YY)
            FX(9)=-X2*(1.-YY)
            FY(9)=-Y2*(1.-XX)
         END IF
      END IF         
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE HIFT(SK,F,FX,FY,NOD)
C=======================================================================
C     Program to set up interpolation functions for triangles
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION SK(1),F(1),FX(1),FY(1)
C
      F(1)=SK(1)
      F(2)=SK(2)
      F(3)=SK(3)
C
      FX(1)= 1.D0
      FX(2)= 0.D0
      FX(3)=-1.D0
C
      FY(1)= 0.D0
      FY(2)= 1.D0
      FY(3)=-1.D0
C
      IF(NOD.EQ.6) THEN
         F(4)=4.D0*SK(1)*SK(2)
         F(5)=4.D0*SK(2)*SK(3)
         F(6)=4.D0*SK(3)*SK(1)
C
         FX(4)= 4.D0*SK(2)
         FX(5)=-4.D0*SK(2)
         FX(6)= 4.D0*(1.D0-SK(2)-2.D0*SK(1))
C
         FY(4)= 4.D0*SK(1)
         FY(5)= 4.D0*(1.D0-SK(1)-2.D0*SK(2))
         FY(6)=-4.D0*SK(1)
      END IF
C
      RETURN
      END
C****-END-OF-FILE-******************************************************
