C=======================================================================
C***********************************************************************
C     Simple Finite Element program HFEM
C     Version MAY-2002
C-----------------------------------------------------------------------
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C-----------------------------------------------------------------------
C     The program is made for teaching purpose and is a suplement to the
C     lecture notes -- 
C     Reijo Kouhia and Markku Tuomala: Rakenteiden Mekaniikan Numeeriset
C     Menetelmt (= Numerical Methods in Structural Mechanics)
C-----------------------------------------------------------------------
C     Comments and error reports are kindly asked to be send to the 
C     authors, e-mail:  reijo.kouhia@hut.fi
C-----------------------------------------------------------------------     
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C-----------------------------------------------------------------------
C     DISCLAIMER:
C-----------------------------------------------------------------------
C     This program is provided as is, with no warranty of any kind.  
C     The author/contributors of this software are not liable for 
C     any loss/damage or inconvenience caused in the use of this 
C     software. Responsibility for ensuring the accuracy of the results, 
C     and the suitability of the program for any particular purpose
C     rests solely with the user. 
C***********************************************************************
C=======================================================================
      PROGRAM HFEM
      IMPLICIT NONE
      INTEGER          MA,MIA,MTIT,MU
      PARAMETER       (MA=3000000,MU=300000,MIA=5000000,MTIT=10)
      INTEGER          IA(MIA)
      DOUBLE PRECISION A(MA),F(MU),U(MU)
      CHARACTER*78     TITLE(MTIT)
C
      CALL INITIO
      CALL TIMING('BEGIN')
      CALL PUTIPA('MPARA','MA   ',MA,0)
      CALL PUTIPA('MPARA','MIA  ',MIA,0)
      CALL PUTIPA('MPARA','MU   ',MU,0)
      CALL PUTIPA('MPARA','MTIT ',MTIT,0)
C
      CALL HFEM1(A,U,F,IA,TITLE)
C
      CALL EPILOG
C
      STOP
      END
C***********************************************************************
      SUBROUTINE HFEM1(A,U,F,IA,TITLE)
C=======================================================================
C     Global driver program 
C=======================================================================
      IMPLICIT NONE
      CHARACTER*78     TASK,TITLE(*)
      INTEGER          IA(*)
      DOUBLE PRECISION A(*),U(*),F(*)
C --- locals -----------------------------------------------------------
      INTEGER          IOUT,IPLOT,IODEV
C
      CALL TIMING('START')
      CALL TIMING('OVERH')
C
      IOUT  = IODEV('OUTPU')
      IPLOT = IODEV('PLOT')
      CALL HEADER(6)
      CALL HEADER(IOUT)
      CALL HEADER(IPLOT)
C
C --- read input data ---
C
      CALL RDATA(IA,TASK,TITLE)
C
C --- call analysis routines ---
C
      IF(INDEX(TASK,'STAT').NE.0) THEN
         CALL STAT(A,U,F,IA)
      END IF
C
      END
C***********************************************************************
      SUBROUTINE STAT(A,U,F,IA)
C=======================================================================
C     Program for stationary analysis
C=======================================================================
      IMPLICIT NONE
      DOUBLE PRECISION A(*),U(*),F(*)
      INTEGER          IA(*)
C --- local variables 
      INTEGER          IP(10),IODEV,IGETPA
      DOUBLE PRECISION FP(10)
      INTEGER          IOUT,NEQ,NBAND,IMETH,ISYM
      CHARACTER*78     TASK
C
      IOUT  = IODEV('OUTPU')
      NEQ   = IGETPA('NSPAR','NEQ  ',0)
      NBAND = IGETPA('NSPAR','NBAND',0)
      IMETH = IGETPA('NSPAR','IMETH',0)
      ISYM  = IGETPA('NSPAR','ISYM ',0)
C
C
C --- form the global matrix and force vector ---
C
      WRITE(IOUT,5100)
      WRITE(*,5100)
      TASK = 'FORM-MATRIX'
      CALL TIMING('START')
      CALL ELEMNT(A,U,F,IA,TASK)
      CALL TIMING('TIELE')
      WRITE(IOUT,5200)
      WRITE(*,5200)
C
      CALL FORCE(F)
      TASK = 'ADD-ELEMENT-LOADS'
      CALL ELEMNT(A,U,F,IA,TASK)
C
C --- solve the equilibrium equations ---
C
      WRITE(IOUT,5300)
      WRITE(*,5300)
      CALL TIMING('START')
C
      IF(IMETH.LT.100) THEN
         CALL DIRSOL(A,U,F,IA,NEQ,NBAND,IMETH,ISYM,1,IOUT)
      ELSE
         CALL ITESOL(A,U,F,IA,IOUT)
      END IF
C
      CALL TIMING('TISOL')
C
C --- compute and output results
C
      WRITE(IOUT,5400)
      WRITE(*,5400)
      CALL OUTPRI(U)
      TASK = 'COMPUTE'
      CALL TIMING('START')
      CALL ELEMNT(A,U,F,IA,TASK)
      CALL TIMING('TISTR')
C
 5100 FORMAT(' Start forming global matrix ')
 5200 FORMAT(' Global matrix assembled')
 5300 FORMAT(' Start solving equation system')
 5400 FORMAT(' Start computing stresses/fluxes')
      END
C***********************************************************************
      SUBROUTINE HEADER(IUNIT)
C=======================================================================
C     Program to output program header
C=======================================================================
C
      IMPLICIT NONE
      INTEGER IUNIT,I
C
      WRITE(IUNIT,'(1X,78A1)') ('*',I=1,78)
      WRITE(IUNIT,'(1X,78A1)') ('=',I=1,78)
      WRITE(IUNIT,5000)
      WRITE(IUNIT,'(1X,78A1)') ('=',I=1,78)
      WRITE(IUNIT,'(1X,78A1)') ('*',I=1,78)
C
 5000 FORMAT(' Simple FEM program (Version -- MAY 2002)')
      END
C***********************************************************************
      SUBROUTINE TIMING(LABEL)
C=======================================================================
C     Program to get CPU-time use
C-----------------------------------------------------------------------
C     **************************************************************
C     ****** NOTE ***** THIS IS A SYSTEM DEPENDENT ROUTINE *********
C     **************************************************************
C-----------------------------------------------------------------------
C     Routine:  ETIME  used in Unix computers
C=======================================================================
      IMPLICIT NONE
      REAL             TIME1(2)
      DOUBLE PRECISION FGETPA,TISTA,TILOG,TOVER
      CHARACTER*5      LABEL
C
C-----------------------------------------------------------------------
      CALL ETIME(TIME1)
C-----------------------------------------------------------------------
C     OVERH - calculate overhead time 
C     TIINP - time used in input reading etc.
C     TIDPR - time used in input data processing
C     TIELE - time used in system matrix formation
C     TISOL - time used in solving equations
C     TISTR - time used in stress computations 
C-----------------------------------------------------------------------
      IF(LABEL.EQ.'BEGIN') THEN
         TILOG=REAL(TIME1(1))
         CALL PUTFPA('FPARA','BEGIN',TILOG,0)
      ELSE IF(LABEL.EQ.'START') THEN
         TILOG=REAL(TIME1(1))
         CALL PUTFPA('FPARA','START',TILOG,0)
      ELSE 
         TISTA=FGETPA('FPARA','START',0)
         TOVER=FGETPA('FPARA','OVERH',0)
         IF(LABEL.EQ.'OVERH') THEN
            TILOG=REAL(TIME1(1))-TISTA
            CALL PUTFPA('FPARA','OVERH',TILOG,0)
         ELSE IF(LABEL.EQ.'TIINP') THEN
            TILOG=REAL(TIME1(1))-TISTA-TOVER
            CALL PUTFPA('FPARA','TIINP',TILOG,0)
         ELSE IF(LABEL.EQ.'TIDPR') THEN
            TILOG=REAL(TIME1(1))-TISTA-TOVER
            CALL PUTFPA('FPARA','TIDPR',TILOG,0)
         ELSE IF(LABEL.EQ.'TIELE') THEN
            TILOG=REAL(TIME1(1))-TISTA-TOVER
            CALL PUTFPA('FPARA','TIELE',TILOG,0)
         ELSE IF(LABEL.EQ.'TISOL') THEN
            TILOG=REAL(TIME1(1))-TISTA-TOVER
            CALL PUTFPA('FPARA','TISOL',TILOG,0)
         ELSE IF(LABEL.EQ.'TISTR') THEN
            TILOG=REAL(TIME1(1))-TISTA-TOVER
            CALL PUTFPA('FPARA','TISTR',TILOG,0)
         ELSE IF(LABEL.EQ.'TOTAL') THEN	
C --------- total CPU time --------
            TISTA=FGETPA('FPARA','BEGIN',0)
            TILOG=REAL(TIME1(1))-TISTA-TOVER
            CALL PUTFPA('FPARA','TOTAL',TILOG,0)
         END IF
      END IF
C
      END
C***********************************************************************
      SUBROUTINE EPILOG
C=======================================================================
C     Program to print CPU-time information and close output files
C=======================================================================
      IMPLICIT NONE
      DOUBLE PRECISION EPS,TOTAL,TILOG,CE,FGETPA
      PARAMETER       (EPS=1.E-15,CE=100.D0)
      INTEGER          I,IOUT,IMESH,IPLOT,IODEV
      CHARACTER*21     LABEL
C
      IMESH = IODEV('MESH')
      IPLOT = IODEV('PLOT')
      CLOSE(UNIT=IMESH)
      CLOSE(UNIT=IPLOT)
C
      IOUT  = IODEV('OUTPU')
C      
      LABEL = '  % OF TOTAL CPU-TIME'
      CALL TIMING('TOTAL')
C
      TOTAL = FGETPA('FPARA','TOTAL',0)
      WRITE(IOUT,'(1X,78A1)') ('=',I=1,78)
      WRITE(IOUT,5000)
      WRITE(IOUT,'(1X,78A1)') ('-',I=1,78)
C
      WRITE(*,'(1X,78A1)') ('=',I=1,78)
      WRITE(*,5000)
      WRITE(*,'(1X,78A1)') ('-',I=1,78)
C
      TILOG = FGETPA('FPARA','TIINP',0)
      IF(TILOG.GT.EPS) THEN
         WRITE(IOUT,5120) TILOG,CE*TILOG/TOTAL,LABEL
         WRITE(*,5120) TILOG,CE*TILOG/TOTAL,LABEL
      END IF
C
      TILOG = FGETPA('FPARA','TIDPR',0)
      IF(TILOG.GT.EPS) THEN
         WRITE(IOUT,5140) TILOG,CE*TILOG/TOTAL,LABEL
         WRITE(*,5140) TILOG,CE*TILOG/TOTAL,LABEL
      END IF
C
      TILOG = FGETPA('FPARA','TIELE',0)
      IF(TILOG.GT.EPS) THEN
         WRITE(IOUT,5160) TILOG,CE*TILOG/TOTAL,LABEL
         WRITE(*,5160) TILOG,CE*TILOG/TOTAL,LABEL
      END IF
C
      TILOG = FGETPA('FPARA','TISOL',0)
      IF(TILOG.GT.EPS) THEN
         WRITE(IOUT,5180) TILOG,CE*TILOG/TOTAL,LABEL
         WRITE(*,5180) TILOG,CE*TILOG/TOTAL,LABEL
      END IF
C
      TILOG = FGETPA('FPARA','TISTR',0)
      IF(TILOG.GT.EPS) THEN
         WRITE(IOUT,5200) TILOG,CE*TILOG/TOTAL,LABEL
         WRITE(*,5200) TILOG,CE*TILOG/TOTAL,LABEL
      END IF
C
      WRITE(IOUT,'(1X,78A1)') ('-',I=1,78)
      WRITE(IOUT,6000) TOTAL
      WRITE(IOUT,'(1X,78A1)') ('=',I=1,78)
C
      WRITE(*,'(1X,78A1)') ('-',I=1,78)
      WRITE(*,6000) TOTAL
      WRITE(*,'(1X,78A1)') ('=',I=1,78)
C
 5000 FORMAT(' C P U  -  T I M E    I N F O R M A T I O N')
 5120 FORMAT(' READING INPUT DATA         ',F10.4,' SEC,  ',F6.2,A21)
 5140 FORMAT(' PROCESSING INPUT DATA      ',F10.4,' SEC,  ',F6.2,A21)
 5160 FORMAT(' FORMING GLOBAL MATRIX      ',F10.4,' SEC,  ',F6.2,A21)
 5180 FORMAT(' EQUATION SOLUTION          ',F10.4,' SEC,  ',F6.2,A21)
 5200 FORMAT(' STRESS COMPUTATION         ',F10.4,' SEC,  ',F6.2,A21)
 6000 FORMAT(' TOTAL USE OF CPU-TIME      ',F10.4,' SECONDS')
      END
C***********************************************************************
      SUBROUTINE OUTPRI(GU)
C=======================================================================
C     Program to output primal variables
C=======================================================================
      IMPLICIT NONE
      DOUBLE PRECISION GU(*)
C --- local variables --------------------------------------------------
      INTEGER          MT,I,ID,IOUT,IPLOT,J,NNOD,NDOF,IODEV,IGETPA
      PARAMETER       (MT=6)
      INTEGER          LD(MT)
      DOUBLE PRECISION TEMP(MT)
C
      ID    = IODEV('IDARR')
      IOUT  = IODEV('OUTPU')
      IPLOT = IODEV('PLOT ')
      NNOD  = IGETPA('NSPAR','NNOD ',0)
      NDOF  = IGETPA('NSPAR','NDOF ',0)
C
      WRITE(IPLOT,'(''  Node  Values of primary variable '')')
C
      DO 120 I = 1, NNOD
         CALL FZERO(TEMP,NDOF)
         READ(ID,REC=I) (LD(J), J = 1, NDOF)
C
         DO 100 J = 1, NDOF
            IF(LD(J).GT.0) TEMP(J) = GU(LD(J))
 100     CONTINUE
C
         WRITE(IPLOT,'(1X,I6,6(1P,E12.4))') I,(TEMP(J),J=1,NDOF)
 120  CONTINUE
C
      WRITE(IPLOT,'(1X,78A1)') ('=',I=1,78)
C
      END
C***********************************************************************
      SUBROUTINE FORCE(GF)
C=======================================================================
C     Program to form the force (or source) vector 
C=======================================================================
C	USE IMSL
      IMPLICIT NONE
      DOUBLE PRECISION GF(*)
C --- local variables --------------------------------------------------
      INTEGER          MT,ID,IDOF,ILOAD,NDOF,NODE,NCF,I,J,K,IGETPA,IODEV
     &                  ,IOUT,NEQ
      PARAMETER       (MT=6)
      INTEGER          LD(MT)
      DOUBLE PRECISION FF
C
      ID    = IODEV('IDARR')
      IOUT  = IODEV('OUTPU')
      ILOAD = IODEV('CLOAD')
      NDOF  = IGETPA('NSPAR','NDOF ',0)
      NCF   = IGETPA('NSPAR','NCFOR',0)
      NEQ   = IGETPA('NSPAR','NEQ  ',0)
C
      DO I = 1, NCF
         READ(ILOAD,REC=I) NODE,IDOF,FF
         READ(ID,REC=NODE) (LD(J),J=1,NDOF)
         K     = LD(IDOF)
	   IF((K.GT.0).AND.(K.LE.NEQ)) THEN
            GF(K) = GF(K) + FF
	   ELSE
	      WRITE(IOUT,5000) NODE,IDOF
	      WRITE(*,5000) NODE,IDOF
	   END IF
      END DO	
C
 5000 FORMAT(' ** NOTE from routine FORCE, force data ',2I7)
      END
C***********************************************************************
