C***********************************************************************
      SUBROUTINE GNODES(LABEL,IIN,IOUT,IECHO,IEND)
C=======================================================================
C     Program to read and generate nodal point coordinates
C-----------------------------------------------------------------------
C     N       = node number
C     NUMGP   = number of generation points
C     NINC(I) = number of increments for direction I
C     INC(I)  = increment for direction I
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (MT=6,MP=20,MC=3)
      DIMENSION NINC(MC),INC(MC),TEMP(MT,MP)
      CHARACTER*78 LABEL
C     ------------	
      ICOOR=IODEV('COORD')
      CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
      IF(IEND.GT.0) RETURN
      READ(LABEL,*,END=4000,ERR=4000) NDIM
      CALL PUTIPA('NSPAR','NDIM  ',NDIM,0)
 100  CONTINUE
      CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
      IF(IEND.GT.0) RETURN
      IF(INDEX(LABEL,'END').NE.0) THEN
         CALL PUTIPA('NSPAR','NNOD ',NP,0)
         RETURN
      END IF
      CALL FZERO(TEMP,MT*MP)
      READ(LABEL,*,END=4000,ERR=4000) N,NUMGP,IOPT,(TEMP(I,1),I=1,NDIM)
	WRITE(*,'('' Generating nodes, starting from node '',I8)') N
      WRITE(ICOOR,REC=N) (TEMP(I,1),I=1,NDIM)
      IF (NUMGP.NE.0) THEN
         DO 200 J=2,NUMGP
            CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
            IF(IEND.GT.0) RETURN
            READ(LABEL,*,END=4000,ERR=4000) M,MGEN,(TEMP(I,J),I=1,NDIM)
            IF(M.GT.NP) NP=M
            IF (MGEN.NE.0) THEN
               WRITE(ICOOR,REC=M) (TEMP(I,J),I=1,NDIM)
            END IF
 200     CONTINUE
         CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
         IF(IEND.GT.0) RETURN
         CALL IZERO(NINC,MC)
         CALL IZERO(INC,MC)
         READ(LABEL,*,END=4000,ERR=4000) (NINC(I),INC(I),I=1,IOPT)
         CALL GENFL(ICOOR,TEMP,NINC,INC,NDIM,MT,N,NUMGP,IOPT)
         NN=N
         DO 240 L=1,IOPT
            NN=NN+NINC(L)*INC(L)
 240     CONTINUE
         IF(NN.GT.NP) NP=NN
      END IF
      GOTO 100
 4000 WRITE(IOUT,5000)
 5000 FORMAT(' *** ERROR *** IN GNODES ')
      STOP 
      END
C***********************************************************************
      SUBROUTINE GENFL(IFILE,TEMP,NINC,INC,NDIM,MT,N,NUMGP,IOPT)
C=======================================================================
C     Program to generate floating-point nodal
C     data via isoparametric interpolation
C-----------------------------------------------------------------------
C     IOPT = 1, generation along a line
C          = 2, generation over a surface
C          = 3, generation within a volume
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION CN(3),SH(20),TEMP(MT,1),NINC(1),INC(1)
      ZERO=0.
      ONE=1.
      TWO=2.
C
      DR = ZERO
      DS = ZERO
      DT = ZERO
C
      IF (NINC(1).NE.0) DR = TWO/NINC(1)
      IF (NINC(2).NE.0) DS = TWO/NINC(2)
      IF (NINC(3).NE.0) DT = TWO/NINC(3)
C
      II = NINC(1)+1
      JJ = NINC(2)+1
      KK = NINC(3)+1
C
      NI = N
      NJ = N
      NK = N
C
      T = -ONE
      DO 400 K=1,KK
         S = -ONE
         DO 300 J=1,JJ
            R = -ONE
            DO 200 I=1,II
               CALL GENSH(R,S,T,SH,NUMGP,IOPT)
               CALL FZERO(CN,NDIM)
               CALL MULTF(CN,TEMP,SH,MT,NDIM,NUMGP)
               WRITE(IFILE,REC=NI) (CN(L),L=1,NDIM)
               NI = NI + INC(1)
               R = R + DR
 200        CONTINUE
            NJ = NJ + INC(2)
            NI = NJ
            S = S + DS
 300     CONTINUE
         NK = NK + INC(3)
         NI = NK
         T = T + DT
 400  CONTINUE
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE GENSH(R,S,T,SH,NUMGP,IOPT)
C=======================================================================
C     Program to call shape function routines
C     for isoparametric generation
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION SH(1)
C
      IF(IOPT.EQ.1) THEN
         CALL GENSH1(R,SH,NUMGP)
      ELSE IF(IOPT.EQ.2) THEN
         CALL GENSH2(R,S,SH,NUMGP)
      ELSE IF(IOPT.EQ.3) THEN
         CALL GENSH3(R,S,T,SH,NUMGP)
      END IF
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE GENSH1(R,SH,N)
C=======================================================================
C     Program to compute 1D shape functions
C     for isoparametric generation
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION SH(1)
      PT5=.5
      ONE=1.
C
      SH(2) = PT5*R
      SH(1) = PT5 - SH(2)
      SH(2) = PT5 + SH(2)
      IF (N.EQ.3) THEN
         SH(3) = ONE - R*R
         SH(1) = SH(1) - PT5*SH(3)
         SH(2) = SH(2) - PT5*SH(3)
      ELSE IF(N.EQ.4) THEN
         DUM1 = 9./16.
         DUM2 = 27./16.
         S1 = R + 1.
         S2 = R + 1./3.
         S3 = R - 1./3.
         S4 = R - 1.
         SH(1) = -DUM1*S2*S3*S4
         SH(2) = DUM1*S1*S2*S3
         SH(3) = DUM2*S1*S3*S4
         SH(4) = -DUM2*S1*S2*S4
      END IF
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE GENSH2(R,S,SH,N)
C=======================================================================
C     Program to compute 2D shape functions
C     for isoparametric generation
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION SH(1)
      PT5=.5
      ONE=1.
C
      R2 = PT5*R
      R1 = PT5 - R2
      R2 = PT5 + R2
      S2 = PT5*S
      S1 = PT5 - S2
      S2 = PT5 + S2
      SH(1) = R1*S1
      SH(2) = R2*S1
      SH(3) = R2*S2
      SH(4) = R1*S2
      IF (N.EQ.4) RETURN
C
      R3 = ONE - R*R
      S3 = ONE - S*S
      SH(5) = R3*S1
      SH(6) = S3*R2
      SH(7) = R3*S2
      SH(8) = S3*R1
      SH(1) = SH(1) - PT5*(SH(5) + SH(8))
      SH(2) = SH(2) - PT5*(SH(6) + SH(5))
      SH(3) = SH(3) - PT5*(SH(7) + SH(6))
      SH(4) = SH(4) - PT5*(SH(8) + SH(7))
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE GENSH3(R,S,T,SH,N)
C=======================================================================
C     Program to compute 3D shape functions
C     for isoparametric generation
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION SH(1)
C
      R2 = .5*R
      R1 = .5 - R2
      R2 = .5 + R2
      S2 = .5*S
      S1 = .5 - S2
      S2 = .5 + S2
      T2 = .5*T
      T1 = .5 - T2
      T2 = .5 + T2
C
      RS1 = R1*S1
      RS2 = R2*S1
      RS3 = R2*S2
      RS4 = R1*S2
      SH(1) = RS1*T1
      SH(2) = RS2*T1
      SH(3) = RS3*T1
      SH(4) = RS4*T1
      SH(5) = RS1*T2
      SH(6) = RS2*T2
      SH(7) = RS3*T2
      SH(8) = RS4*T2
      IF (N.EQ.8) RETURN
C
      R3 = 1. - R*R
      S3 = 1. - S*S
      T3 = 1. - T*T
      SH(17) = T3*RS1
      SH(18) = T3*RS2
      SH(19) = T3*RS3
      SH(20) = T3*RS4
      RS1 = R3*S1
      RS2 = S3*R2
      RS3 = R3*S2
      RS4 = S3*R1
      SH( 9) = RS1*T1
      SH(10) = RS2*T1
      SH(11) = RS3*T1
      SH(12) = RS4*T1
      SH(13) = RS1*T2
      SH(14) = RS2*T2
      SH(15) = RS3*T2
      SH(16) = RS4*T2
C
      SH(1) = SH(1) - .5*(SH( 9) + SH(12) + SH(17))
      SH(2) = SH(2) - .5*(SH( 9) + SH(10) + SH(18))
      SH(3) = SH(3) - .5*(SH(10) + SH(11) + SH(19))
      SH(4) = SH(4) - .5*(SH(11) + SH(12) + SH(20))
      SH(5) = SH(5) - .5*(SH(13) + SH(16) + SH(17))
      SH(6) = SH(6) - .5*(SH(13) + SH(14) + SH(18))
      SH(7) = SH(7) - .5*(SH(14) + SH(15) + SH(19))
      SH(8) = SH(8) - .5*(SH(15) + SH(16) + SH(20))
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE GENEL(LABEL,IIN,IOUT,NENOD,IECHO,IEND,IA,NNOD)
C=======================================================================
C     Program to read and generate element node and material numbers
C-----------------------------------------------------------------------
C     N              = element number
C     NG             = generation parameter
C     NEL(I)         = number of elements in direction i
C     INCEL(I)       = element number increment for direction i
C     INC(I)         = node number increment for direction i
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (MP=27,NC=3)
      DIMENSION ITEMP(MP),NEL(NC),INCEL(NC),INC(NC),IA(1)
      CHARACTER LABEL*78
C
      NDIM=IGETPA('NSPAR','NDIM  ',0)
      IEN=IODEV('IENAR')
 100  CONTINUE
      CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
      IF(IEND.GT.0) RETURN
      IF(INDEX(LABEL,'END').NE.0) RETURN
      READ(LABEL,*,END=4000,ERR=4000) N,MATPRG,LSECT,NG
      CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
      IF(IEND.GT.0) RETURN
      CALL IZERO(ITEMP,NENOD)
      READ(LABEL,*,END=4000,ERR=4000) (ITEMP(I),I=1,NENOD)
      WRITE(IEN,REC=N) MATPRG,LSECT,(ITEMP(I),I=1,NENOD)
      DO 180 I=1,NENOD
         NOD=ITEMP(I)
         NNOD=MAX(NNOD,NOD)
         IA(NOD)=IA(NOD)+1
 180  CONTINUE
      IF (NG.GT.0) THEN
C
C ------ generate data -------------
C     
         CALL REREC(LABEL,IIN,IOUT,IEND,IECHO)
         IF(IEND.GT.0) RETURN
         CALL IZERO(NEL,NC)
         CALL IZERO(INCEL,NC)
         CALL IZERO(INC,NC)
         READ(LABEL,*,END=4000,ERR=4000) 
     &        (NEL(I),INCEL(I),INC(I),I=1,NDIM)
         CALL GENEL1(NEL,INCEL,INC,IEN,NENOD,N,MATPRG,LSECT,IA,NNOD)
      END IF
      GOTO 100
C
 4000 CONTINUE
      WRITE(IOUT,5000)
      STOP
 5000 FORMAT(' *** ERROR *** IN GENEL ')
      END
C***********************************************************************
      SUBROUTINE GENEL1(NEL,INCEL,INC,IEN,NENOD,N,MATPRG,LSECT,IA,NNOD)
C=======================================================================
C.... Program to generate element node and material numbers
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION NEL(1),INCEL(1),INC(1),IA(1)
C
C --- set defaults
C
      CALL GENELD(NEL,INCEL,INC)
C
C --- generation algorithm
C
      IE = N
      JE = N
      KE = N
C
      II = NEL(1)
      JJ = NEL(2)
      KK = NEL(3)
C
      DO 300 K=1,KK
         DO 200 J=1,JJ
            DO 100 I=1,II
               IF (I.NE.II) THEN
                  LE = IE
                  IE = LE + INCEL(1)
               CALL GENELI(IEN,IE,LE,INC(1),NENOD,MATPRG,LSECT,IA,NNOD)
               ENDIF
 100        CONTINUE
C
            IF (J.NE.JJ) THEN
               LE = JE
               JE = LE + INCEL(2)
               CALL GENELI(IEN,JE,LE,INC(2),NENOD,MATPRG,LSECT,IA,NNOD)
               IE = JE
            ENDIF
 200     CONTINUE
C
         IF (K.NE.KK) THEN
            LE = KE
            KE = LE + INCEL(3)
            CALL GENELI(IEN,KE,LE,INC(3),NENOD,MATPRG,LSECT,IA,NNOD)
            IE = KE
            JE = KE
         ENDIF
 300  CONTINUE
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE GENELI(IEN,IE,LE,INC,NENOD,MATPRG,LSECT,IA,NNOD)
C=======================================================================
C.... Program to increment element node numbers
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION ITMP(27),IA(1)
C
      NELPR = IGETPA('NSPAR','NELPR',0)
	IF(NELPR.LE.0) NELPR = 1000
      CALL IZERO(ITMP,NENOD)
      READ(IEN,REC=LE) MI,LI,(ITMP(I),I=1,NENOD)
      DO 100 I=1,NENOD
         IF(ITMP(I).EQ.0) THEN
            ITMP(I) = 0
         ELSE
           ITMP(I) = ITMP(I) + INC
         END IF
  100 CONTINUE
      DO 200 I=1,NENOD
         NOD=ITMP(I)
         NNOD=MAX(NNOD,NOD)
         IA(NOD)=IA(NOD)+1
 200  CONTINUE
      WRITE(IEN,REC=IE) MATPRG,LSECT,(ITMP(I),I=1,NENOD)
	IF((MOD(IE,NELPR).EQ.0).AND.(IE.GE.NELPR)) THEN
	   WRITE(*,5000) IE
	END IF
C
 5000 FORMAT(' Generating element ',I8)
      END
C***********************************************************************
      SUBROUTINE GENELD(NEL,INCEL,INC)
C=======================================================================
C.... Program to set defaults for element node
C        and material number generation
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION NEL(1),INCEL(1),INC(1)
C
      IF (NEL(1).EQ.0) NEL(1) = 1
      IF (NEL(2).EQ.0) NEL(2) = 1
      IF (NEL(3).EQ.0) NEL(3) = 1
C
      IF (INCEL(1).EQ.0) INCEL(1) = 1
      IF (INCEL(2).EQ.0) INCEL(2) = NEL(1)
      IF (INCEL(3).EQ.0) INCEL(3) = NEL(1)*NEL(2)
C
      IF (INC(1).EQ.0) INC(1) = 1
      IF (INC(2).EQ.0) INC(2) = (1+NEL(1))*INC(1)
      IF (INC(3).EQ.0) INC(3) = (1+NEL(2))*INC(2)
C
      RETURN
      END
C****-END-OF-FILE-******************************************************
