C***********************************************************************
      SUBROUTINE ELEMNT(A,U,F,IA,TASK)
C=======================================================================
C     Program to call element routines
C=======================================================================
      IMPLICIT NONE
      DOUBLE PRECISION A(*),U(*),F(*)
      INTEGER          IA(*)
      CHARACTER*78     TASK
C --- local variables --------------------------------------------------
      INTEGER          NELG,NEQ,NBAND,NE,NETYP,NG,NGG,
     &                 IGETPA,IPLOT,IODEV,I
C
      NELG  = IGETPA('NSPAR','NELG ',0)
      NEQ   = IGETPA('NSPAR','NEQ  ',0)
      NBAND = IGETPA('NSPAR','NBAND',0)
C
      NE = 0
      DO NG = 1,NELG
         NETYP = IGETPA('NEPAR','NETYP',NG)
         NGG   = NG
         IF(NETYP.EQ.1) THEN
            CALL DIFF(A,U,F,IA,NGG,NE,TASK)
         ELSE IF(NETYP.EQ.2) THEN
            CALL SOLID(A,U,F,IA,NGG,NE,TASK)
         ELSE IF(NETYP.EQ.3) THEN
            CALL TRUSS(A,U,F,IA,NGG,NE,TASK)
         ELSE IF(NETYP.EQ.4) THEN
            CALL BEAM(A,U,F,IA,NGG,NE,TASK)
         ELSE IF(NETYP.EQ.6) THEN
            CALL ARCH(A,U,F,IA,NGG,NE,TASK)
         ELSE IF(NETYP.EQ.10) THEN
            CALL RMPL(A,U,F,IA,NGG,NE,TASK)
         ELSE IF(NETYP.EQ.11) THEN
            CALL MITC(A,U,F,IA,NGG,NE,TASK)
         END IF
      END DO
C
      IF(INDEX(TASK,'COMPUTE').NE.0) THEN
         IPLOT = IODEV('PLOT')
         WRITE(IPLOT,'(1X,78A1)') ('=',I=1,78)
      END IF
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE ASSEM(A,IA,E,LM,NE,NEL)
C=======================================================================
C     driver for calling appropriate assembly routine
C=======================================================================
      IMPLICIT NONE
      INTEGER IA(*),LM(*),NE,NEL
      DOUBLE PRECISION A(*),E(*)
C --- locals -----------------------------------------------------------
      INTEGER IMETH,ISYM,IODEV,IGETPA,NEQ,NBAND,ISTMO,NELPR,NELE,IOUT
	DOUBLE PRECISION PRNEL
C
      IOUT  = IODEV('OUTPU')
      IMETH = IGETPA('NSPAR','IMETH',0)
      ISTMO = IGETPA('NSPAR','ISTMO',0)
      ISYM  = IGETPA('NSPAR','ISYM ',0)
      NEQ   = IGETPA('NSPAR','NEQ  ',0)
      NBAND = IGETPA('NSPAR','NBAND',0)
	NELPR = IGETPA('NSPAR','NELPR',0)
	NELE  = IGETPA('NSPAR','NELE ',0)
	IF(NELPR.LE.0) NELPR = 1000

      IF(IMETH.EQ.0) THEN
         IF(ISYM.EQ.1) THEN
            CALL BSASS(A,E,LM,NBAND,NEQ,NE)
         ELSE
            CALL BUASS(A,E,LM,NBAND,NEQ,NE)
         END IF
      ELSE
         IF(ISTMO.EQ.4) THEN
            CALL SRASS(A,IA,IA(NEQ+2),E,LM,NE)
         ELSE IF(ISTMO.EQ.7) THEN
            CALL SDASS(A,IA,E,LM,NE,NEQ,NBAND)
         END IF
      END IF
	IF((MOD(NEL,NELPR).EQ.0).AND.(NEL.GE.NELPR)) THEN
	    PRNEL = REAL(NEL)/REAL(NELE)*100.D0
		WRITE(*,5000) NEL,PRNEL
	END IF
C
5000  FORMAT(' Assembled element ',I8,3X,F5.1,' %') 
      END
C***********************************************************************
      SUBROUTINE SRASS(GK,IRS,ICN,EK,LM,NEDOF)
C=======================================================================
C     Program for assembly of global matrices 
C     stored in compressed sparse row format (CSR)
C=======================================================================
      INTEGER          IRS(*),ICN(*),LM(*)
      DOUBLE PRECISION GK(*),EK(NEDOF,NEDOF)
C --- local variables --------------------------------------------------
      INTEGER          ISYM,I,IROW,J,ICOL,IB,IE,K
C
      ISYM = IGETPA('NSPAR','ISYM ',0)
C
      DO 500 I = 1,NEDOF
         IROW = LM(I)
         IF(IROW.GT.0) THEN
            DO 400 J = 1,NEDOF
               ICOL = LM(J)
               IF(ICOL.GT.0) THEN
                  IF((ISYM.NE.1).OR.(ICOL.LE.IROW)) THEN
                     IB = IRS(IROW)
                     IE = IRS(IROW+1) - 1
                     DO 200 K = IB,IE
                        IF(ICOL.EQ.ICN(K)) THEN
                           GK(K) = GK(K) + EK(I,J)
                           GOTO 300
                        END IF
 200                 CONTINUE
 300                 CONTINUE
                  END IF
               END IF
 400        CONTINUE
         END IF
 500  CONTINUE
C
      END
C***********************************************************************
      SUBROUTINE SDASS(G,IDP,E,LM,NR,N,NB)
C=======================================================================
C     Program for assembly of global matrices stored in comp diag format
C=======================================================================
      IMPLICIT NONE
      INTEGER           IDP(*),LM(*),NR,N,NB
      DOUBLE PRECISION  G(N,NB),E(NR,1)
C --- locals -----------------------------------------------------------
      INTEGER           ISYM,I,J,K,IROW,ICOL,IGETPA
C
      ISYM = IGETPA('NSPAR','ISYM ',0)
C
      DO 500 I=1,NR
         IROW=LM(I)
         IF(IROW.GT.0) THEN
            DO 400 J=1,NR
               ICOL=LM(J)
               IF(ICOL.GT.0) THEN
                  IF((ISYM.NE.1).OR.(ICOL.LE.IROW)) THEN
                     DO 200 K=1,NB
                        IF((ICOL-IROW).EQ.IDP(K)) THEN
                           G(IROW,K)=G(IROW,K)+E(I,J)
                           GOTO 300
                        END IF
 200                 CONTINUE
 300                 CONTINUE
                  END IF
               END IF
 400        CONTINUE
         END IF
 500  CONTINUE
C
      END
C***********************************************************************
      SUBROUTINE BSASS(GK,EK,LM,NBAND,NEQ,NEDOF)
C=======================================================================
C     Program for assembly of global matrices in symmetric band format
C=======================================================================
      IMPLICIT NONE
      INTEGER          LM(*),NEDOF,NEQ,NBAND
      DOUBLE PRECISION GK(NBAND,*),EK(NEDOF,NEDOF)
C --- local variables --------------------------------------------------
      INTEGER          I,II,J,K,L
C
      DO 300 K = 1,NEDOF
         I = LM(K)
         IF(I.NE.0) THEN
C           column number J
            DO 200 L = 1,NEDOF
               J = LM(L)
               IF(J.NE.0) THEN
                  II = I - J + 1
                  IF((II.GE.1).AND.(II.LE.NBAND)) THEN
                     GK(II,J) = GK(II,J) + EK(K,L)
                  END IF
               END IF
 200        CONTINUE
         END IF
 300  CONTINUE
C
      END
C***********************************************************************
      SUBROUTINE BUASS(GK,EK,LM,NBAND,NEQ,NEDOF)
C=======================================================================
C     Program for assembly of global matrices in unsymmetric band format
C=======================================================================
      IMPLICIT NONE
      INTEGER          LM(*),NEDOF,NEQ,NBAND
      DOUBLE PRECISION GK(NBAND,*),EK(NEDOF,NEDOF)
C --- local variables --------------------------------------------------
      INTEGER          I,II,J,K,L,NU
C
C     row number I
C
      NU = NBAND/2
C
      DO 300 K = 1,NEDOF
         I = LM(K)
         IF(I.NE.0) THEN
C           column number J
            DO 200 L = 1,NEDOF
               J = LM(L)
               IF(J.NE.0) THEN
                  II = NU + 1 + I - J
                  IF((II.GE.1).AND.(II.LE.NBAND)) THEN
                     GK(II,J) = GK(II,J) + EK(K,L)
                  END IF
               END IF
 200        CONTINUE
         END IF
 300  CONTINUE
C
      END
C***********************************************************************
      SUBROUTINE ADDRHS(GF,EF,LM,NEDOF)
C=======================================================================
C.... Program to add element residual-force vector to
C        global right-hand-side vector
C=======================================================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION GF(*),EF(*),LM(*)
C
      DO J=1,NEDOF
         K = LM(J)
         IF (K.GT.0) GF(K) = GF(K) + EF(J)
      END DO
C
      END
C***********************************************************************
      SUBROUTINE COORD(XYZ,NDIM,LEN,NENOD)
C=======================================================================
C     Program to get element node coordinates
C=======================================================================
      IMPLICIT NONE
      INTEGER          NDIM,LEN(*),NENOD
      DOUBLE PRECISION XYZ(NENOD,*)
C --- local variables --------------------------------------------------
      CHARACTER*78     LABEL
      INTEGER          ICORD,I,NODE,J,IODEV
C
      LABEL = 'COORD'
      ICORD = IODEV(LABEL)
      DO 120 I = 1,NENOD
         NODE = LEN(I)
         READ(ICORD,REC=NODE) (XYZ(I,J),J=1,NDIM)
 120  CONTINUE
C
      END
C***********************************************************************
      SUBROUTINE BTDB(ESM,B,D,NR,MB,MD,ND)
C=======================================================================
C     Program to form B(transpose)DB
C=======================================================================
      IMPLICIT NONE
      INTEGER          NR,MB,MD,ND
      DOUBLE PRECISION ESM(NR,*),B(MB,*),D(MD,*)
C --- local variables --------------------------------------------------
      INTEGER          I,J,K,L
C
      DO 160 J=1,NR
         DO 140 L=1,ND
            DO 120 K=1,ND
               DO 100 I=1,NR
                  ESM(I,J)=ESM(I,J)+B(K,I)*D(K,L)*B(L,J)
 100           CONTINUE
 120        CONTINUE
 140     CONTINUE
 160  CONTINUE
C
      END
C***********************************************************************
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C-***-END-OF-FILE-******************************************************
