C***********************************************************************
      SUBROUTINE DIRSOL(A,U,F,IA,N,NB,IMETH,ISYM,NX,IOUT)
C=======================================================================
C     Driver program for direct linear system solvers
C=======================================================================
      IMPLICIT NONE
      INTEGER          IA(*),N,NB,IMETH,ISYM,NX,IOUT
      DOUBLE PRECISION A(*),U(*),F(*)
      INTEGER          NL,NU,INFO
C
      IF(IMETH.EQ.-1) THEN
	   IF(ISYM.EQ.1) THEN
            NL=NB-1
            CALL FACBBC('L',N,NL,A,NB,INFO)
C            CALL DPBTF2('L',N,NL,A,NB,INFO)
            IF(INFO.EQ.0) THEN
               CALL DCOPY(N,F,1,U,1)
C               CALL DPBTRS('L',N,NL,NX,A,NB,U,N,INFO)
C               CALL BACBCH(A,NB,N,U,F,NX)
            ELSE
               WRITE(*,*) 'Error in Cholesky decomposition'
               STOP
            END IF
	   ELSE
	      WRITE(IOUT,'('' Nonexistent solver IMETH = '',I4)') IMETH
            STOP	
         END IF
      ELSE IF(IMETH.EQ.0) THEN
         IF(ISYM.EQ.1) THEN
            WRITE(IOUT,'('' ---- Band Cholesky factorization '')')
            CALL FACBCH(A,NB,N,IOUT)
            CALL BACBCH(A,NB,N,U,F,NX)
         ELSE
            NU = NB/2
            NL = NU
            WRITE(IOUT,'('' ---- Band LU factorization '')')
            CALL FACBLU(A,NB,N,NU,NL,IOUT)
            CALL BACBLU(A,NB,N,NU,NL,U,F,NX)
         END IF
      ELSE IF(IMETH.EQ.1) THEN
         WRITE(IOUT,'('' Nonexistent solver IMETH = '',I4)') IMETH
         STOP
C ---------- profile solvers will be soon available -----
C         IF(ISYM.EQ.1) THEN
C            CALL FACSCH(A,IA,N,IOUT)
C            CALL BACSCH(A,IA,N,U,F,1)
C         ELSE
C            CALL FACSLU(A,IA,N,IOUT)
C            CALL BACSLU(A,IA,N,U,F,1)
C         END IF
      ELSE 
         WRITE(IOUT,'('' Nonexistent solver IMETH = '',I4)') IMETH
         STOP
      END IF
C
      END
C***********************************************************************
