C***********************************************************************
      SUBROUTINE DIFF(A,U,F,IA,NG,NE,TASK)
C=======================================================================
C     Program to set up things related to diffusion model
C=======================================================================
      IMPLICIT NONE
      DOUBLE PRECISION A(*),U(*),F(*)
      INTEGER          IA(*),NG,NE
      CHARACTER*78     TASK
C --- local variables --------------------------------------------------
      INTEGER          ME,ID,IEN,NEQ,NDIM,NBAND,NEL,NENOD,NDOF,NEDOF
      INTEGER          IEQEL,NA,NU,N,MAT,LSE,J,IPLOT,IODEV,IGETPA
      PARAMETER       (ME=20) 
      DOUBLE PRECISION XYZ(3*ME),EK(ME*ME)
      INTEGER          LM(ME),LEN(ME)
C
      ID  = IODEV('IDARR')
      IEN = IODEV('IENAR')
C
      NEQ   = IGETPA('NSPAR','NEQ  ',0)
      NDIM  = IGETPA('NSPAR','NDIM ',0)
      NBAND = IGETPA('NSPAR','NBAND',0)
      NEL   = IGETPA('NEPAR','NEL  ',NG)
      NENOD = IGETPA('NEPAR','NENOD',NG)
      NDOF  = IGETPA('NEPAR','NDOF ',NG)
      IEQEL = IGETPA('NEPAR','IEQEL',NG)
      NEDOF = NENOD*NDOF
C
      IF(INDEX(TASK,'FORM-MATRIX').NE.0)  THEN
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            IF((IEQEL.NE.1).OR.(N.EQ.1)) THEN
               CALL COORD(XYZ,NDIM,LEN,NENOD)
               CALL DIFFK(EK,XYZ,NENOD,NDIM,MAT,LSE,NG,NE)
            END IF
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL ASSEM(A,IA,EK,LM,NEDOF,NE)
         END DO
      ELSE IF(INDEX(TASK,'LOAD').NE.0) THEN
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            CALL COORD(XYZ,NDIM,LEN,NENOD)
            CALL DIFFS(EK,XYZ,NENOD,NDOF,NDIM,MAT,LSE,NG,NE)
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL ADDRHS(F,EK,LM,NEDOF)
         END DO
      ELSE IF(INDEX(TASK,'COMPUTE').NE.0)  THEN
         IPLOT=IODEV('PLOT ') 
         WRITE(IPLOT,5000) NG
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            CALL COORD(XYZ,NDIM,LEN,NENOD)
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL DIFFR(U,XYZ,NENOD,LM,NDIM,MAT,LSE,NG,NE)
         END DO
      END IF
C
 5000 FORMAT(' Element group ',I3,' Heat transfer ',/,
     &       ' Element ip  XYZ coordinates  and Fluxes ')
      END
C***********************************************************************
      SUBROUTINE DIFFK(EK,XYZ,NENOD,NDIM,MAT,LSE,NG,N)
C=======================================================================
C     Program to set up the stiffness matrix for diffusion model
C=======================================================================
      IMPLICIT NONE
      DOUBLE PRECISION EK(*),XYZ(*)
      INTEGER          NENOD,NDIM,MAT,LSE,NG,N
C --- local variables --------------------------------------------------
      INTEGER          MW,MD,MN,NIP,IDEG,ITR,NSK,IP,ISK,IOUT,IODEV
      PARAMETER       (MW=9,MD=3,MN=20)
      DOUBLE PRECISION WGTH(MW),SK(MD*MW),B(MD*MN),C(MD*MD),FN(MN),
     &                 DN(MN,3),DNLX(MN),DNLY(MN),DNLZ(MN),DET,WT
      CHARACTER*78     LABEL
C
      IOUT=IODEV('OUTPU')
C
      CALL INTPNT(SK,WGTH,NIP,NENOD,IDEG,ITR,NDIM,NSK,NG)
      CALL FZERO(EK,NENOD*NENOD)
C
      DO 400 IP=1,NIP
         ISK=(IP-1)*NSK+1
         CALL INTFUN(XYZ,SK(ISK),FN,DN,DN(1,2),DN(1,3)
     &        ,DNLX,DNLY,DNLZ,DET,NDIM,ITR,NENOD,N,IOUT)
C
C ------ set up gradient matrix B and diffusivity matrix C and ----
C ------ form the diffusive part of the stiffness matrix       ----
C
         CALL FZERO(B,NDIM*NENOD)
         CALL BMDIFF(B,DN,NDIM,MN,NENOD)
         CALL CMDIFF(C,NDIM,MAT)
         WT=WGTH(IP)*DET
         CALL DSCAL(NDIM*NDIM,WT,C,1)
         CALL BTDB(EK,B,C,NENOD,NDIM,NDIM,NDIM)
C
C ------ convection and reaction terms  ----
C
         CALL CONV(NENOD,EK,FN,DN,MN,NDIM,MAT,WT)
         CALL REAC(NENOD,EK,FN,MAT,WT)
 400  CONTINUE
C
C      CALL DCSTAB(EK,XYZ,NENOD,NDIM,MAT)
C
      END
C***********************************************************************
      SUBROUTINE BMDIFF(B,DN,NDIM,MN,NOD)
C=======================================================================
C     Program to form the B-matrix (gradient) for diffusion model
C=======================================================================
      IMPLICIT NONE
      INTEGER          NDIM,MN,NOD
      DOUBLE PRECISION B(NDIM,*),DN(MN,*)
C --- locals -----------------------------------------------------------
      INTEGER          I,J
C
      DO 160 J = 1, NOD
         DO 140 I = 1, NDIM
            B(I,J) = -DN(J,I)
 140     CONTINUE
 160  CONTINUE
C
      END
C***********************************************************************
      SUBROUTINE CMDIFF(C,NDIM,MAT)
C=======================================================================
C     Program to set up constitutive parameters for a diffusion problem
C=======================================================================
      IMPLICIT NONE
      INTEGER          NDIM,MAT
      DOUBLE PRECISION C(NDIM,1)
C --- locals -----------------------------------------------------------
      INTEGER          I,IODEV,IOUT
      DOUBLE PRECISION FGETPA,CP(3),ZERO
      PARAMETER        (ZERO = 0.D0)
C
      CALL FZERO(C,NDIM*NDIM)
      CP(1) = FGETPA('CPARA','CONDX',MAT)
C
      IF(CP(1).LE.ZERO) THEN
         IOUT = IODEV('OUTPU')
         WRITE(IOUT,5000) MAT
         STOP
      END IF
C
      IF(NDIM.GE.2) THEN
         CP(2) = FGETPA('CPARA','CONDY',MAT)
         IF(CP(2).LE.ZERO) CP(2) = CP(1)
         IF(NDIM.GE.3) THEN
            CP(3) = FGETPA('CPARA','CONDZ',MAT)
            IF(CP(3).LE.ZERO) CP(3) = CP(1)
         END IF
      END IF
C
      DO 100 I = 1, NDIM
         C(I,I) = CP(I)
 100  CONTINUE
C
 5000 FORMAT(' *** ERROR *** Zero conductivity - Material set = ',I5)
      END
C***********************************************************************
      SUBROUTINE CONV(NENOD,EK,F,DF,MN,NDIM,MAT,WT)
C=======================================================================
C     Program to add the convective part to the element matrix
C=======================================================================
      IMPLICIT NONE 
      INTEGER          NENOD,MN,NDIM,MAT
      DOUBLE PRECISION EK(NENOD,*),F(*),DF(MN,*),WT
C --- locals -----------------------------------------------------------
      INTEGER          N,I,J
      DOUBLE PRECISION VELO(3),FGETPA
C
      VELO(1) = FGETPA('CPARA','VELOX',MAT)
      VELO(2) = FGETPA('CPARA','VELOY',MAT)
      VELO(3) = FGETPA('CPARA','VELOZ',MAT)
C
      DO N = 1, NDIM
         DO J=1,NENOD
            DO I=1,NENOD
               EK(I,J) = EK(I,J) + VELO(N)*F(I)*DF(J,N)*WT
            END DO
         END DO
      END DO
C
      END
C***********************************************************************
      SUBROUTINE REAC(NENOD,E,F,MAT,WT)
C=======================================================================
C     Program to add the reaction part to the element matrix
C=======================================================================
      IMPLICIT NONE 
      INTEGER          NENOD,MAT
      DOUBLE PRECISION E(NENOD,*),F(*),WT
C --- locals -----------------------------------------------------------
      INTEGER          I,J
      DOUBLE PRECISION REACC,FGETPA
C
      REACC = FGETPA('CPARA','REACC',MAT)
C
      DO J=1,NENOD
         DO I=1,NENOD
            E(I,J) = E(I,J) + REACC*WT*F(I)*F(J)
         END DO
      END DO
C
      END
C***********************************************************************
      SUBROUTINE DIFFR(U,XYZ,NENOD,LM,NDIM,MAT,LSE,NG,N)
C=======================================================================
C     Program to compute and output flux for diffusion model
C=======================================================================
      IMPLICIT NONE
      INTEGER          NENOD,LM(*),NDIM,MAT,LSE,NG,N
      DOUBLE PRECISION U(*),XYZ(NENOD,*)
C --- local variables --------------------------------------------------
      INTEGER          MW,MD,MN,IP,NIP,IDEG,ITR,NSK,ISK,I,
     &                 IOUT,IPLOT,IODEV
      PARAMETER       (MW=9,MD=3,MN=20)
      DOUBLE PRECISION WGTH(MW),SK(MD*MW),B(MD*MN),C(MD*MD),FN(MN),
     &                 DN(MN,3),DNLX(MN),DNLY(MN),DNLZ(MN),COORD(3),
     &                 DET,DDOT,UL(MN),FLUX(3),GRAD(3)
      CHARACTER*78     LABEL
C
      IOUT  = IODEV('OUTPU')
      IPLOT = IODEV('PLOT ')
C
      CALL INTPNT(SK,WGTH,NIP,NENOD,IDEG,ITR,NDIM,NSK,NG)
C
      CALL FZERO(UL,NENOD)
      CALL GETELV(UL,U,LM,NENOD)
C
      DO 400 IP=1,NIP
         ISK=(IP-1)*NSK+1
         CALL INTFUN(XYZ,SK(ISK),FN,DN,DN(1,2),DN(1,3)
     &        ,DNLX,DNLY,DNLZ,DET,NDIM,ITR,NENOD,N,IOUT)
         CALL FZERO(B,NDIM*NENOD)
         CALL BMDIFF(B,DN,NDIM,MN,NENOD)
         CALL CMDIFF(C,NDIM,MAT)
         CALL FZERO(GRAD,NDIM)
         CALL MULTF(GRAD,B,UL,NDIM,NDIM,NENOD)
         CALL FZERO(FLUX,NDIM)
         CALL MULTF(FLUX,C,GRAD,NDIM,NDIM,NDIM)
C
C ------ add convective part to the flux  ----
         CALL CFLUX(NDIM,NENOD,FLUX,FN,UL,MAT)
C
         DO 200 I=1,NDIM
            COORD(I)=DDOT(NENOD,XYZ(1,I),1,FN,1)
 200     CONTINUE
         WRITE(IPLOT,5100) N,IP,(COORD(I),I=1,NDIM),(FLUX(I),I=1,NDIM)
 400  CONTINUE
C
 5100 FORMAT(1X,I6,I3,6(1P,E11.3))
      END
C***********************************************************************
      SUBROUTINE CFLUX(NDIM,NENOD,Q,F,U,MAT)
C=======================================================================
C     Program to add the convective part to the flux vector
C=======================================================================
      IMPLICIT NONE 
      INTEGER          NDIM,NENOD,MAT
      DOUBLE PRECISION Q(*),F(*),U(*)
C --- locals -----------------------------------------------------------
      INTEGER          I
      DOUBLE PRECISION VELO(3),UU,FGETPA,DDOT
C
      VELO(1) = FGETPA('CPARA','VELOX',MAT)
      VELO(2) = FGETPA('CPARA','VELOY',MAT)
      VELO(3) = FGETPA('CPARA','VELOZ',MAT)
C
      UU = DDOT(NENOD,U,1,F,1)
      DO I = 1, NDIM
         Q(I) = Q(I) + VELO(I)*UU
      END DO
C
      END
C***********************************************************************
      SUBROUTINE DIFFS(EF,XYZ,NENOD,NDOF,NDIM,MAT,LSE,NG,N)
C=======================================================================
C     Program to set up the element load vector for diffusion model
C=======================================================================
      IMPLICIT NONE
      INTEGER          NENOD,NDOF,NDIM,MAT,LSE,NG,N
      DOUBLE PRECISION EF(*),XYZ(NENOD,*)
C --- locals -----------------------------------------------------------
      INTEGER          MW,MEDOF,MD,NB,NS,MN
      PARAMETER       (MW=16,MEDOF=20,MN=20,MD=3,NB=3,NS=2)
      INTEGER          IOUT,IODEV,IGETPA,I,IP,ISK,IRED,IX,IY,II,LOAD,
     &                 IDEG,ITR,NIX,NIY,NIP,NEDOF,NSK
      DOUBLE PRECISION WGTH(MW),SK(MD*MW),Q(MEDOF),FN(MN),DN(MN,3),
     &                 DNLX(MN),DNLY(MN),DNLZ(MN),
     &                 SFLX(MN),SFLY(MN),DET,WT,FGETPA,QQ,DDOT
      CHARACTER*78     LABEL
C
      IOUT=IODEV('OUTPU')
      LOAD=IODEV('ELOAD')
C
      CALL INTPNT(SK,WGTH,NIP,NENOD,IDEG,ITR,NDIM,NSK,NG)
C
      NEDOF = NENOD*NDOF
C
      CALL FZERO(EF,NEDOF)
C
      READ(LOAD, REC = N, ERR = 100) (Q(I), I = 1, NENOD)
      DO IP = 1, NIP
         ISK=(IP-1)*NSK+1
         CALL INTFUN(XYZ,SK(ISK),FN,DN,DN(1,2),DN(1,3)
     &        ,DNLX,DNLY,DNLZ,DET,NDIM,ITR,NENOD,N,IOUT)
         WT = WGTH(IP)*DET
         QQ = DDOT(NENOD,FN,1,Q,1)
         DO I = 1, NENOD
            EF(I) = EF(I) + QQ*WT*FN(I)
         END DO
      END DO
C
 100  CONTINUE
      END
C***********************************************************************
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C-***-END-OF-FILE-******************************************************
