C***********************************************************************
      SUBROUTINE BEAM(A,U,F,IA,NG,NE,TASK)
C=======================================================================
C     Program to set up things related to beam model
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (ME=20) 
      DIMENSION A(*),U(*),F(*),IA(*),LM(ME),LEN(ME),XYZ(3*ME),EK(ME*ME)
      CHARACTER*78 TASK
C
      ID  = IODEV('IDARR')
      IEN = IODEV('IENAR')
C
      NEQ   = IGETPA('NSPAR','NEQ  ',0)
      NDIM  = IGETPA('NSPAR','NDIM ',0)
      NBAND = IGETPA('NSPAR','NBAND',0)
      IMETH = IGETPA('NSPAR','IMETH',0)
      NEL   = IGETPA('NEPAR','NEL  ',NG)
      NENOD = IGETPA('NEPAR','NENOD',NG)
      NDOF  = IGETPA('NEPAR','NDOF ',NG)
      IEQEL = IGETPA('NEPAR','IEQEL',NG)
      NEDOF = NENOD*NDOF
C
      IF(INDEX(TASK,'FORM-MATRIX').NE.0)  THEN
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            IF((IEQEL.NE.1).OR.(N.EQ.1)) THEN
               CALL COORD(XYZ,NDIM,LEN,NENOD)
               CALL BEAMK(EK,XYZ,NENOD,NDOF,NDIM,MAT,LSE,NG,NE)
            END IF
C
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL ASSEM(A,IA,EK,LM,NEDOF,NE)
         END DO
      ELSE IF(INDEX(TASK,'LOAD').NE.0) THEN
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            CALL COORD(XYZ,NDIM,LEN,NENOD)
            CALL BEAMLO(EK,XYZ,NENOD,NDOF,NDIM,NG,NE)
C
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL ADDRHS(F,EK,LM,NEDOF)
         END DO
      ELSE IF(INDEX(TASK,'COMPUTE').NE.0)  THEN
         IPLOT=IODEV('PLOT') 
         WRITE(IPLOT,5000) NG
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            CALL COORD(XYZ,NDIM,LEN,NENOD)
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL BEAMR(U,XYZ,NENOD,LM,NDOF,MAT,LSE,NG,NE)
         END DO
      END IF
C
 5000 FORMAT(' Element group ',I3,' ---- 2D-BEAM elements',/,
     &       ' Elem   node  Axial force   Bending moment')
      END
C***********************************************************************
      SUBROUTINE BEAMK(EK,XYZ,NENOD,NDOF,NDIM,MAT,LSE,NG,N)
C=======================================================================
C     Program to set up the stiffness matrix for beam model
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (MW=3,NEDOF=6,NB=2)
      DIMENSION EK(1),XYZ(1)
      DIMENSION WGTH(MW),SK(MW),B(NB*NEDOF)
      DIMENSION FUX(NEDOF),FVXX(NEDOF),C(NB*NB)
      CHARACTER*78 LABEL
C
      IOUT=IODEV('OUTPU')
C
      NIP=IGETPA('NEPAR','NIX  ',NG)
      CALL GAUSSP(SK,WGTH,NIP)
      CALL FZERO(EK,NEDOF*NEDOF)
      EE=FGETPA('CPARA','EX   ',MAT)
      AA=FGETPA('SPARA','AA   ',LSE)
      HI=FGETPA('SPARA','IZ   ',LSE)
C
      DX=XYZ(2)-XYZ(1)
      DY=XYZ(4)-XYZ(3)
      XLL=SQRT(DX*DX+DY*DY)
      DET=0.5D0*XLL
      DETINV=1.D0/DET
      SI=DY/XLL
      CO=DX/XLL
C
      DO 400 IP=1,NIP
         C(1)=EE*AA
         C(4)=EE*HI
         X=SK(IP)
         CALL SIFL(X,FUX,1,1,IOUT)
         CALL DSCAL(2,DETINV,FUX,1)
         CALL SIFHER(X,FVXX,DETINV,2)
         CALL FZERO(B,NB*NEDOF)
         CALL BMBEAM(B,NB,FUX,FVXX,SI,CO)
         WT=WGTH(IP)*DET
         CALL DSCAL(4,WT,C,1)
         CALL BTDB(EK,B,C,NEDOF,NB,NB,NB)
 400  CONTINUE

      END
C***********************************************************************
      SUBROUTINE BMBEAM(B,NB,DU,DDV,SI,CO)
C=======================================================================
C     Program to form the B-matrix for 2D-beam
C     transformation from global to local
C=======================================================================
      IMPLICIT NONE
      INTEGER          NB
      DOUBLE PRECISION B(NB,*),DU(*),DDV(*),SI,CO
C
      B(1,1) =  CO*DU(1)
      B(2,1) =  SI*DDV(1)
      B(1,2) =  SI*DU(1)
      B(2,2) = -CO*DDV(1)
      B(2,3) =    -DDV(2)
      B(1,4) =  CO*DU(2)
      B(2,4) =  SI*DDV(3)
      B(1,5) =  SI*DU(2)
      B(2,5) = -CO*DDV(3)
      B(2,6) =    -DDV(4)
C
      END
C***********************************************************************
      SUBROUTINE BEAMR(U,XYZ,NENOD,LM,NDOF,MAT,LSE,NG,N)
C=======================================================================
C     Program to compute internal forces of beam element
C=======================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (MW=3,NEDOF=6,NB=2,NBUB=4)
      DIMENSION U(*),XYZ(*),LM(*)
      DIMENSION WGTH(MW),SK(MW),B(NB*NEDOF),UL(NEDOF)
      DIMENSION FUX(NEDOF),FVXX(NEDOF+NBUB),C(NB*NB),EPS(NB),RSIG(NB)
      DIMENSION EPSF(NB),EPSH(NB),BL(NB*NBUB),EU(NBUB)
      CHARACTER*78 LABEL
C
      IOUT  = IODEV('OUTPU')
      IPLOT = IODEV('PLOT ') 
C
C --- evaluate forces at nodes Xi = -1 and +1
C
      NIP    = MW
      SK(1)  = -1.D0
      SK(2)  =  0.D0
      SK(3)  =  1.D0
      EE     = FGETPA('CPARA','EX   ',MAT)
      AA     = FGETPA('SPARA','AA   ',LSE)
      HI     = FGETPA('SPARA','IZ   ',LSE)
C
      DX     = XYZ(2) - XYZ(1)
      DY     = XYZ(4) - XYZ(3)
      XLL    = SQRT(DX*DX + DY*DY)
      DET    = 0.5D0*XLL
      DETINV = 1.D0/DET
      SI     = DY/XLL
      CO     = DX/XLL
C
      CALL BPART(EU,C,DET,NBUB,NENOD,N,MAT,LSE)
C
      C(1)   = EE*AA
      C(4)   = EE*HI
C
      CALL FZERO(UL,NEDOF)
      CALL GETELV(UL,U,LM,NEDOF)
C
      DO IP = 1, NIP
         X = SK(IP)
         CALL HI1LAG(X,FUX,3,1,IOUT)
         CALL HI1HER(X,FVXX,DETINV,5,2)
         CALL DSCAL(NB+2,DETINV,FUX,1)
         CALL FZERO(B,NB*NEDOF)
         CALL FZERO(BL,NB*NBUB)
         CALL BMBEAM(B,NB,FUX,FVXX,SI,CO)
         CALL BMHBEA(BL,NB,FUX,FVXX,3,5)
C
         CALL FZERO(EPSH,NB)
         CALL FZERO(EPSF,NB)
         CALL MULTF(EPSF,BL,EU,NB,NB,NBUB)
         CALL MULTF(EPSH,B,UL,NB,NB,NEDOF)
         DO I = 1, NB
            EPS(I) = EPSH(I) + EPSF(I)
         END DO
         CALL FZERO(RSIG,NB)
         CALL MULTF(RSIG,C,EPS,NB,NB,NB)
C
         IF(IP.EQ.1) THEN
            II = 1
         ELSE IF(IP.EQ.NIP) THEN
            II = 2
         ELSE
            II = 0
         END IF
C
         WRITE(IPLOT,5100) N,II,(RSIG(I),I=1,2)
      END DO
C
 5100 FORMAT(1X,I6,I4,4(1PE14.5))
      END
C***********************************************************************
      SUBROUTINE BPART(EU,C,DET,NBUB,NENOD,N,MAT,LSE)
C=======================================================================
C     Compute the particular solution for the Euler-Bernoulli beam elem
C=======================================================================
      IMPLICIT NONE
      INTEGER          NBUB,NENOD,N,MAT,LSE
      DOUBLE PRECISION EU(*),C(*),DET
C --- locals -----------------------------------------------------------
      INTEGER          IOUT,LOAD,IODEV,ML,MN,MIP,MK,I,IP,J,NB
      PARAMETER       (ML=2,MN=6,MK=4,MIP=4,NB=2)
      DOUBLE PRECISION QX(ML),QY(ML),EK(MK,MK),EF(MK),FUX(MN),FVXX(MN),
     &                 SK(MIP),WGTH(MIP),B(NB*MK),FU(MN),FV(MN),FGETPA,
     &                 EE,AA,HI,DX,DY,XLL,DETINV,X,WT,QQX,QQY,DDOT
C
      IOUT = IODEV('OUTPU')
      LOAD = IODEV('ELOAD')
C
      READ(LOAD, REC = N, ERR = 100) (QX(I),QY(I), I = 1, NENOD)

      CALL GAUSSP(SK,WGTH,MIP)
C
      CALL FZERO(EK,MK*MK)
      CALL FZERO(EU,NBUB)
      CALL FZERO(EF,MK)
C
      EE = FGETPA('CPARA','EX   ',MAT)
      AA = FGETPA('SPARA','AA   ',LSE)
      HI = FGETPA('SPARA','IZ   ',LSE)
C
      DETINV=1.D0/DET
C
      DO IP = 1, MIP
         C(1) = EE*AA
         C(4) = EE*HI
         X    = SK(IP)
         CALL HI1LAG(X,FU,3,0,IOUT)
         CALL HI1LAG(X,FUX,3,1,IOUT)
         CALL DSCAL(4,DETINV,FUX,1)
         CALL HI1HER(X,FV,DETINV,5,0)
         CALL HI1HER(X,FVXX,DETINV,5,2)
         CALL FZERO(B,NB*NBUB)
         CALL BMHBEA(B,NB,FUX,FVXX,3,5)
         WT = WGTH(IP)*DET
         CALL DSCAL(4,WT,C,1)
         CALL BTDB(EK,B,C,MK,NB,NB,NB)
C
         QQX = DDOT(NENOD,FU,1,QX,1)
         QQY = DDOT(NENOD,FU,1,QY,1)
C
         DO I = 1, 2
            EF(I)   = EF(I)   + QQX*WT*FU(2+I)
            EF(2+I) = EF(2+I) + QQY*WT*FV(4+I)
         END DO
      END DO
C 
C --- solve the local system (orthogonal modes) --------
C
      DO I = 1,MK
         EU(I) = EF(I)/EK(I,I)
      END DO
C
 100  CONTINUE
C     
      END
C***********************************************************************
      SUBROUTINE BMHBEA(B,NB,DU,DDV,IU,IV)
C=======================================================================
C     Program to form the B-matrix for 2D-beam -- hierarchical part
C=======================================================================
      IMPLICIT NONE
      INTEGER          NB,IU,IV,I
      DOUBLE PRECISION B(NB,*),DU(*),DDV(*)
C
C --- only hierarchical terms ---
C
      DO I = 1, IU - 1
         B(1,I) = DU(I + 2)
      END DO
      DO I = 1, IV - 3
         B(2,IU-1+I) = -DDV(I + 4)
      END DO
C
      END
C***********************************************************************
      SUBROUTINE BEAMLO(EF,XY,NENOD,NDOF,NDIM,NG,N)
C=======================================================================
C     Program to add distributed loads
C=======================================================================
      IMPLICIT NONE
      INTEGER          NENOD,NDOF,NDIM,NG,N
      DOUBLE PRECISION EF(*),XY(*)
C --- locals -----------------------------------------------------------
      INTEGER          MW,MEDOF,MN
      PARAMETER       (MW=4,MEDOF=6,MN=4)
      INTEGER          IOUT,IODEV,IGETPA,I,IP,ISK,IRED,IX,IY,II,LOAD,
     &                 IDEG,ITR,NIX,NIY,NIP,NEDOF,NSK,NISX,NISY,NISP
      DOUBLE PRECISION WGTH(MW),SK(MW),QX(MN),QY(MN),
     &                 FU(2),FUX(MN),FV(MN),DX,DY,XLL,SI,CO,DETINV,
     &                 DET,WT,FGETPA,QQX,QQY,DDOT,X
      CHARACTER*78     LABEL
C
      IOUT = IODEV('OUTPU')
      LOAD = IODEV('ELOAD')
C
      NIP   = MW
      NEDOF = NENOD*NDOF
C
      CALL FZERO(EF,NEDOF)
      CALL GAUSSP(SK,WGTH,NIP)
C
      DX  = XY(2)-XY(1)
      DY  = XY(4)-XY(3)
      XLL = SQRT(DX*DX+DY*DY)
      DET = 0.5D0*XLL
      SI  = DY/XLL
      CO  = DX/XLL
      DETINV = 1.D0/DET
C
      READ(LOAD, REC = N, ERR = 100) (QX(I),QY(I), I = 1, NENOD)
C
      DO IP = 1, NIP
         X = SK(IP)
         CALL SIFL(X,FU,1,0,IOUT)
         CALL SIFHER(X,FV,DETINV,0)
C
         WT  = WGTH(IP)*DET
         QQX = DDOT(NENOD,FU,1,QX,1)
         QQY = DDOT(NENOD,FU,1,QY,1)
C
         DO I = 1, NENOD
            EF(NDOF*(I-1)+1) = EF(NDOF*(I-1)+1) + QQX*WT*FU(I)
            EF(NDOF*(I-1)+2) = EF(NDOF*(I-1)+2) + QQY*WT*FV(2*(I-1)+1)
            EF(NDOF*(I-1)+3) = EF(NDOF*(I-1)+3) + QQY*WT*FV(2*I)
         END DO
      END DO
C
      CALL TRANV(EF,SI,CO,NENOD,NDOF,1)
C
 100  CONTINUE
      END
C***********************************************************************
      SUBROUTINE TRANV(B,SI,CO,NPE,NLDF,II)
C=======================================================================
C     Program to transform vector B from
C     II .eq. 0  global to local coordinate system or if
C     II .ne. 0  local to global
C=======================================================================
      IMPLICIT NONE
      INTEGER          NPE,NLDF,II
      DOUBLE PRECISION B(*),SI,CO
C --- local variables --------------------------------------------------
      INTEGER          N1,N2,M
      DOUBLE PRECISION SS,R1,R2
C
      IF(II.EQ.0) THEN
        SS = -1.0
      ELSE
        SS =  1.0
      END IF
C
      DO M = 1, NPE
         N1 = 1 + (M-1)*NLDF
         N2 = N1 + 1
         R1 = B(N1)
         R2 = B(N2)
         B(N1) =    R1*CO - SS*R2*SI
         B(N2) = SS*R1*SI +    R2*CO
      END DO
C
      END
C***********************************************************************
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C-***-END-OF-FILE-******************************************************
