
C***********************************************************************
      SUBROUTINE FACBBC( UPLO, N, KD, AB, LDAB, INFO )
C=======================================================================
C
C=======================================================================
      CHARACTER          UPLO
      INTEGER            INFO, KD, LDAB, N
      DOUBLE PRECISION   AB( LDAB, * )
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
      INTEGER            NBMAX, LDWORK
      PARAMETER          ( NBMAX = 128, LDWORK = NBMAX+1 )
*     .. Local Scalars ..
      INTEGER            I, I2, I3, IB, II, J, JJ, NB
*     .. Local Arrays ..
      DOUBLE PRECISION   WORK( LDWORK, NBMAX )
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ILAENV
      EXTERNAL           LSAME, ILAENV
*     .. External Subroutines ..
      EXTERNAL           DGEMM, DSYRK, DTRSM, XERBLA, FACBCH
C	EXTERNAL           DPBTF2, DPOTF2
*     .. Intrinsic Functions ..
      INTRINSIC          MIN
*
      UPLO='L'
      INFO = 0
      NB = MIN(N,NBMAX, KD)
*     The block size must not exceed the semi-bandwidth KD, and must not
*     exceed the limit set by the size of the local array WORK.
      NB = MIN( NB, NBMAX )
      IF( NB.LE.1 .OR. NB.GT.KD ) THEN
*        Use unblocked code
         WRITE(*,*) 'Using unblocked code'
         CALL FACBCH(AB,N,KD+1,6)
      ELSE
*        Use blocked code
         WRITE(*,*) 'Using block code NB =',NB
         DO 90 J = 1, NB
            DO 80 I = J + 1, NB
               WORK( I, J ) = ZERO
 80         CONTINUE
 90      CONTINUE
*
*        Process the band matrix one diagonal block at a time.
*
         DO 140 I = 1, N, NB
            IB = MIN( NB, N-I+1 )
*
*           Factorize the diagonal block
*
C            CALL DPOTF2( UPLO, IB, AB( 1, I ), LDAB-1, II )
            IF( II.NE.0 ) THEN
               INFO = I + II - 1
               GO TO 150
            END IF
            IF( I+IB.LE.N ) THEN
*                 Update the relevant part of the trailing submatrix.
*                 If A11 denotes the diagonal block which has just been
*                 factorized, then we need to update the remaining
*                 blocks in the diagram:
*                    A11
*                    A21   A22
*                    A31   A32   A33
*                 The numbers of rows and columns in the partitioning
*                 are IB, I2, I3 respectively. The blocks A21, A22 and
*                 A32 are empty if IB = KD. The lower triangle of A31
*                 lies outside the band.
               I2 = MIN( KD-IB, N-I-IB+1 )
               I3 = MIN( IB, N-I-KD+1 )
*
               IF( I2.GT.0 ) THEN
*                 Update A21
                  CALL DTRSM( 'Right', 'Lower', 'Transpose',
     $                 'Non-unit', I2, IB, ONE, AB( 1, I ),
     $                 LDAB-1, AB( 1+IB, I ), LDAB-1 )
*                 Update A22
                  CALL DSYRK( 'Lower', 'No Transpose', I2, IB, -ONE,
     $                 AB( 1+IB, I ), LDAB-1, ONE,
     $                 AB( 1, I+IB ), LDAB-1 )
               END IF
               IF( I3.GT.0 ) THEN
*                 Copy the upper triangle of A31 into the work array.
                  DO 110 JJ = 1, IB
                     DO 100 II = 1, MIN( JJ, I3 )
                        WORK( II, JJ ) = AB( KD+1-JJ+II, JJ+I-1 )
 100                 CONTINUE
 110              CONTINUE
*                 Update A31 (in the work array).
                  CALL DTRSM( 'Right', 'Lower', 'Transpose',
     $                 'Non-unit', I3, IB, ONE, AB( 1, I ),
     $                 LDAB-1, WORK, LDWORK )
*                 Update A32
                  IF( I2.GT.0 )
     $                 CALL DGEMM( 'No transpose', 'Transpose', I3, I2,
     $                 IB, -ONE, WORK, LDWORK,
     $                 AB( 1+IB, I ), LDAB-1, ONE,
     $                 AB( 1+KD-IB, I+IB ), LDAB-1 )
*                 Update A33
                  CALL DSYRK( 'Lower', 'No Transpose', I3, IB, -ONE,
     $                 WORK, LDWORK, ONE, AB( 1, I+KD ),
     $                 LDAB-1 )
*                 Copy the upper triangle of A31 back into place.
                  DO 130 JJ = 1, IB
                     DO 120 II = 1, MIN( JJ, I3 )
                        AB( KD+1-JJ+II, JJ+I-1 ) = WORK( II, JJ )
 120                 CONTINUE
 130              CONTINUE
               END IF
            END IF
 140     CONTINUE
      END IF
      RETURN
*
  150 CONTINUE
      RETURN
      END
C****-END-OF-FILE-******************************************************
