C***********************************************************************
      SUBROUTINE FACBLU(A,NB,N,NU,NL,IOUT)
C=======================================================================
C     Program for LU factorization of a band matrix
C     Column oriented kji-version
C-----------------------------------------------------------------------
C     Algorithm:    for k = 1 to n-1
C                       for s = k+1 to n
C                           l_sk = a_sk / a_kk
C                       for j = k+1 to n
C                           for i = k+1 to n
C                               a_ij = a_ij - l_ik * a_kj
C-----------------------------------------------------------------------
C     Calling parameters:
C     A    : array storing a N x N matrix in a band format
C     NB   : bandwidth = NU + 1 + NL
C     N    : dimension of the system
C     NU   : bandwidth of the upper triangular part of A
C     NL   : bandwidth of the lower triangular part of A
C     IOUT : output unit number
C=======================================================================
      IMPLICIT NONE
      INTEGER          N,NB,NL,NU,IOUT
      DOUBLE PRECISION A(NB,N)
C --- local variables --------------------------------------------------
      INTEGER          I,J,K,ND,I1,I2,KK,L,IK,KN
      DOUBLE PRECISION C,ZERO
      PARAMETER       (ZERO = 0.D0)
C
      ND = NU + 1
      DO 180 K = 1, N - 1
         IF( A(ND,K) .EQ. ZERO ) THEN
            WRITE(IOUT,5000) K
            STOP
         END IF
         C = 1.D0 / A(ND,K)
         DO 120 L = NU + 2, NB
            A(L,K) = C*A(L,K)
 120     CONTINUE
         KN = MIN(K+NU,N)
         DO 160 J = K + 1, KN
            KK = NU + K - J + 1
            I1 = MAX(1,NU+2+K-J)
            I2 = NB + K - J
            C  = A(KK,J)
            DO 140 I = I1, I2
               IK = I + J - K
               A(I,J) = A(I,J) - A(IK,K)*C
 140        CONTINUE
 160     CONTINUE
 180  CONTINUE
C     
 5000 FORMAT(' *** ERROR **** Singular matrix ',/
     &       ' zero diagonal in equation ',I6)
      END
C***********************************************************************
      SUBROUTINE BACBLU(A,NB,N,NU,NL,X,V,NX)
C=======================================================================
C     Reduction of load vector and solution by backsubstitution
C     of an unsymmetric band matrix --- column oriented version
C=======================================================================
      IMPLICIT NONE 
      INTEGER          NB,N,NX,NU,NL
      DOUBLE PRECISION A(NB,N),X(N,NX),V(N,NX)
C --- local variables --------------------------------------------------
      INTEGER          I,J,K,L,ND,II,I2
      DOUBLE PRECISION C
C
      ND = NU + 1
      CALL DCOPY(N*NX,V,1,X,1)
C
C --- right hand side reduction
C
      DO 160 L = 1,NX
         DO 140 K = 1, N - 1
            I2 = MIN(NB,N-K+NU+1)
            DO 120 II = NU + 2, I2
               I      = II + K - NU - 1
               X(I,L) = X(I,L) - A(II,K)*X(K,L)
 120        CONTINUE
 140     CONTINUE
 160  CONTINUE
C
C --- back substitution by column sweep algorithm 
C
      DO 260 L = 1, NX
         DO 240 J = N, 1, -1
            C      = 1.D0 / A(ND,J)
            X(J,L) = C*X(J,L) 
            I2     = MAX(1,NU+2-J)
            DO 220 II = I2, NU
               I      = II + J - NU - 1
               X(I,L) = X(I,L) - X(J,L)*A(II,J)
 220        CONTINUE
 240     CONTINUE
 260  CONTINUE
C
      END
C***********************************************************************
      SUBROUTINE FACBCH(A,NB,N,IOUT)
C=======================================================================
C     Program for Cholesky factorization of a band matrix
C     column oriented jki-version -- lower part of the matrix stored
C-----------------------------------------------------------------------
C     Algorithm:   l_11 = sqrt(a_11)
C                  for j = 2 to n
C                      for s = j to n
C                          l_s,j-1 = a_s,j-1 / l_j-i,j-1
C                      for k = 1 to j-1
C                          for i = j to n
C                              a_ij = a_ij - l_ik * l_jk
C                      l_jj = sqrt(a_jj)                       
C-----------------------------------------------------------------------
C     Calling parameters:
C     A    : array storing a N x N matrix in a band format
C     NB   : (half)bandwidth including diagonal
C     N    : dimension of the system
C     IOUT : output unit number
C=======================================================================
      IMPLICIT NONE
      INTEGER          N,NB,IOUT
      DOUBLE PRECISION A(NB,N)
C --- local variables --------------------------------------------------
      INTEGER          I,J,K,I1,JK,L,IK,K1
      DOUBLE PRECISION C,ZERO
      PARAMETER       (ZERO = 0.D0)
C
      IF( A(1,1) .LE. ZERO ) THEN
         WRITE(IOUT,5000) 1
         STOP
      END IF
      A(1,1) = DSQRT(A(1,1))
C
      DO 180 J = 2, N 
         DO 120 L =  2, NB
            A(L,J-1) = A(L,J-1) / A(1,J-1)
 120     CONTINUE
         K1 = MAX(1,J-NB+1)
         DO 160 K = K1, J - 1
            JK = J - K + 1
            C  = A(JK,K)
            I1 = NB + K - J 
            DO 140 I = 1, I1
               IK     = I + J - K
               A(I,J) = A(I,J) - A(IK,K)*C
 140        CONTINUE
 160     CONTINUE
      IF( A(1,J) .LE. ZERO ) THEN
         WRITE(IOUT,5000) J
         STOP
      END IF
      A(1,J) = DSQRT(A(1,J))
 180  CONTINUE
C     
 5000 FORMAT(' *** ERROR **** Matrix not positive definite ',/
     &       ' non-positive diagonal in equation ',I6)
      END
C***********************************************************************
      SUBROUTINE BACBCH(A,NB,N,X,V,NX)
C=======================================================================
C     Reduction of load vector and solution by backsubstitution
C     of a symmetric band matrix --- column oriented version
C     for the Cholesky factorization
C=======================================================================
      IMPLICIT NONE 
      INTEGER          NB,N,NX
      DOUBLE PRECISION A(NB,N),X(N,NX),V(N,NX)
C --- local variables --------------------------------------------------
      INTEGER          I,J,K,L,II,I2
      DOUBLE PRECISION C
C
      CALL DCOPY(N*NX,V,1,X,1)
C
C --- right hand side reduction
C
      DO 160 L = 1,NX
         X(1,L) = X(1,L) / A(1,1)
         DO 140 K = 1, N - 1
	      I2 = MIN(N-K+1,NB)
            DO 120 II = 2, I2
               I      = II + K - 1
               X(I,L) = X(I,L) - A(II,K)*X(K,L)
 120        CONTINUE
            X(K+1,L) = X(K+1,L) / A(1,K+1)
 140     CONTINUE
 160  CONTINUE
C
C --- back substitution 
C
      DO 260 L = 1, NX
         X(N,L) = X(N,L) / A(1,N)
         DO 240 J = N - 1, 1, -1
            I2 = MIN(N-J+1,NB)
            DO 220 II = 2, I2
               I      = II + J - 1
               X(J,L) = X(J,L) - X(I,L)*A(II,J)
 220        CONTINUE
            X(J,L) = X(J,L) / A(1,J)
 240     CONTINUE
 260  CONTINUE
C
      END
C***********************************************************************

C****-END-OF-FILE-******************************************************
