C***********************************************************************
      SUBROUTINE ARCH(A,U,F,IA,NG,NE,TASK)
C=======================================================================
C     Program to set up things related to arch model
C=======================================================================
      IMPLICIT NONE
      INTEGER          IA(*)
      DOUBLE PRECISION A(*),U(*),F(*)
C --- locals -----------------------------------------------------------
      INTEGER          ME
      PARAMETER       (ME=20) 
      INTEGER          LM(ME),LEN(ME),
     &                 ID,IEN,IMETH,IEQEL,IPLOT,IODEV,IGETPA,J,
     &                 N,NE,NEL,NEQ,NDIM,NBAND,NEDOF,NDOF,NENOD,NG,
     &                 MAT,LSE
      DOUBLE PRECISION XYZ(3*ME),EK(ME*ME)
      CHARACTER*78 TASK
C
      ID  = IODEV('IDARR')
      IEN = IODEV('IENAR')
C
      NEQ   = IGETPA('NSPAR','NEQ  ',0)
      NDIM  = IGETPA('NSPAR','NDIM ',0)
      NBAND = IGETPA('NSPAR','NBAND',0)
      IMETH = IGETPA('NSPAR','IMETH',0)
      NEL   = IGETPA('NEPAR','NEL  ',NG)
      NENOD = IGETPA('NEPAR','NENOD',NG)
      NDOF  = IGETPA('NEPAR','NDOF ',NG)
      IEQEL = IGETPA('NEPAR','IEQEL',NG)
      NEDOF = NENOD*NDOF
C
      IF(INDEX(TASK,'FORM-MATRIX').NE.0)  THEN
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            IF((IEQEL.NE.1).OR.(N.EQ.1)) THEN
               CALL COORD(XYZ,NDIM,LEN,NENOD)
               CALL ARCHK(EK,XYZ,NENOD,NDOF,MAT,LSE,NG,NE)
            END IF
C
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL ASSEM(A,IA,EK,LM,NEDOF,NE)
         END DO
      ELSE IF(INDEX(TASK,'LOAD').NE.0)  THEN
C -------- possibility to distributed load not yet available ---
      ELSE IF(INDEX(TASK,'COMPUTE').NE.0)  THEN
         IPLOT=IODEV('PLOT') 
         WRITE(IPLOT,5000) NG
         DO N=1,NEL
            NE=NE+1
            READ(IEN,REC=NE) MAT,LSE,(LEN(J),J=1,NENOD)
            CALL COORD(XYZ,NDIM,LEN,NENOD)
            CALL FORMLM(LM,LEN,ID,NENOD,NDOF)
            CALL ARCHR(U,XYZ,NENOD,LM,NDOF,MAT,LSE,NG,NE)
         END DO
      END IF
C
 5000 FORMAT(' Element group ',I3,' ---- 2D-Isoparametric arch elem',/)
      END
C***********************************************************************
      SUBROUTINE ARCHK(EK,XYZ,NENOD,NDOF,MAT,LSE,NG,N)
C=======================================================================
C     Program to set up the stiffness matrix for isoparam arch element
C=======================================================================
      IMPLICIT NONE
      INTEGER          NENOD,NDOF,MAT,LSE,NG,N
      DOUBLE PRECISION EK(*),XYZ(NENOD,*)
C --- locals -----------------------------------------------------------
      INTEGER          MW,MEDOF,MNOD,NB
      PARAMETER       (MW=3,MEDOF=12,MNOD=4,NB=3)
      DOUBLE PRECISION WGTX(MW),WGTY(MW),SKX(MW),SKY(MW),B(NB*MEDOF),
     &                 P(MNOD),DXI(MNOD),C(NB*NB),D(NB*NB),T(NB*NB),
     &                 DNX(MNOD),DNY(MNOD),DXV(MNOD),DYV(MNOD),
     &                 SI(MNOD),CO(MNOD),DET,ETA,BB,TH,TH2,XI,SS,CC,
     &                 PSI(MNOD),WT,FGETPA,TCK(MNOD),BR(MNOD),DDOT
      INTEGER          NEDOF,NIX,NIY,IDEG,IX,IY,IOUT,IELD,IGETPA,IODEV,I
      CHARACTER*78     LABEL
C ----------------------------------------------------------------------
C
      IOUT = IODEV('OUTPU')
      IELD = IODEV('ELDAT')
C
      NEDOF = NENOD*NDOF
      NIX   = IGETPA('NEPAR','NIX  ',NG)
      NIY   = IGETPA('NEPAR','NIY  ',NG)
      IDEG  = NENOD - 1
C
      CALL GAUSSP(SKX,WGTX,NIX)
      CALL GAUSSP(SKY,WGTY,NIY)
C
      CALL FZERO(EK,NEDOF*NEDOF)
C
      CALL SECDAT(NENOD,PSI,TCK,BR,IELD,N,LSE)
C
      DO I = 1, NENOD
         CO(I) = DCOS(PSI(I))
         SI(I) = DSIN(PSI(I))
      END DO
C
      DO IX = 1, NIX
         XI = SKX(IX)
         CALL SIFL(XI,P,IDEG,0,IOUT)
         CALL SIFL(XI,DXI,IDEG,1,IOUT)
         TH  = DDOT(NENOD,P,1,TCK,1)
         BB  = DDOT(NENOD,P,1,BR,1)
         TH2 = 0.5D0*TH
         DO IY = 1, NIY
            ETA = SKY(IY)
            CALL AJACO(ETA,TH2,XYZ,XYZ(1,2),P,DXI,DNX,DNY
     &           ,DXV,DYV,DET,CO,SI,SS,CC,NENOD,N,IOUT)
            CALL FZERO(B,NB*NEDOF)
            CALL CMARCH(D,NB,MAT)
            CALL BMARCH(B,NB,DNX,DNY,DXV,DYV,SI,CO,NENOD)
            CALL FZERO(C,NB*NB)
            CALL TRANS(NB,T,SS,CC)
            CALL BTDB(C,T,D,NB,NB,NB,NB)
            WT = WGTX(IX)*WGTY(IY)*BB*DET
            CALL DSCAL(NB*NB,WT,C,1)
            CALL BTDB(EK,B,C,NEDOF,NB,NB,NB)
         END DO
      END DO

      END
C***********************************************************************
      SUBROUTINE BMARCH(B,NB,DNX,DNY,DXV,DYV,SI,CO,NOD)
C=======================================================================
C     Program to form the B-matrix for 2D-isop arch element
C=======================================================================
      IMPLICIT NONE
      INTEGER          NB,NOD
      DOUBLE PRECISION B(NB,*),DNX(*),DNY(*),DXV(*),DYV(*),SI(*),CO(*)
C --- locals -----------------------------------------------------------
      INTEGER          I,I3
C
      I3 = 0
      DO I = 1, NOD
         I3 = I3 + 3
         B(1,I3-2) =  DNX(I)
         B(1,I3-1) =  0.D0
         B(1,I3)   = -SI(I)*DXV(I)
         B(2,I3-2) =  0.D0
         B(2,I3-1) =  DNY(I)
         B(2,I3)   =  CO(I)*DYV(I)
         B(3,I3-2) =  DNY(I)
         B(3,I3-1) =  DNX(I)
         B(3,I3)   = -SI(I)*DYV(I) + CO(I)*DXV(I)
      END DO
C
      END
C***********************************************************************
      SUBROUTINE CMARCH(C,NC,MAT)
C=======================================================================
C     Program to set up constitutive parameters for an arch element
C=======================================================================
      IMPLICIT NONE
      INTEGER          NC,MAT
      DOUBLE PRECISION C(NC,*)
C --- locals -----------------------------------------------------------
      DOUBLE PRECISION EX,PR,GG,FGETPA
C
      CALL FZERO(C,NC*NC)
C
      EX  = FGETPA('CPARA','EX   ',MAT)
      PR  = FGETPA('CPARA','PRX  ',MAT)
      GG  = 0.5D0*EX/(1.D0 + PR)
C
      C(1,1) = EX
      C(3,3) = GG
C
      END
C***********************************************************************
      SUBROUTINE AJACO(ETA,H2,X,Y,P,DKSI,DNX,DNY
     &     ,DXV,DYV,DET,CO,SI,SS,CC,NOD,N,IOUT)
C=======================================================================
C     Routine to compute the Jacobian matrix and global derivatives
C=======================================================================
      IMPLICIT NONE
      INTEGER          NOD,N,IOUT
      DOUBLE PRECISION ETA,H2,X(*),Y(*),P(*),DKSI(*),DNX(*),DNY(*),
     &                 DXV(*),DYV(*),DET,CO(*),SI(*),SS,CC
C --- locals -----------------------------------------------------------
      INTEGER          K
      DOUBLE PRECISION XJ11,XJ12,XJ21,XJ22,PK,DKS,DUM,CHAN
C
      XJ11 = 0.
      XJ12 = 0.
      XJ21 = 0.
      XJ22 = 0.
C
      DO K = 1, NOD
         PK   = P(K)
         DKS  = DKSI(K) 
         XJ11 = XJ11 + DKS*X(K) + ETA*H2*DKS*CO(K)
         XJ12 = XJ12 + DKS*Y(K) + ETA*H2*DKS*SI(K)
         XJ21 = XJ21 + H2*PK*CO(K)  
         XJ22 = XJ22 + H2*PK*SI(K)  
      END DO
C
C --- local x axis is parallel to the xi-line tangent
C
      DUM = DSQRT(XJ11*XJ11 + XJ12*XJ12) 
      CC  = XJ11/DUM 
      SS  = XJ12/DUM
      DET = XJ11*XJ22 - XJ21*XJ12 
C
      IF(DET.GT.0.00000001) THEN
         DUM  =  1.D0 / DET  
         CHAN =  XJ11
         XJ11 =  XJ22*DUM
         XJ12 = -XJ12*DUM
         XJ21 = -XJ21*DUM
         XJ22 =  CHAN*DUM
C
         DO K = 1, NOD
            PK  = P(K)
            DKS = DKSI(K) 
            DNX(K) = XJ11*DKS
            DNY(K) = XJ21*DKS
            DXV(K) = H2*(XJ12*PK + ETA*DNX(K))
            DYV(K) = H2*(XJ22*PK + ETA*DNY(K))
         END DO
      ELSE
         WRITE(IOUT,2000) N,XJ11,XJ12,XJ21,XJ22,DET
         WRITE(IOUT,'('' X '',4(1P,E11.4))') (X(K),K=1,NOD)
         WRITE(IOUT,'('' Y '',4(1P,E11.4))') (Y(K),K=1,NOD)
         WRITE(IOUT,'('' DXI '',8E9.2)') (DKSI(K),K=1,NOD) 
         STOP  
      END IF
C
 2000 FORMAT(' *** ERROR *** Nonpositive Jacobian at element ',I6,/,
     &       ' Elements of the Jacobian matrix',/,4(1P,E12.4),/,
     &       ' Determinant',1P,E12.4)
      END
C***********************************************************************
      SUBROUTINE TRANS(NT,T,SS,CC)
C=======================================================================
C     Transformation matrix for stresses and strains in 2-D
C=======================================================================
      IMPLICIT NONE
      INTEGER          NT
      DOUBLE PRECISION T(NT,*),SS,CC
C --- locals -----------------------------------------------------------
      DOUBLE PRECISION S2,C2,SC
C
      S2=SS*SS
      C2=CC*CC
      SC=SS*CC
C
      T(1,1) =  C2
      T(2,1) =  S2
      T(3,1) = -2.D0*SC
      T(1,2) =  S2
      T(2,2) =  C2
      T(3,2) =  2.D0*SC
      T(1,3) =  SC
      T(2,3) = -SC
      T(3,3) =  C2 - S2
C
      END
C***********************************************************************
      SUBROUTINE SECDAT(NOD,PSI,TCK,BR,IELD,N,LSE)
C=======================================================================
C     To set up director, thickness and bread of the cross-section
C=======================================================================
      IMPLICIT NONE
      INTEGER          NOD,IELD,N,LSE,I
      DOUBLE PRECISION PSI(*),TCK(*),BR(*),FGETPA,BB,TH
C
      IF(LSE.GT.0) THEN
         READ(IELD,REC=N) (PSI(I),I=1,NOD)
         TH = FGETPA('SPARA','THICK',LSE)
         BB = FGETPA('SPARA','WIDTH',LSE)
         DO I = 1, NOD
            TCK(I) = TH
            BR(I)  = BB
         END DO
      ELSE
         READ(IELD,REC=N) (PSI(I),BR(I),TCK(I),I=1,NOD)
      END IF
C
      END
C***********************************************************************
      SUBROUTINE ARCHR(U,XYZ,NENOD,LM,NDOF,MAT,LSE,NG,N)
C=======================================================================
C     Program to compute internal forces of beam element
C=======================================================================
      IMPLICIT NONE
      INTEGER          LM(*),NENOD,NDOF,MAT,LSE,NG,N
      DOUBLE PRECISION U(*),XYZ(NENOD,*)
C --- locals -----------------------------------------------------------
      INTEGER          MW,MEDOF,MNOD,NB
      PARAMETER       (MW=3,MEDOF=12,MNOD=4,NB=3)
      DOUBLE PRECISION WGTX(MW),WGTY(MW),SKX(MW),SKY(MW),B(NB*MEDOF),
     &                 P(MNOD),DXI(MNOD),D(NB*NB),T(NB*NB),
     &                 DNX(MNOD),DNY(MNOD),DXV(MNOD),DYV(MNOD),DDOT,
     &                 SI(MNOD),CO(MNOD),DET,ETA,BB,TH,TH2,XI,SS,CC,
     &                 PSI(MNOD),SIGL(NB),EPS(NB),EPSL(NB),UL(MEDOF),
     &                 Z,BT2,ZBT2,RN,RQ,RM,FGETPA,TCK(MNOD),BR(MNOD)
      INTEGER          NEDOF,NIX,NIY,IDEG,IX,IY,IOUT,IELD,IGETPA,IODEV,
     &                 IPLOT,I
      CHARACTER*78     LABEL
C ----------------------------------------------------------------------
C
      IPLOT = IODEV('PLOT')
      IOUT  = IODEV('OUTPU')
      IELD  = IODEV('ELDAT')
C
      NEDOF = NENOD*NDOF
      NIX   = IGETPA('NEPAR','NIX  ',NG)
      NIY   = IGETPA('NEPAR','NIY  ',NG)
      IDEG  = NENOD - 1
C
      CALL SECDAT(NENOD,PSI,TCK,BR,IELD,N,LSE)
C
      DO I = 1, NENOD
         CO(I) = DCOS(PSI(I))
         SI(I) = DSIN(PSI(I))
      END DO
C
      CALL GAUSSP(SKX,WGTX,NIX)
      CALL GAUSSP(SKY,WGTY,NIY)
C
      CALL FZERO(UL,NEDOF)
      CALL GETELV(UL,U,LM,NEDOF)
C
      DO IX = 1, NIX
         XI = SKX(IX)
         CALL SIFL(XI,P,IDEG,0,IOUT)
         CALL SIFL(XI,DXI,IDEG,1,IOUT)
         TH  = DDOT(NENOD,P,1,TCK,1)
         BB  = DDOT(NENOD,P,1,BR,1)
         TH2 = 0.5D0*TH
         BT2 = BB*TH2
C
C ------ stress resultants N,Q,M ----------
         RN = 0.D0
         RQ = 0.D0
         RM = 0.D0
C
         DO IY = 1, NIY
            ETA = SKY(IY)
            Z   = TH2*ETA
            CALL AJACO(ETA,TH2,XYZ,XYZ(1,2),P,DXI,DNX,DNY
     &           ,DXV,DYV,DET,CO,SI,SS,CC,NENOD,N,IOUT)
            CALL FZERO(B,NB*NEDOF)
            CALL CMARCH(D,NB,MAT)
            CALL BMARCH(B,NB,DNX,DNY,DXV,DYV,SI,CO,NENOD)
            CALL FZERO(EPS,NB)
            CALL MULTF(EPS,B,UL,NB,NB,NEDOF)
            CALL FZERO(EPSL,NB)
            CALL TRANS(NB,T,SS,CC)
            CALL MULTF(EPSL,T,EPS,NB,NB,NB)
            CALL FZERO(SIGL,NB)
            CALL MULTF(SIGL,D,EPSL,NB,NB,NB)
C
            WRITE(IPLOT,5100) N,IX,IY,(SIGL(I),I=1,NB)
            WRITE(IPLOT,5200) (EPSL(I),I=1,NB)
C
            ZBT2 = Z*BT2
            RN   = RN + BT2*SIGL(1)
            RQ   = RQ + BT2*SIGL(3)
            RM   = RM + ZBT2*SIGL(1)
         END DO
         WRITE(IPLOT,5300) N,IX,RN,RQ,RM
      END DO
C
 5100 FORMAT(1X,I6,2I4,4(1PE14.5))
 5200 FORMAT(15X,4(1PE14.5))
 5300 FORMAT(1X,I6,I4,4X,3(1P,E14.5))
      END
C***********************************************************************
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C-***-END-OF-FILE-******************************************************
